/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.container;

import com.nine.travelerscompass.common.item.TravelersCompassItem;
import com.nine.travelerscompass.config.cost.SearchCostHelper;
import com.nine.travelerscompass.config.filter.FilterManager;
import com.nine.travelerscompass.config.filter.FilterReason;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;

public class CompassContainer
implements Container {
    private final ItemStack containerStack;
    private final NonNullList<ItemStack> inventory;
    private final int maxStackSize;

    private CompassContainer(ItemStack containerStack, int inventorySize, int maxStackSize) {
        this.containerStack = containerStack;
        this.maxStackSize = maxStackSize;
        this.inventory = NonNullList.withSize((int)inventorySize, (Object)ItemStack.EMPTY);
        this.load();
    }

    public static CompassContainer container(ItemStack containerHolder) {
        return new CompassContainer(containerHolder, 9, 1);
    }

    public List<Item> getList() {
        ArrayList<Item> list = new ArrayList<Item>();
        for (int i = 0; i < 9; ++i) {
            Item item = this.getItem(i).getItem();
            if (item instanceof AirItem) continue;
            list.add(item);
        }
        return list;
    }

    public boolean hasAny(ItemStack itemStack) {
        for (int i = 0; i < 9; ++i) {
            if (!itemStack.is(this.getItem(i).getItem())) continue;
            return true;
        }
        return false;
    }

    public int getFirstEmptySlot() {
        for (int i = 0; i < 9; ++i) {
            if (!this.getItem(i).is(ItemStack.EMPTY.getItem())) continue;
            return i;
        }
        return 0;
    }

    public int getContainerSize() {
        return this.inventory.size();
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public void load() {
        ItemContainerContents container = (ItemContainerContents)this.containerStack.get(DataComponents.CONTAINER);
        if (container != null) {
            container.copyInto(this.inventory);
        }
    }

    public void save() {
        this.containerStack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.inventory));
    }

    public ItemStack removeItem(int index, int size) {
        ItemStack stack = this.getItem(index);
        if (!stack.isEmpty()) {
            if (stack.getCount() > size) {
                stack = stack.split(size);
                this.setChanged();
            } else {
                this.setItem(index, ItemStack.EMPTY);
            }
        }
        stack.setCount(0);
        return stack;
    }

    public ItemStack removeItemNoUpdate(int index) {
        ItemStack stack = this.getItem(index);
        this.setItem(index, ItemStack.EMPTY);
        return stack;
    }

    public void setItem(int index, ItemStack stack) {
        this.setItem(index, stack, null);
    }

    public void setItem(int index, ItemStack stack, Player player) {
        FilterReason reason;
        if (stack.getItem() instanceof TravelersCompassItem) {
            return;
        }
        if (stack == ItemStack.EMPTY) {
            this.inventory.set(index, (Object)stack);
            if (!stack.isEmpty() && stack.getCount() > this.getMaxStackSize()) {
                stack.setCount(this.getMaxStackSize());
            }
            this.setChanged();
        }
        if ((reason = FilterManager.getFilterReason(stack.getItem())) instanceof FilterReason.Allowed && (player == null || SearchCostHelper.consumeXp(player, stack.getItem()))) {
            this.inventory.set(index, (Object)stack);
            if (!stack.isEmpty() && stack.getCount() > this.getMaxStackSize()) {
                stack.setCount(this.getMaxStackSize());
            }
            this.setChanged();
        }
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public void setChanged() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            if (this.getItem(i).isEmpty() || this.getItem(i).getCount() != 0) continue;
            this.inventory.set(i, (Object)ItemStack.EMPTY);
        }
        this.save();
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void startOpen(Player player) {
    }

    public void stopOpen(Player player) {
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return true;
    }

    public void clearContent() {
        for (int i = 0; i < this.inventory.size(); ++i) {
            this.inventory.set(i, (Object)ItemStack.EMPTY);
        }
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.inventory) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

