/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button;

import com.nine.travelerscompass.client.component.button.BaseButton;
import com.nine.travelerscompass.client.component.element.NewPopupElement;
import com.nine.travelerscompass.client.utils.TextureData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_332;
import net.minecraft.class_768;

public class PopupButton
extends BaseButton {
    protected final TextureData popupConnector;
    protected final TextureData popup;
    protected final class_768 mainRect;
    protected final class_768 popupRect;
    private boolean popupVisible = false;
    protected List<NewPopupElement> popupElements = new ArrayList<NewPopupElement>();

    protected PopupButton(int x, int y, int width, int height, TextureData popupConnector, TextureData popupTexture, class_768 mainRect, class_768 popupRect) {
        super(x, y, width, height);
        this.mainRect = mainRect;
        this.popupRect = popupRect;
        this.popupConnector = popupConnector;
        this.popup = popupTexture;
    }

    protected int getPopupXOffset() {
        return 0;
    }

    protected int getPopupYOffset() {
        return 0;
    }

    protected int getConnectorXOffset() {
        return 0;
    }

    protected int getConnectorYOffset() {
        return 0;
    }

    protected boolean isPopupVisible() {
        return this.popupVisible && this.isEnabled();
    }

    protected boolean isEnabled() {
        return true;
    }

    private void updateRectsOffset() {
        this.mainRect.method_35779(this.method_46426(), this.method_46427());
        this.popupRect.method_35779(this.method_46426() + this.getPopupXOffset(), this.method_46427() + this.getPopupYOffset());
    }

    public void onPopupExit() {
    }

    public void onPopupEnter() {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int mX = (int)mouseX;
        int mY = (int)mouseY;
        if (this.isEnabled()) {
            if (this.popupRect.method_3318(mX, mY) && this.isPopupVisible()) {
                for (NewPopupElement popupElement : this.popupElements) {
                    popupElement.handleClick(mX, mY, button);
                }
            } else if (this.mainRect.method_3318(mX, mY)) {
                this.onMainButtonClick(button);
            }
            this.afterClick(button);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        int mX = (int)mouseX;
        int mY = (int)mouseY;
        if (this.isEnabled() && this.popupRect.method_3318(mX, mY) && this.isPopupVisible()) {
            for (NewPopupElement popupElement : this.popupElements) {
                popupElement.handleMouseScroll(mX, mY, delta);
            }
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    protected void onMainButtonClick(int button) {
    }

    protected void afterClick(int button) {
    }

    @Override
    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_48579(graphics, mouseX, mouseY, partialTicks);
        this.updateRectsOffset();
        if (this.mainRect.method_3318(mouseX, mouseY)) {
            if (!this.popupVisible) {
                this.onPopupEnter();
            }
            this.popupVisible = true;
        } else if (this.popupVisible && !this.popupRect.method_3318(mouseX, mouseY)) {
            this.onPopupExit();
            this.popupVisible = false;
        }
        this.renderIcon(graphics, mouseX, mouseY, partialTicks);
        if (this.isPopupVisible()) {
            this.renderPopup(graphics, mouseX, mouseY, partialTicks);
            for (NewPopupElement popupElement : this.popupElements) {
                popupElement.render(graphics, mouseX, mouseY, this.method_46426() + popupElement.getXOffset(), this.method_46427() + popupElement.getYOffset());
            }
        }
    }

    @Override
    protected void renderIcon(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
    }

    protected void renderPopup(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.method_25290(this.popupConnector.getLocation(), this.method_46426() + this.getConnectorXOffset(), this.method_46427() + this.getConnectorYOffset(), 0.0f, 0.0f, this.popupConnector.getRenderWidth(), this.popupConnector.getTextureHeight(), this.popupConnector.getRenderWidth(), this.popupConnector.getTextureHeight());
        graphics.method_25290(this.popup.getLocation(), this.method_46426() + this.getPopupXOffset(), this.method_46427() + this.getPopupYOffset(), 0.0f, 0.0f, this.popup.getRenderWidth(), this.popup.getTextureHeight(), this.popup.getRenderWidth(), this.popup.getTextureHeight());
    }
}

