/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button;

import com.nine.travelerscompass.client.ClientData;
import com.nine.travelerscompass.client.component.button.ToggleButton;
import com.nine.travelerscompass.client.component.button.Toggleable;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.client.utils.IconTexture;
import com.nine.travelerscompass.client.utils.TextureData;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.data.DataStorage;
import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_7919;

public class SearchModeButton
extends ToggleButton {
    private final DataStorage<Boolean> data;
    protected final IconTexture iconInactive;
    protected final IconTexture iconActive;
    private final class_1799 stack;
    private final boolean enabled;

    public SearchModeButton(int x, int y, int width, int height, boolean enabled, DataStorage<Boolean> data, IconTexture iconActive, IconTexture iconInactive, class_1799 stack) {
        super(x, y, width, height, ClientData.TOGGLE_BUTTON);
        this.data = data;
        this.stack = stack;
        this.iconActive = iconActive;
        this.iconInactive = iconInactive;
        this.enabled = enabled;
        this.field_22763 = enabled;
        this.setToggled(data.get(stack));
        this.refreshTooltip();
    }

    public void method_25348(double mouseX, double mouseY) {
        CompassProperties.toggleFromClient(this.stack, this.data);
        this.setToggled(this.data.get(this.stack));
        this.refreshTooltip();
    }

    @Override
    protected TextureData getBaseLayer() {
        return this.buttonTextures.get(this.toggled, this.field_22762, this.enabled);
    }

    @Override
    public void refreshTooltip() {
        class_2561 state;
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        String key = "tooltip.travelerscompass.search_mode." + this.data.getKey();
        class_5250 title = class_2561.method_43471((String)key);
        list.add((class_2561)title);
        if (this.enabled) {
            class_2561 class_25612 = state = this.isToggled() ? Toggleable.ENABLED : Toggleable.DISABLED;
            if (this.shiftPressed) {
                list.add((class_2561)class_2561.method_43473().method_10852(ClientUtils.DESC_ARROW).method_10852((class_2561)class_2561.method_43471((String)(key + ".desc")).method_27692(class_124.field_1080)));
            }
        } else {
            state = Toggleable.CONFIG_DISABLED;
        }
        list.add(state);
        this.method_47400(class_7919.method_47407((class_2561)ClientUtils.buildTooltip(list)));
    }

    @Override
    public void renderIcon(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        IconTexture icon = this.isToggled() ? this.iconActive : this.iconInactive;
        ClientUtils.renderTexture(graphics, icon, this.method_46426(), this.method_46427());
    }

    @Override
    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_48579(graphics, mouseX, mouseY, partialTicks);
        if (this.enabled) {
            this.renderIcon(graphics, mouseX, mouseY, partialTicks);
        } else {
            TextureData lock = ClientData.LOCK;
            ClientUtils.renderTexture(graphics, lock, this.method_46426() + 3, this.method_46427() + 2);
        }
    }
}

