/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button;

import com.nine.travelerscompass.client.ClientData;
import com.nine.travelerscompass.client.component.button.BaseButton;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.client.utils.SearchProgress;
import com.nine.travelerscompass.client.utils.TextureData;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.utils.SearchState;
import com.nine.travelerscompass.platform.Platform;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_7919;

public class WideSearchButton
extends BaseButton {
    private final Supplier<class_1799> supplier;
    private final UUID uuid;

    public WideSearchButton(int x, int y, Supplier<class_1799> supplier) {
        super(x, y, 14, 14);
        this.supplier = supplier;
        this.uuid = CompassProperties.COMPASS_UUID.get(supplier.get());
        this.refreshTooltip();
    }

    public void method_25348(double mouseX, double mouseY) {
        class_1799 stack = this.supplier.get();
        if (CompassProperties.SEARCH_STATE.get(stack) == SearchState.WIDE_SEARCHING) {
            if (this.shiftPressed) {
                ClientData.PROGRESS_DATA_CACHE.put(this.uuid, new SearchProgress(0, 0));
                ClientData.PROGRESS_DATA_CACHE.remove(this.uuid);
                Platform.PLATFORM_NETWORK.sendC2SPausePacket(this.uuid);
                CompassProperties.SEARCH_STATE.put(stack, SearchState.IDLE);
                this.refreshTooltip();
            }
        } else {
            this.refreshTooltip();
            Platform.PLATFORM_NETWORK.sendC2SWideSearchPacket(this.uuid);
        }
    }

    @Override
    protected void renderIcon(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        TextureData iconLayer = this.method_49606() ? ClientData.WIDE_SEARCH_HOVERED : ClientData.WIDE_SEARCH_ICON;
        ClientUtils.renderTexture(graphics, iconLayer, this.method_46426() + 2, this.method_46427() + 2);
    }

    @Override
    protected void renderMainLayer(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        class_1799 stack;
        TextureData baseLayer = ClientData.TOGGLE_BUTTON.get(false, this.field_22762);
        ClientUtils.renderTexture(graphics, baseLayer, this.method_46426(), this.method_46427());
        this.renderIcon(graphics, mouseX, mouseY, partialTicks);
        SearchProgress searchProgress = ClientData.PROGRESS_DATA_CACHE.get(this.uuid);
        if (searchProgress != null && CompassProperties.SEARCH_STATE.get(stack = this.supplier.get()) == SearchState.WIDE_SEARCHING) {
            float progress = (float)searchProgress.progress / (float)searchProgress.total;
            this.drawProgress(graphics, this.method_46426() + 1, this.method_46427() + 12, 13, 1, progress, this.field_22762 ? -1 : -1560281089);
        }
    }

    private void drawProgress(class_332 g, int x, int y, int w, int h, float p, int fg) {
        float wf = p * (float)w;
        int full = class_3532.method_15375((float)wf);
        if (full > 0) {
            g.method_25294(x, y, x + full, y + h, fg);
        }
    }

    @Override
    public void refreshTooltip() {
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        String key = "tooltip.travelerscompass.wide_search";
        class_5250 title = class_2561.method_43471((String)key);
        list.add((class_2561)title);
        if (this.shiftPressed) {
            class_5250 desc = ClientUtils.DESC_ARROW.method_27661().method_10852((class_2561)class_2561.method_43471((String)(key + ".desc")).method_27692(class_124.field_1080));
            list.add((class_2561)desc);
        }
        if (CompassProperties.SEARCH_STATE.get(this.supplier.get()) == SearchState.WIDE_SEARCHING) {
            SearchProgress searchProgress = ClientData.PROGRESS_DATA_CACHE.get(this.uuid);
            int percent = 0;
            if (searchProgress != null) {
                percent = searchProgress.progress * 100 / searchProgress.total;
            }
            class_5250 progress = ClientUtils.coloredComponent(class_2561.method_43470((String)(percent + "%")), 0xC8C8C8);
            list.add((class_2561)class_2561.method_43469((String)"tooltip.travelerscompass.settings.info.status.progress", (Object[])new Object[]{progress}).method_27692(class_124.field_1080));
            class_5250 shiftRBM = ClientUtils.coloredComponent(class_2561.method_43471((String)"tooltip.travelerscompass.settings.modification.shift_click"), 0xC8C8C8);
            list.add((class_2561)class_2561.method_43469((String)"tooltip.travelerscompass.wide_search.cancel", (Object[])new Object[]{shiftRBM}).method_27692(class_124.field_1080));
        }
        this.method_47400(class_7919.method_47407((class_2561)ClientUtils.buildTooltip(list)));
    }
}

