/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.element;

import com.nine.travelerscompass.client.ClientData;
import com.nine.travelerscompass.client.component.element.NewPopupElement;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.client.utils.IconTexture;
import com.nine.travelerscompass.client.utils.RangeUtils;
import com.nine.travelerscompass.client.utils.TextureData;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.data.DataStorage;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5250;

public class NewRangePopupElement<T extends Number>
extends NewPopupElement
implements RangeUtils.RangeButtonHandler<T> {
    private final IconTexture PLUS = new IconTexture(ClientData.PLUS_SMALL, 2, 2);
    private final IconTexture PLUS_INACTIVE = new IconTexture(ClientData.PLUS_SMALL_INACTIVE, 2, 2);
    private final IconTexture PLUS_CTRL = new IconTexture(ClientData.PLUS_SMALL_HOVERED, 2, 2);
    private final IconTexture MINUS = new IconTexture(ClientData.MINUS_SMALL, 2, 2);
    private final IconTexture MINUS_INACTIVE = new IconTexture(ClientData.MINUS_SMALL_INACTIVE, 2, 2);
    private final IconTexture MINUS_CTRL = new IconTexture(ClientData.MINUS_SMALL_HOVERED, 2, 2);
    private final IconTexture icon;
    private final Supplier<class_1799> supplier;
    private final DataStorage<T> data;
    private final T min;
    private final T max;
    private final T step;
    private final T stepCtrl;
    private final RangeUtils.RangeAdapter<T> adapter;
    public T cached;

    public NewRangePopupElement(int width, int height, T minValue, T maxValue, T step, T stepCtrl, RangeUtils.RangeAdapter<T> adapter, IconTexture icon, DataStorage<T> data, Supplier<class_1799> supplier) {
        super(width, height);
        this.min = minValue;
        this.max = maxValue;
        this.step = step;
        this.stepCtrl = stepCtrl;
        this.adapter = adapter;
        this.data = data;
        this.supplier = supplier;
        this.icon = icon;
        this.cached = (Number)data.get(supplier.get());
        this.updateState();
    }

    @Override
    public T current() {
        return this.cached;
    }

    @Override
    public void set(T value) {
        CompassProperties.putFromClient(this.supplier.get(), this.data, value);
    }

    @Override
    public T min() {
        return this.min;
    }

    @Override
    public T max() {
        return this.max;
    }

    @Override
    public RangeUtils.RangeAdapter<T> adapter() {
        return this.adapter;
    }

    @Override
    public void onClick(int button) {
        boolean changed = RangeUtils.changeValue(this, this.shiftPressed, this.ctrlPressed, ((Number)this.step).doubleValue(), ((Number)this.stepCtrl).doubleValue());
        if (changed) {
            this.updateState();
        }
    }

    @Override
    public void onMouseScroll(double delta) {
        boolean changed = RangeUtils.changeValue(this, delta < 0.0, this.ctrlPressed, ((Number)this.step).doubleValue(), ((Number)this.stepCtrl).doubleValue());
        if (changed) {
            this.updateState();
        }
    }

    @Override
    public void updateState() {
        class_1799 stack = this.supplier.get();
        this.cached = (Number)this.data.get(stack);
        this.refreshTooltip();
    }

    public void renderIcon(class_332 graphics, int xPos, int yPos, boolean outOfBounds) {
        IconTexture toRender = this.icon;
        if (this.isHovered) {
            toRender = this.shiftPressed ? (outOfBounds ? this.MINUS_INACTIVE : (this.ctrlPressed ? this.MINUS_CTRL : this.MINUS)) : (outOfBounds ? this.PLUS_INACTIVE : (this.ctrlPressed ? this.PLUS_CTRL : this.PLUS));
        }
        ClientUtils.renderTexture(graphics, toRender, xPos, yPos);
    }

    @Override
    public void renderElement(class_332 graphics, int xPos, int yPos) {
        boolean outOfBounds = RangeUtils.isOutOfBounds(this, this.adapter().add(this.cached, (this.ctrlPressed ? ((Number)this.stepCtrl).doubleValue() : ((Number)this.step).doubleValue()) * (double)(this.shiftPressed ? -1 : 1)));
        TextureData baseLayer = ClientData.SMALL_TOGGLE_BUTTON.get(false, this.isHovered, !outOfBounds || !this.isHovered);
        ClientUtils.renderTexture(graphics, baseLayer, xPos, yPos);
        this.renderIcon(graphics, xPos, yPos, outOfBounds);
    }

    @Override
    public void refreshTooltip() {
        ArrayList<class_2561> components = new ArrayList<class_2561>();
        components.add((class_2561)class_2561.method_43471((String)("tooltip.travelerscompass.settings." + this.data.getKey())).method_27692(class_124.field_1068));
        class_5250 shift = ClientUtils.coloredComponent(class_2561.method_43471((String)"tooltip.travelerscompass.settings.modification.shift"), this.shiftPressed ? 0xAAAAAA : 0xC8C8C8);
        class_5250 ctrl = ClientUtils.coloredComponent(class_2561.method_43471((String)"tooltip.travelerscompass.settings.modification.ctrl"), this.ctrlPressed ? 0xAAAAAA : 0xC8C8C8);
        components.add((class_2561)class_2561.method_43469((String)"tooltip.travelerscompass.settings.modification.hold_to_decrease", (Object[])new Object[]{shift}).method_27692(class_124.field_1080));
        components.add((class_2561)class_2561.method_43469((String)"tooltip.travelerscompass.settings.modification.hold_to_change_faster", (Object[])new Object[]{ctrl}).method_27692(class_124.field_1080));
        if (this.shiftPressed) {
            class_5250 desc = class_2561.method_43473().method_10852(ClientUtils.DESC_ARROW).method_10852((class_2561)class_2561.method_43471((String)("tooltip.travelerscompass.settings." + this.data.getKey() + ".desc")).method_27692(class_124.field_1080));
            components.add((class_2561)desc);
        }
        class_5250 value = ClientUtils.coloredComponent(this.adapter.format(this.cached).method_27661(), 0xC8C8C8);
        components.add((class_2561)class_2561.method_43469((String)("tooltip.travelerscompass.settings." + this.data.getKey() + ".value"), (Object[])new Object[]{value}).method_27692(class_124.field_1080));
        this.setTooltip(components);
    }
}

