/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.data;

import com.nine.travelerscompass.common.data.DataStorage;
import com.nine.travelerscompass.common.data.codec.BooleanCodec;
import com.nine.travelerscompass.common.data.codec.DataCodec;
import com.nine.travelerscompass.common.data.codec.EnumCodec;
import com.nine.travelerscompass.common.data.codec.FloatCodec;
import com.nine.travelerscompass.common.data.codec.FoundBlockPosCodec;
import com.nine.travelerscompass.common.data.codec.IntArrayCodec;
import com.nine.travelerscompass.common.data.codec.IntCodec;
import com.nine.travelerscompass.common.data.codec.StringCodec;
import com.nine.travelerscompass.common.data.codec.UUIDCodec;
import com.nine.travelerscompass.common.utils.Alignment;
import com.nine.travelerscompass.common.utils.FoundBlockPos;
import com.nine.travelerscompass.common.utils.HeightAttitude;
import com.nine.travelerscompass.common.utils.HudRenderMode;
import com.nine.travelerscompass.common.utils.HudType;
import com.nine.travelerscompass.common.utils.PriorityMode;
import com.nine.travelerscompass.common.utils.SearchState;
import com.nine.travelerscompass.common.utils.TabPage;
import com.nine.travelerscompass.compat.lootr.LootrSearchMode;
import com.nine.travelerscompass.config.TCConfig;
import com.nine.travelerscompass.platform.Platform;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public class CompassProperties {
    public static final Map<class_2960, DataStorage<?>> REGISTRY = new HashMap();
    public static final Map<class_2960, DataStorage<?>> CLIENT_EDITABLE = new HashMap();
    public static final Set<DataStorage<?>> SEARCH_OPTIONS = new HashSet();
    public static final DataStorage<UUID> COMPASS_UUID = CompassProperties.register("compass_uuid", (class_2487 tag) -> UUID.randomUUID(), new UUIDCodec(), new RegistrationOption[0]);
    public static final DataStorage<int[]> PRIORITY_SLOTS = CompassProperties.register("priority_slots", new int[0], (T value) -> ((int[])value).length > 9 ? Arrays.copyOf(value, 9) : value, new IntArrayCodec(), RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<Boolean> FORCE_CHUNKS_LOAD = CompassProperties.register("force_chunks_load", Boolean.valueOf(false), new BooleanCodec(), RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<Integer> SEARCH_COOLDOWN = CompassProperties.register("cooldown", Integer.valueOf(60), new IntCodec(), new RegistrationOption[0]);
    public static final DataStorage<Integer> ENTITIES_SEARCH_RANGE = CompassProperties.register("entities_search_range", Integer.valueOf(100), (T value) -> class_3532.method_15340((int)value, (int)1, (int)TCConfig.ENTITIES_SEARCH_RANGE.get()), new IntCodec(), RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<Integer> BLOCK_SEARCH_CHUNK_RANGE = CompassProperties.register("blocks_chunk_search_range", Integer.valueOf(6), (T value) -> class_3532.method_15340((int)value, (int)1, (int)TCConfig.BLOCKS_CHUNK_SEARCH_RANGE.get()), new IntCodec(), RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<Integer> WIDE_SEARCH_RANGE = CompassProperties.register("wide_search_range", Integer.valueOf(10), (T value) -> class_3532.method_15340((int)value, (int)1, (int)TCConfig.WIDE_SEARCH_RANGE.get()), new IntCodec(), RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<Boolean> PAUSE = CompassProperties.register("pause", Boolean.valueOf(false), new BooleanCodec(), RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<Boolean> TARGET_VALIDATION = CompassProperties.register("target_validation", Boolean.valueOf(true), new BooleanCodec(), RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<HeightAttitude> TARGET_HEIGHT = CompassProperties.register("target_attitude", HeightAttitude.NONE, new EnumCodec<HeightAttitude>(HeightAttitude.class), new RegistrationOption[0]);
    public static final DataStorage<FoundBlockPos> FOUND_BLOCK_POS = CompassProperties.register("found_block_pos", new FoundBlockPos(), new FoundBlockPosCodec(), new RegistrationOption[0]);
    public static final DataStorage<String> TARGET_ID = CompassProperties.register("target_id", "", new StringCodec(), new RegistrationOption[0]);
    public static final DataStorage<UUID> TARGET_UUID = CompassProperties.register("target_uuid", class_156.field_25140, new UUIDCodec(), new RegistrationOption[0]);
    public static final DataStorage<Boolean> PRIORITY_ITEM_FOUND = CompassProperties.register("priority_item_found", Boolean.valueOf(false), new BooleanCodec(), new RegistrationOption[0]);
    public static final DataStorage<Integer> COMPASS_STATE = CompassProperties.register("state", Integer.valueOf(0), new IntCodec(), new RegistrationOption[0]);
    public static final DataStorage<SearchState> SEARCH_STATE = CompassProperties.register("searching", SearchState.IDLE, new EnumCodec<SearchState>(SearchState.class), new RegistrationOption[0]);
    public static final DataStorage<TabPage> TAB_PAGE = CompassProperties.register("tab_page", TabPage.SEARCH, new EnumCodec<TabPage>(TabPage.class), RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<Boolean> HEIGHT_MARKER = CompassProperties.register("attitude_marker", Boolean.valueOf(true), new BooleanCodec(), RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<PriorityMode> PRIORITY_MODE = CompassProperties.register("priority_mode", PriorityMode.NORMAL, new EnumCodec<PriorityMode>(PriorityMode.class), RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<Boolean> SOUND_PING = CompassProperties.register("sound_ping", Boolean.valueOf(false), new BooleanCodec(), RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<Alignment> HUD_ALIGNMENT = CompassProperties.register("hud_alignment", Alignment.LEFT, new EnumCodec<Alignment>(Alignment.class), RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<HudType> HUD_TYPE = CompassProperties.register("hud_type", HudType.COMPACT, new EnumCodec<HudType>(HudType.class), RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<HudRenderMode> HUD_RENDER_MODE = CompassProperties.register("hud_render_mode", HudRenderMode.OFF, new EnumCodec<HudRenderMode>(HudRenderMode.class), RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<Integer> HUD_WIDTH = CompassProperties.register("hud_width", (class_2487 tag) -> CompassProperties.getCurrentHudKey(tag, "hud_width"), (class_2487 tag) -> CompassProperties.get(tag, HUD_TYPE).defaultWidth(), (T t) -> t, new IntCodec(), RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<Integer> HUD_HEIGHT = CompassProperties.register("hud_height", (class_2487 tag) -> CompassProperties.getCurrentHudKey(tag, "hud_height"), (class_2487 tag) -> CompassProperties.get(tag, HUD_TYPE).defaultHeight(), (T t) -> t, new IntCodec(), RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<Boolean> HUD_WITH_CHAT = CompassProperties.register("hud_with_chat", Boolean.valueOf(false), new BooleanCodec(), RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<Float> HUD_SCALE = CompassProperties.register("hud_scale", Float.valueOf(TCConfig.DEFAULT_HUD_SCALE.get().floatValue()), new FloatCodec(), RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<Integer> HUD_X_POS = CompassProperties.register("hud_x_pos", TCConfig.DEFAULT_HUD_X_POSITION.get(), new IntCodec(), RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<Integer> HUD_Y_POS = CompassProperties.register("hud_y_pos", TCConfig.DEFAULT_HUD_Y_POSITION.get(), new IntCodec(), RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<Boolean> CONTAINERS = CompassProperties.register("containers", Boolean.valueOf(false), new BooleanCodec(), RegistrationOption.SEARCH_OPTION, RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<Boolean> VILLAGERS = CompassProperties.register("villagers", Boolean.valueOf(false), new BooleanCodec(), RegistrationOption.SEARCH_OPTION, RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<Boolean> VILLAGERS_BUYS = CompassProperties.register("villagers_buys", Boolean.valueOf(true), new BooleanCodec(), RegistrationOption.SEARCH_OPTION, RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<Boolean> VILLAGERS_SELLS = CompassProperties.register("villagers_sells", Boolean.valueOf(true), new BooleanCodec(), RegistrationOption.SEARCH_OPTION, RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<Boolean> ITEM_ENTITIES = CompassProperties.register("item_entities", Boolean.valueOf(false), new BooleanCodec(), RegistrationOption.SEARCH_OPTION, RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<Boolean> INVENTORIES = CompassProperties.register("inventories", Boolean.valueOf(false), new BooleanCodec(), RegistrationOption.SEARCH_OPTION, RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<Boolean> INVENTORIES_PLAYERS = CompassProperties.register("inv_players", Boolean.valueOf(true), new BooleanCodec(), RegistrationOption.SEARCH_OPTION, RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<Boolean> INVENTORIES_MOBS = CompassProperties.register("inv_mobs", Boolean.valueOf(true), new BooleanCodec(), RegistrationOption.SEARCH_OPTION, RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<Boolean> FLUIDS = CompassProperties.register("fluids", Boolean.valueOf(false), new BooleanCodec(), RegistrationOption.SEARCH_OPTION, RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<Boolean> SPAWNERS = CompassProperties.register("spawners", Boolean.valueOf(false), new BooleanCodec(), RegistrationOption.SEARCH_OPTION, RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<Boolean> BLOCKS = CompassProperties.register("blocks", Boolean.valueOf(false), new BooleanCodec(), RegistrationOption.SEARCH_OPTION, RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<Boolean> MOBS = CompassProperties.register("mobs", Boolean.valueOf(false), new BooleanCodec(), RegistrationOption.SEARCH_OPTION, RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<Boolean> DROP = CompassProperties.register("drop", Boolean.valueOf(false), new BooleanCodec(), RegistrationOption.SEARCH_OPTION, RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<Boolean> MINECARTS = CompassProperties.register("minecarts", Boolean.valueOf(true), new BooleanCodec(), RegistrationOption.SEARCH_OPTION, RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<Boolean> CONTAINERS_CHESTS = CompassProperties.register("containers_chests", Boolean.valueOf(true), new BooleanCodec(), RegistrationOption.SEARCH_OPTION, RegistrationOption.CLIENT_EDITABLE);
    public static final DataStorage<LootrSearchMode> LOOTR_MODE = CompassProperties.register("lootr_search_mode", LootrSearchMode.CLOSED, new EnumCodec<LootrSearchMode>(LootrSearchMode.class), RegistrationOption.SEARCH_OPTION, RegistrationOption.CLIENT_EDITABLE);

    public static <T> T get(class_1799 stack, DataStorage<T> data) {
        return data.read(stack);
    }

    public static <T> T get(class_2487 tag, DataStorage<T> data) {
        return data.read(tag);
    }

    public static <T> void put(class_1799 stack, DataStorage<T> data, T value) {
        CompassProperties.put(stack.method_7948(), data, value);
    }

    public static <T> void put(class_2487 tag, DataStorage<T> data, T value) {
        data.write(tag, value);
    }

    public static <T> void putWithValidation(class_1799 stack, DataStorage<T> data, T value) {
        CompassProperties.putWithValidation(stack.method_7948(), data, value);
    }

    public static <T> void putWithValidation(class_2487 tag, DataStorage<T> data, T value) {
        data.write(tag, data.validate(value));
    }

    public static <T> void writeDefaultFromClient(class_1799 stack, DataStorage<T> data) {
        CompassProperties.putFromClient(stack, data, data.getDefault(stack));
    }

    public static void toggleFromClient(class_1799 stack, DataStorage<?> data, boolean forward) {
        Object current = data.get(stack);
        DataCodec<?> codec = data.getCodec();
        if (current instanceof Boolean) {
            Boolean bool = (Boolean)current;
            CompassProperties.putFromClient(stack, data, Boolean.valueOf(bool == false));
        } else if (codec instanceof EnumCodec) {
            EnumCodec enumCodec = (EnumCodec)codec;
            Enum enumValue = (Enum)current;
            Enum[] values = (Enum[])enumCodec.getEnumClass().getEnumConstants();
            int nextIndex = (enumValue.ordinal() + (forward ? 1 : values.length - 1)) % values.length;
            Enum next = values[nextIndex];
            CompassProperties.putFromClient(stack, data, next);
        } else {
            throw new IllegalArgumentException("Unsupported data type for toggling: " + String.valueOf(current.getClass()));
        }
    }

    public static void toggleFromClient(class_1799 stack, DataStorage<Boolean> data) {
        CompassProperties.putFromClient(stack, data, Boolean.valueOf(CompassProperties.get(stack, data) == false));
    }

    public static <T> void putFromClient(class_1799 stack, DataStorage<T> data, T value) {
        CompassProperties.putFromClient(stack.method_7948(), data, value);
    }

    public static <T> void putFromClient(class_2487 stackTag, DataStorage<T> data, T value) {
        class_2487 tag = new class_2487();
        CompassProperties.put(tag, data, value);
        data.put(stackTag, value);
        Platform.PLATFORM_NETWORK.sendC2SDataPacket(data, tag);
    }

    public static <T> void putFromServer(class_1799 stack, class_3222 player, DataStorage<T> data, T value) {
        class_2487 tag = new class_2487();
        CompassProperties.put(tag, data, value);
        data.put(stack.method_7948(), value);
        Platform.PLATFORM_NETWORK.sendS2CDataPacket(player, data, tag, COMPASS_UUID.get(stack));
    }

    private static <T> DataStorage<T> register(String key, T defaultValue, Function<T, T> validator, DataCodec<T> codec, RegistrationOption ... regOpts) {
        return CompassProperties.register(key, (class_2487 tag) -> key, (class_2487 tag) -> defaultValue, validator, codec, regOpts);
    }

    private static <T> DataStorage<T> register(String key, T defaultValue, DataCodec<T> codec, RegistrationOption ... regOpts) {
        return CompassProperties.register(key, (class_2487 tag) -> key, (class_2487 tag) -> defaultValue, (T t) -> t, codec, regOpts);
    }

    private static <T> DataStorage<T> register(String key, Function<class_2487, T> defaultValue, DataCodec<T> codec, RegistrationOption ... regOpts) {
        return CompassProperties.register(key, (class_2487 tag) -> key, defaultValue, (T t) -> t, codec, regOpts);
    }

    private static <T> DataStorage<T> register(String id, Function<class_2487, String> keyResolver, Function<class_2487, T> defaultValue, Function<T, T> validator, DataCodec<T> codec, RegistrationOption ... regOpts) {
        class_2960 location = new class_2960("travelerscompass", id);
        DataStorage<T> ret = new DataStorage<T>(location, keyResolver, defaultValue, validator, codec);
        REGISTRY.put(location, ret);
        for (RegistrationOption option : regOpts) {
            if (option == RegistrationOption.SEARCH_OPTION) {
                SEARCH_OPTIONS.add(ret);
                continue;
            }
            if (option != RegistrationOption.CLIENT_EDITABLE) continue;
            CLIENT_EDITABLE.put(location, ret);
        }
        return ret;
    }

    private static String getCurrentHudKey(class_2487 tag, String baseKey) {
        if (tag == null) {
            return baseKey;
        }
        HudType type = CompassProperties.get(tag, HUD_TYPE);
        return type.name().toLowerCase() + "_" + baseKey;
    }

    private static enum RegistrationOption {
        CLIENT_EDITABLE,
        SEARCH_OPTION;

    }
}

