/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.item;

import com.nine.travelerscompass.client.ClientData;
import com.nine.travelerscompass.client.hud.HudData;
import com.nine.travelerscompass.client.hud.HudSettings;
import com.nine.travelerscompass.common.container.CompassContainer;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.search.SearchManager;
import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.search.location.WithUUID;
import com.nine.travelerscompass.common.utils.FoundBlockPos;
import com.nine.travelerscompass.common.utils.HeightAttitude;
import com.nine.travelerscompass.common.utils.PriorityMode;
import com.nine.travelerscompass.common.utils.SearchState;
import com.nine.travelerscompass.config.TCConfig;
import com.nine.travelerscompass.config.filter.FilterManager;
import com.nine.travelerscompass.config.filter.FilterReason;
import com.nine.travelerscompass.platform.Platform;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class TravelersCompassItem
extends class_1792 {
    public static final int STATE_EMPTY = 1;
    public static final int STATE_SEARCHING = 2;

    public TravelersCompassItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (hand != class_1268.field_5808) {
            return class_1271.method_22430((Object)player.method_5998(hand));
        }
        CompassContainer compassContainer = CompassContainer.container(stack);
        class_243 lookVector = player.method_5720();
        class_243 eyePosition = player.method_5836(1.0f);
        class_243 traceEnd = eyePosition.method_1031(lookVector.field_1352 * 5.0, lookVector.field_1351 * 5.0, lookVector.field_1350 * 5.0);
        class_3965 hitResult = level.method_17742(new class_3959(eyePosition, traceEnd, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)player));
        class_2338 blockPos = hitResult.method_17777();
        if (!level.field_9236) {
            class_1799 clickedStack;
            if (player.method_5715() && !compassContainer.hasAny(clickedStack = level.method_8320(blockPos).method_26204().method_8389().method_7854())) {
                compassContainer.setItem(compassContainer.getFirstEmptySlot(), clickedStack, player);
                if (FilterManager.passesFilters(clickedStack)) {
                    level.method_8396(null, player.method_23312(), class_3417.field_23199, class_3419.field_15248, 1.0f, 1.0f);
                    return class_1271.method_22427((Object)player.method_5998(hand));
                }
            }
            UUID uuid = CompassProperties.COMPASS_UUID.get(stack);
            SearchManager.addWatcher(uuid, player.method_5667());
            Platform.PLATFORM.openMenu(player, stack);
            return class_1271.method_22427((Object)player.method_5998(hand));
        }
        return class_1271.method_22431((Object)player.method_5998(hand));
    }

    public class_1269 method_7847(class_1799 itemStack, class_1657 player, class_1309 living, class_1268 hand) {
        if (hand != class_1268.field_5808) {
            return class_1269.field_5811;
        }
        class_1799 stack = player.method_5998(hand);
        if (!player.method_37908().field_9236 && player.method_5715() && living instanceof class_1308) {
            class_1299 type;
            FilterReason reason;
            class_1799 eggStack;
            class_1308 mob = (class_1308)living;
            class_1826 eggItem = class_1826.method_8019((class_1299)mob.method_5864());
            CompassContainer compassContainer = CompassContainer.container(stack);
            if (eggItem != null && !compassContainer.hasAny(eggStack = eggItem.method_7854()) && (reason = FilterManager.getFilterReason(type = eggItem.method_8015(null))) instanceof FilterReason.Allowed) {
                compassContainer.setItem(compassContainer.getFirstEmptySlot(), eggStack, player);
                player.method_37908().method_8396(null, player.method_23312(), class_3417.field_23199, class_3419.field_15248, 1.0f, 1.0f);
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int slot, boolean selected) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            UUID uuid = CompassProperties.get(stack, CompassProperties.COMPASS_UUID);
            if (level.field_9236) {
                if (!ClientData.HUD_DATA_CACHE.containsKey(uuid)) {
                    ClientData.HUD_DATA_CACHE.put(uuid, new HudData(new HudSettings(CompassProperties.HUD_RENDER_MODE.get(stack), CompassProperties.HUD_TYPE.get(stack), CompassProperties.HUD_ALIGNMENT.get(stack), CompassProperties.HUD_WITH_CHAT.get(stack), CompassProperties.HUD_SCALE.get(stack).floatValue(), CompassProperties.HUD_WIDTH.get(stack), CompassProperties.HUD_HEIGHT.get(stack), CompassProperties.HUD_X_POS.get(stack), CompassProperties.HUD_Y_POS.get(stack)), CompassProperties.PAUSE.get(stack), selected, CompassProperties.SEARCH_STATE.get(stack)));
                } else {
                    ClientData.HUD_DATA_CACHE.computeIfPresent(uuid, (id, hudData) -> {
                        hudData.setSelected(selected);
                        return hudData;
                    });
                    if (player.field_6012 % 20 == 0) {
                        ClientData.HUD_DATA_CACHE.computeIfPresent(uuid, (id, hudData) -> {
                            hudData.setSearchState(CompassProperties.SEARCH_STATE.get(stack));
                            return hudData;
                        });
                    }
                }
            }
            if (!level.field_9236 && player instanceof class_3222) {
                boolean validLocation;
                class_3222 serverPlayer = (class_3222)player;
                boolean searching = SearchManager.inQueue(uuid);
                if (!searching && !CompassContainer.container(stack).method_5442()) {
                    this.tryToScan(stack, serverPlayer, uuid);
                }
                PriorityMode priorityMode = CompassProperties.PRIORITY_MODE.get(stack);
                ILocationObject locationObject = SearchManager.getClosestLocation(player.method_24515(), uuid, priorityMode);
                boolean bl = validLocation = locationObject != null;
                if (player.field_6012 % 5 == 0) {
                    UUID targetUUID;
                    String targetID;
                    FoundBlockPos foundBlockPos;
                    CompassContainer container = CompassContainer.container(stack);
                    if (player.field_6012 % 20 == 0) {
                        SearchState searchState = CompassProperties.SEARCH_STATE.get(stack);
                        if (!searching && searchState != SearchState.IDLE) {
                            CompassProperties.putFromServer(stack, serverPlayer, CompassProperties.SEARCH_STATE, SearchState.IDLE);
                        }
                        if (container.method_5442()) {
                            SearchManager.clearFoundBlocks(uuid);
                        }
                        SearchManager.validatePositions(level, uuid);
                        SearchManager.validatePriority(stack);
                        if (TCConfig.ENABLE_HUD.get().booleanValue()) {
                            ILocationObject clientLocationObject = locationObject;
                            if (clientLocationObject != null && !TCConfig.SHOW_COORDS.get().booleanValue()) {
                                clientLocationObject = clientLocationObject.withBlockPos(null);
                            }
                            Platform.PLATFORM_NETWORK.sendS2CHudLocationDataPacket(serverPlayer, clientLocationObject, uuid);
                        }
                    }
                    if (!validLocation) {
                        CompassProperties.put(stack, CompassProperties.PRIORITY_ITEM_FOUND, Boolean.valueOf(false));
                        foundBlockPos = new FoundBlockPos();
                    } else {
                        foundBlockPos = new FoundBlockPos(locationObject.blockPos(), true);
                        CompassProperties.put(stack, CompassProperties.PRIORITY_ITEM_FOUND, Boolean.valueOf(locationObject.priority()));
                    }
                    this.updateState(stack, validLocation, container.method_5442());
                    String string = targetID = validLocation ? locationObject.descriptionId() : "";
                    if (validLocation && locationObject instanceof WithUUID) {
                        WithUUID withUUID = (WithUUID)((Object)locationObject);
                        v2 = withUUID.uuid();
                    } else {
                        v2 = targetUUID = class_156.field_25140;
                    }
                    if (validLocation && !CompassProperties.FOUND_BLOCK_POS.get(stack).equals(foundBlockPos) && CompassProperties.SOUND_PING.get(stack).booleanValue()) {
                        boolean shouldPing = false;
                        if (!targetUUID.equals(CompassProperties.TARGET_UUID.get(stack))) {
                            shouldPing = true;
                        }
                        if (!targetID.isEmpty() && !targetID.equals(CompassProperties.TARGET_ID.get(stack))) {
                            shouldPing = true;
                        }
                        if (shouldPing) {
                            this.playPingSound(locationObject, player);
                        }
                    }
                    CompassProperties.put(stack, CompassProperties.TARGET_ID, targetID);
                    CompassProperties.put(stack, CompassProperties.TARGET_UUID, targetUUID);
                    CompassProperties.put(stack, CompassProperties.FOUND_BLOCK_POS, foundBlockPos);
                }
                this.updateTargetAttitude(stack, player.method_24515(), locationObject);
            }
        }
    }

    private void playPingSound(ILocationObject locationObject, class_1657 player) {
        class_1937 level = player.method_37908();
        if (locationObject.priority()) {
            level.method_8396(null, player.method_24515(), class_3417.field_14627, class_3419.field_15248, 0.3f, 0.3f);
        }
        level.method_8396(null, player.method_24515(), class_3417.field_14627, class_3419.field_15248, 0.1f, 0.44f + level.field_9229.method_43057() / 10.0f);
        level.method_8396(null, player.method_24515(), class_3417.field_14627, class_3419.field_15248, 0.1f, 1.0f);
    }

    private void updateState(class_1799 stack, boolean validLocation, boolean empty) {
        int currentState = CompassProperties.COMPASS_STATE.get(stack);
        int newState = 1;
        if (validLocation) {
            newState = -1;
        } else if (CompassProperties.SEARCH_STATE.get(stack) != SearchState.IDLE) {
            newState = 2;
        } else if (CompassProperties.PAUSE.get(stack).booleanValue()) {
            newState = 1;
        } else if (!empty) {
            newState = 2;
        }
        if (currentState != newState) {
            CompassProperties.COMPASS_STATE.put(stack, (Integer)newState);
        }
    }

    private void updateTargetAttitude(class_1799 stack, class_2338 playerPos, ILocationObject locationData) {
        HeightAttitude heightAttitude;
        HeightAttitude current = CompassProperties.TARGET_HEIGHT.get(stack);
        if (locationData == null) {
            heightAttitude = HeightAttitude.NONE;
        } else {
            int tY;
            class_2338 targetPos = locationData.blockPos();
            int pY = playerPos.method_10264();
            heightAttitude = pY - (tY = targetPos.method_10264()) > 0 ? HeightAttitude.DOWN : (pY - tY <= -2 ? HeightAttitude.UP : HeightAttitude.SAME);
        }
        if (current != heightAttitude) {
            CompassProperties.put(stack, CompassProperties.TARGET_HEIGHT, heightAttitude);
        }
    }

    private void tryToScan(class_1799 stack, class_3222 player, UUID uuid) {
        if (!CompassProperties.get(stack, CompassProperties.PAUSE).booleanValue()) {
            int cooldown = CompassProperties.SEARCH_COOLDOWN.get(stack);
            if (cooldown > 0) {
                CompassProperties.put(stack, CompassProperties.SEARCH_COOLDOWN, Integer.valueOf(cooldown - 1));
            }
            if (cooldown <= 0) {
                CompassContainer container = CompassContainer.container(stack);
                if (container.method_5442()) {
                    CompassProperties.put(stack, CompassProperties.SEARCH_COOLDOWN, Integer.valueOf(20));
                    return;
                }
                CompassProperties.put(stack, CompassProperties.SEARCH_COOLDOWN, TCConfig.SEARCH_INTERVAL.get());
                CompassProperties.putFromServer(stack, player, CompassProperties.SEARCH_STATE, SearchState.SEARCHING);
                SearchManager.startSearch(stack, player, container, false, result -> {
                    CompassProperties.putFromServer(stack, player, CompassProperties.SEARCH_STATE, SearchState.IDLE);
                    PriorityMode priorityMode = CompassProperties.PRIORITY_MODE.get(stack);
                    SearchManager.validatePriority(stack);
                    SearchManager.saveClosest(result.get(), player.method_24515(), uuid, TCConfig.MAX_CACHED_LOCATIONS.get(), priorityMode);
                    SearchManager.validatePositions(player.method_37908(), uuid);
                });
            }
        }
    }

    public static FoundBlockPos getFoundPos(class_1799 stack) {
        return CompassProperties.FOUND_BLOCK_POS.get(stack);
    }
}

