/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.search.location;

import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.search.location.WithUUID;
import com.nine.travelerscompass.common.search.location.codec.LocationCodec;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;

public record EntityLocationObject(class_2338 blockPos, int slotIndex, boolean priority, String descriptionId, UUID uuid) implements ILocationObject,
WithUUID
{
    public static class_2960 TYPE = new class_2960("travelerscompass", "entity_location_codec");
    public static final LocationCodec<EntityLocationObject> CODEC = new LocationCodec<EntityLocationObject>(){

        @Override
        public void write(class_2540 buf, EntityLocationObject obj) {
            this.writePosSafe(buf, obj.blockPos);
            buf.writeInt(obj.slotIndex);
            buf.writeBoolean(obj.priority);
            buf.method_10814(obj.descriptionId);
            buf.method_10797(obj.uuid);
        }

        @Override
        public EntityLocationObject read(class_2540 buf) {
            class_2338 blockPos = this.readPosSafe(buf);
            int slotIndex = buf.readInt();
            boolean priority = buf.readBoolean();
            String descriptionId = buf.method_19772();
            UUID uuid = buf.method_10790();
            return new EntityLocationObject(blockPos, slotIndex, priority, descriptionId, uuid);
        }
    };

    @Override
    public class_2960 type() {
        return TYPE;
    }

    @Override
    public boolean isValid(class_3218 level) {
        return level.method_14190(this.uuid) != null;
    }

    @Override
    public ILocationObject copy(class_2338 blockPos, int slotIndex, boolean priority, String descriptionId) {
        return new EntityLocationObject(blockPos, slotIndex, priority, descriptionId, this.uuid);
    }

    @Override
    public Optional<ILocationObject> update(class_3218 level) {
        class_1297 entity = level.method_14190(this.uuid);
        if (entity != null && !entity.method_24515().equals((Object)this.blockPos)) {
            return Optional.of(new EntityLocationObject(entity.method_24515(), this.slotIndex, this.priority, this.descriptionId, this.uuid));
        }
        return Optional.of(this);
    }

    @Override
    public String toString() {
        return "Entity [" + this.descriptionId + "], " + String.valueOf(this.blockPos) + (this.priority ? " [priority]" : "");
    }
}

