/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.compat.lootr;

import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.search.SearchOptions;
import com.nine.travelerscompass.common.search.criterion.ISearchCriterion;
import com.nine.travelerscompass.common.search.criterion.TypedCriteria;
import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.search.location.LootrContainerLocationObject;
import com.nine.travelerscompass.common.search.location.LootrMinecartLocationObject;
import com.nine.travelerscompass.compat.lootr.LootrSearchMode;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.zestyblaze.lootr.api.IHasOpeners;
import net.zestyblaze.lootr.api.blockentity.ILootBlockEntity;
import net.zestyblaze.lootr.data.DataStorage;
import net.zestyblaze.lootr.data.SpecialChestInventory;
import net.zestyblaze.lootr.entity.LootrChestMinecartEntity;

public class FabricLootrHelper {
    public static List<ILocationObject> minecartMatch(TypedCriteria criteria, SearchOptions options, class_1297 entity, class_1937 level, class_2338 pos) {
        ArrayList<ILocationObject> ret = new ArrayList<ILocationObject>();
        if (entity instanceof LootrChestMinecartEntity) {
            LootrChestMinecartEntity minecart = (LootrChestMinecartEntity)entity;
            if (criteria.itemCriteria.isEmpty()) {
                return List.of();
            }
            if (!FabricLootrHelper.shouldCheckLootrContainer((IHasOpeners)minecart, options)) {
                return ret;
            }
            SpecialChestInventory inventory = DataStorage.getInventory((class_1937)level, (LootrChestMinecartEntity)minecart, (class_3222)options.player(), (arg_0, arg_1, arg_2, arg_3) -> ((LootrChestMinecartEntity)minecart).addLoot(arg_0, arg_1, arg_2, arg_3));
            if (inventory != null) {
                String id = entity.method_5864().method_5882();
                for (class_1799 stack : inventory.getInventoryContents()) {
                    class_1792 item = stack.method_7909();
                    if (!criteria.itemCriteriaMap.containsKey(item)) continue;
                    ISearchCriterion criterion = criteria.itemCriteriaMap.get(item);
                    ret.add(new LootrMinecartLocationObject(pos.method_10062(), criterion.slot(), criterion.priority(), id, item.method_7876(), entity.method_5667()));
                }
            }
        }
        return ret;
    }

    public static List<ILocationObject> matchLootrContainer(TypedCriteria criteria, SearchOptions options, class_2338 pos, class_2680 state, class_2586 be) {
        ArrayList<ILocationObject> ret = new ArrayList<ILocationObject>();
        if (be instanceof ILootBlockEntity) {
            ILootBlockEntity lootEntity = (ILootBlockEntity)be;
            if (criteria.itemCriteria.isEmpty()) {
                return List.of();
            }
            if (!FabricLootrHelper.shouldCheckLootrContainer((IHasOpeners)lootEntity, options)) {
                return ret;
            }
            SpecialChestInventory inventory = DataStorage.getInventory((class_1937)options.player().method_37908(), (UUID)lootEntity.getTileId(), (class_2338)lootEntity.getPosition(), (class_3222)options.player(), (class_2621)((class_2621)lootEntity), (arg_0, arg_1, arg_2, arg_3) -> ((ILootBlockEntity)lootEntity).unpackLootTable(arg_0, arg_1, arg_2, arg_3));
            if (inventory != null) {
                class_2960 id = class_7923.field_41175.method_10221((Object)state.method_26204());
                for (class_1799 stack : inventory.getInventoryContents()) {
                    class_1792 item = stack.method_7909();
                    if (!criteria.itemCriteriaMap.containsKey(item)) continue;
                    ISearchCriterion criterion = criteria.itemCriteriaMap.get(item);
                    ret.add(new LootrContainerLocationObject(pos.method_10062(), criterion.slot(), criterion.priority(), 0, state.method_26204().method_9539(), item.method_7876(), id));
                }
            }
        }
        return ret;
    }

    public static boolean shouldCheckLootrContainer(IHasOpeners iHasOpeners, SearchOptions options) {
        LootrSearchMode searchMode = options.get(CompassProperties.LOOTR_MODE);
        boolean opened = iHasOpeners.getOpeners().contains(options.getPlayerUUID());
        return switch (searchMode) {
            case LootrSearchMode.ALL -> true;
            case LootrSearchMode.OPENED -> opened;
            case LootrSearchMode.CLOSED -> {
                if (!opened) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }
}

