/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.element;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;

public class NewPopupElement {
    private final Rect2i area;
    protected boolean shiftPressed;
    protected boolean ctrlPressed;
    protected boolean isHovered;
    protected boolean active = true;
    private int xOffSet;
    private int yOffSet;
    private final List<Component> tooltip = new ArrayList<Component>();

    public NewPopupElement(int width, int height) {
        this.area = new Rect2i(0, 0, width, height);
    }

    public void updateState() {
    }

    private void updateAreaPos(int xPos, int yPos) {
        this.area.m_173049_(xPos, yPos);
    }

    public boolean hoveredAt(int mouseX, int mouseY) {
        return this.area.m_110087_(mouseX, mouseY);
    }

    protected void setTooltip(List<Component> components) {
        this.tooltip.clear();
        this.tooltip.addAll(components);
    }

    public void init(int x, int y) {
        this.xOffSet = x;
        this.yOffSet = y;
        this.refreshTooltip();
    }

    public int getXOffset() {
        return this.xOffSet;
    }

    public int getYOffset() {
        return this.yOffSet;
    }

    public void refreshTooltip() {
    }

    public void onEnter() {
    }

    public void onExit() {
    }

    protected void onModifierChange() {
    }

    protected void renderElement(GuiGraphics graphics, int xPos, int yPos) {
    }

    public void handleClick(int mouseX, int mouseY, int button) {
        if (this.active && this.hoveredAt(mouseX, mouseY)) {
            this.onClick(button);
            this.refreshTooltip();
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
        }
    }

    public void handleMouseScroll(int mouseX, int mouseY, double delta) {
        if (this.active && this.hoveredAt(mouseX, mouseY)) {
            this.onMouseScroll(delta);
            this.refreshTooltip();
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
        }
    }

    public void onClick(int button) {
    }

    public void onMouseScroll(double delta) {
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, int xPos, int yPos) {
        this.updateAreaPos(xPos, yPos);
        boolean shiftDown = Screen.m_96638_();
        boolean ctrlDown = Screen.m_96637_();
        if (shiftDown != this.shiftPressed || ctrlDown != this.ctrlPressed) {
            this.shiftPressed = shiftDown;
            this.ctrlPressed = ctrlDown;
            this.refreshTooltip();
            this.onModifierChange();
        }
        if (this.hoveredAt(mouseX, mouseY)) {
            if (!this.isHovered) {
                this.isHovered = true;
                this.onEnter();
            }
            this.isHovered = true;
            graphics.m_280677_(Minecraft.m_91087_().f_91062_, this.tooltip, Optional.empty(), mouseX, mouseY);
        } else {
            if (this.isHovered) {
                this.isHovered = false;
                this.onExit();
            }
            this.isHovered = false;
        }
        this.renderElement(graphics, xPos, yPos);
    }
}

