/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.nine.travelerscompass.client.ClientData;
import com.nine.travelerscompass.client.component.button.ContainersButton;
import com.nine.travelerscompass.client.component.button.HudButton;
import com.nine.travelerscompass.client.component.button.InfoButton;
import com.nine.travelerscompass.client.component.button.InventoriesButton;
import com.nine.travelerscompass.client.component.button.RangeButton;
import com.nine.travelerscompass.client.component.button.ResetButton;
import com.nine.travelerscompass.client.component.button.SearchModeButton;
import com.nine.travelerscompass.client.component.button.SettingsButton;
import com.nine.travelerscompass.client.component.button.TabButton;
import com.nine.travelerscompass.client.component.button.Toggleable;
import com.nine.travelerscompass.client.component.button.VillagersButton;
import com.nine.travelerscompass.client.component.button.WarningButton;
import com.nine.travelerscompass.client.component.button.WideSearchButton;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.client.utils.IconTexture;
import com.nine.travelerscompass.client.utils.RangeUtils;
import com.nine.travelerscompass.client.utils.TextureData;
import com.nine.travelerscompass.common.container.CompassContainer;
import com.nine.travelerscompass.common.container.menu.CompassMenu;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.data.DataStorage;
import com.nine.travelerscompass.common.item.TravelersCompassItem;
import com.nine.travelerscompass.common.utils.PriorityMode;
import com.nine.travelerscompass.common.utils.SearchState;
import com.nine.travelerscompass.common.utils.TabPage;
import com.nine.travelerscompass.config.TCConfig;
import com.nine.travelerscompass.config.cost.SearchCost;
import com.nine.travelerscompass.config.cost.SearchCostHelper;
import com.nine.travelerscompass.config.filter.FilterManager;
import com.nine.travelerscompass.config.filter.FilterReason;
import com.nine.travelerscompass.platform.Platform;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CompassScreen
extends AbstractContainerScreen<CompassMenu> {
    private static final ResourceLocation TEXTURE_1 = new ResourceLocation("travelerscompass", "textures/gui/container/compass_screen_1.png");
    private static final ResourceLocation TEXTURE_2 = new ResourceLocation("travelerscompass", "textures/gui/container/compass_screen_2.png");
    public static final ResourceLocation PRIORITY_SLOT = new ResourceLocation("travelerscompass", "textures/gui/priority_slot.png");
    private Player player;
    private ItemStack stack;
    private TabPage tabPage;
    private UUID uuid;
    private int updateTicks;
    private TabButton tabButton1;
    private TabButton tabButton2;
    private WarningButton warningButton;
    private SearchModeButton blocksSearchButton;
    private SearchModeButton mobsSearchButton;
    private ContainersButton containersSearchButton;
    private SearchModeButton fluidsSearchButton;
    private SearchModeButton spawnersSearchButton;
    private SearchModeButton dropsSearchButton;
    private SearchModeButton itemEntitiesSearchButton;
    private InventoriesButton inventoriesSearchButton;
    private VillagersButton villagersSearchButton;
    private SettingsButton pauseButton;
    private WideSearchButton wideSearchButton;
    private InfoButton infoButton;
    private HudButton hudButton;
    private SettingsButton forceChunksLoadButton;
    private SettingsButton targetValidationButton;
    private SettingsButton soundPingButton;
    private SettingsButton attitudeMarkerButton;
    private SettingsButton priorityButton;
    private ResetButton resetButton;
    private RangeButton<Integer> chunksSearchRangeButton;
    private RangeButton<Integer> entitiesSearchRange;
    private RangeButton<Integer> wideSearchRange;

    public CompassScreen(CompassMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 177;
        this.f_97727_ = 169;
        this.tabPage = TabPage.SEARCH;
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.f_96541_ == null) {
            return;
        }
        this.player = this.f_96541_.f_91074_;
        if (this.player == null) {
            return;
        }
        ItemStack stack = this.player.m_21205_();
        if (!(stack.m_41720_() instanceof TravelersCompassItem)) {
            return;
        }
        this.stack = stack;
        this.uuid = CompassProperties.get(stack, CompassProperties.COMPASS_UUID);
        this.initButtons();
        this.tabPage = CompassProperties.get(stack, CompassProperties.TAB_PAGE);
        this.addTabButtons();
        this.m_142416_((GuiEventListener)this.warningButton);
        switch (this.tabPage) {
            case SEARCH: {
                this.addSearchButtons();
                break;
            }
            case SETTINGS: {
                this.addSettingsButton();
            }
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.tabPage == TabPage.SETTINGS) {
            this.hudButton.m_6050_(mouseX, mouseY, delta);
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    protected void m_181908_() {
        this.fluidsSearchButton.tick();
        ++this.updateTicks;
        if (this.updateTicks % 2 == 0) {
            this.infoButton.refreshTooltip();
            this.wideSearchButton.refreshTooltip();
            this.wideSearchRange.refreshTooltip();
            this.pauseButton.refreshTooltip();
        }
        if (this.updateTicks % 10 == 0) {
            this.warningButton.updateState(this.stack);
            this.updateTicks = 0;
        }
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    private void initButtons() {
        this.blocksSearchButton = new SearchModeButton(this.f_97735_ + 7, this.f_97736_ + 7, 14, 14, TCConfig.ENABLE_BLOCKS_SEARCH.get(), CompassProperties.BLOCKS, new IconTexture(ClientData.BLOCKS_ACTIVE, 2, 2), new IconTexture(ClientData.BLOCKS_INACTIVE, 2, 2), this.stack);
        this.mobsSearchButton = new SearchModeButton(this.f_97735_ + 23, this.f_97736_ + 7, 14, 14, TCConfig.ENABLE_MOBS_SEARCH.get(), CompassProperties.MOBS, new IconTexture(ClientData.MOBS_ACTIVE, 2, 2), new IconTexture(ClientData.MOBS_INACTIVE, 2, 2), this.stack);
        this.fluidsSearchButton = new SearchModeButton(this.f_97735_ + 39, this.f_97736_ + 23, 14, 14, TCConfig.ENABLE_FLUIDS_SEARCH.get(), CompassProperties.FLUIDS, new IconTexture(ClientData.FLUIDS_ACTIVE, 2, 2), new IconTexture(ClientData.FLUIDS_INACTIVE, 2, 2), this.stack){
            private int frameIndex;
            private int tickCount;
            final int framesPerTick = 2;
            final int maxFrames = 31;
            {
                this.frameIndex = 0;
                this.tickCount = 0;
                this.framesPerTick = 2;
                this.maxFrames = 31;
            }

            @Override
            public void tick() {
                ++this.tickCount;
                if (this.tickCount % 2 == 0) {
                    this.frameIndex = (this.frameIndex + 1) % 31;
                }
            }

            @Override
            public void renderIcon(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                IconTexture icon = this.isToggled() ? this.iconActive : this.iconInactive;
                int yOff = 8 * this.frameIndex;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                TextureData data = icon.textureData().toBuilder().uv(0, yOff).build();
                ClientUtils.renderTexture(graphics, data, this.m_252754_() + icon.xOffset(), this.m_252907_() + icon.yOffset());
            }
        };
        this.spawnersSearchButton = new SearchModeButton(this.f_97735_ + 23, this.f_97736_ + 23, 14, 14, TCConfig.ENABLE_SPAWNERS_SEARCH.get(), CompassProperties.SPAWNERS, new IconTexture(ClientData.SPAWNERS_ACTIVE, 2, 2), new IconTexture(ClientData.SPAWNERS_INACTIVE, 2, 2), this.stack);
        this.itemEntitiesSearchButton = new SearchModeButton(this.f_97735_ + 23, this.f_97736_ + 39, 14, 14, TCConfig.ENABLE_ITEM_ENTITIES_SEARCH.get(), CompassProperties.ITEM_ENTITIES, new IconTexture(ClientData.ITEM_ENTITIES_ACTIVE, 2, 2), new IconTexture(ClientData.ITEM_ENTITIES_INACTIVE, 2, 2), this.stack);
        this.dropsSearchButton = new SearchModeButton(this.f_97735_ + 39, this.f_97736_ + 39, 14, 14, TCConfig.ENABLE_DROPS_SEARCH.get(), CompassProperties.DROP, new IconTexture(ClientData.DROPS_ACTIVE, 1, 2), new IconTexture(ClientData.DROPS_INACTIVE, 1, 2), this.stack);
        this.containersSearchButton = new ContainersButton(this.f_97735_ + 39, this.f_97736_ + 7, this.stack);
        this.villagersSearchButton = new VillagersButton(this.f_97735_ + 7, this.f_97736_ + 23, this.stack);
        this.inventoriesSearchButton = new InventoriesButton(this.f_97735_ + 7, this.f_97736_ + 39, this.stack);
        this.wideSearchButton = new WideSearchButton(this.f_97735_ + 23, this.f_97736_ + 55, () -> this.stack){

            @Override
            public void m_5716_(double mouseX, double mouseY) {
                super.m_5716_(mouseX, mouseY);
                CompassScreen.this.pauseButton.updateState();
            }
        };
        this.infoButton = new InfoButton(this.f_97735_ + 39, this.f_97736_ + 55, 14, 14, () -> this.stack);
        this.pauseButton = new SettingsButton(this.f_97735_ + 7, this.f_97736_ + 55, 14, 14, CompassProperties.PAUSE, value -> {
            if (((Boolean)value).booleanValue()) {
                return new SettingsButton.DisplayDataHolder(new IconTexture(ClientData.RESUME, 2, 2), new IconTexture(ClientData.RESUME_HOVERED, 2, 2), (Component)Component.m_237119_());
            }
            return new SettingsButton.DisplayDataHolder(new IconTexture(ClientData.PAUSE, 2, 2), new IconTexture(ClientData.PAUSE_HOVERED, 2, 2), (Component)Component.m_237119_());
        }, () -> this.stack){
            private SearchState cachedState;
            {
                this.cachedState = SearchState.IDLE;
            }

            @Override
            public void m_5716_(double mouseX, double mouseY) {
                super.m_5716_(mouseX, mouseY);
                ClientData.HUD_DATA_CACHE.computeIfPresent(CompassScreen.this.uuid, (id, hudData) -> {
                    hudData.setPaused((Boolean)this.cachedValue);
                    return hudData;
                });
                ClientData.PROGRESS_DATA_CACHE.remove(CompassScreen.this.uuid);
                Platform.PLATFORM_NETWORK.sendC2SPausePacket(CompassScreen.this.uuid);
            }

            @Override
            public void updateState() {
                super.updateState();
                ItemStack stack = (ItemStack)this.supplier.get();
                this.cachedState = CompassProperties.SEARCH_STATE.get(stack);
            }

            @Override
            public void refreshTooltip() {
                ArrayList<Component> list = new ArrayList<Component>();
                boolean paused = (Boolean)this.cachedValue;
                String key = "tooltip.travelerscompass.settings." + (paused ? "resume" : "pause");
                MutableComponent title = Component.m_237115_((String)key);
                list.add((Component)title);
                if (this.cachedState == SearchState.WIDE_SEARCHING && paused) {
                    list.add((Component)Component.m_237115_((String)(key + ".warning")).m_130940_(ChatFormatting.GRAY));
                }
                if (this.shiftPressed) {
                    list.add((Component)Component.m_237119_().m_7220_(ClientUtils.DESC_ARROW).m_7220_((Component)Component.m_237115_((String)(key + ".desc")).m_130940_(ChatFormatting.GRAY)));
                }
                this.m_257544_(Tooltip.m_257550_((Component)ClientUtils.buildTooltip(list)));
            }
        };
        this.attitudeMarkerButton = new SettingsButton(this.f_97735_ + 39, this.f_97736_ + 39, 14, 14, CompassProperties.HEIGHT_MARKER, value -> {
            if (((Boolean)value).booleanValue()) {
                return new SettingsButton.DisplayDataHolder(new IconTexture(ClientData.ATTITUDE_MARKER_ACTIVE, 2, 2), new IconTexture(ClientData.ATTITUDE_MARKER_ACTIVE_HOVERED, 2, 2), Toggleable.ENABLED);
            }
            return new SettingsButton.DisplayDataHolder(new IconTexture(ClientData.ATTITUDE_MARKER_INACTIVE, 2, 2), new IconTexture(ClientData.ATTITUDE_MARKER_INACTIVE_HOVERED, 2, 2), Toggleable.DISABLED);
        }, () -> this.stack);
        this.priorityButton = new SettingsButton(this.f_97735_ + 23, this.f_97736_ + 39, 14, 14, CompassProperties.PRIORITY_MODE, value -> {
            PriorityMode priorityMode = (PriorityMode)((Object)((Object)value));
            return switch (priorityMode) {
                default -> throw new IncompatibleClassChangeError();
                case PriorityMode.OFF -> new SettingsButton.DisplayDataHolder(ClientData.PRIORITY_OFF_ICON, ClientData.PRIORITY_OFF_HOVERED_ICON, (Component)Component.m_237119_());
                case PriorityMode.NORMAL -> new SettingsButton.DisplayDataHolder(ClientData.PRIORITY_NORMAL_ICON, ClientData.PRIORITY_NORMAL_HOVERED_ICON, (Component)Component.m_237119_());
                case PriorityMode.INVERTED -> new SettingsButton.DisplayDataHolder(ClientData.PRIORITY_INVERT_ICON, ClientData.PRIORITY_INVERT_HOVERED_ICON, (Component)Component.m_237119_());
            };
        }, () -> this.stack){

            @Override
            public void refreshTooltip() {
                ArrayList<Component> list = new ArrayList<Component>();
                String key = "tooltip.travelerscompass.settings.priority_mode";
                MutableComponent title = Component.m_237115_((String)key);
                Component state = switch ((PriorityMode)((Object)this.cachedValue)) {
                    default -> throw new IncompatibleClassChangeError();
                    case PriorityMode.OFF -> Toggleable.DISABLED;
                    case PriorityMode.NORMAL -> Toggleable.ENABLED;
                    case PriorityMode.INVERTED -> Toggleable.INVERTED;
                };
                list.add((Component)title);
                if (this.shiftPressed) {
                    String descKey = key + ".desc." + ((PriorityMode)((Object)this.cachedValue)).name().toLowerCase();
                    list.add((Component)Component.m_237119_().m_7220_(ClientUtils.DESC_ARROW).m_7220_((Component)Component.m_237115_((String)descKey).m_130940_(ChatFormatting.GRAY)));
                }
                list.add(state);
                this.m_257544_(Tooltip.m_257550_((Component)ClientUtils.buildTooltip(list)));
            }
        };
        this.soundPingButton = new SettingsButton(this.f_97735_ + 7, this.f_97736_ + 39, 14, 14, CompassProperties.SOUND_PING, value -> {
            if (((Boolean)value).booleanValue()) {
                return new SettingsButton.DisplayDataHolder(new IconTexture(ClientData.SOUND_PING_ACTIVE, 3, 3), new IconTexture(ClientData.SOUND_PING_ACTIVE_HOVERED, 3, 3), Toggleable.ENABLED);
            }
            return new SettingsButton.DisplayDataHolder(new IconTexture(ClientData.SOUND_PING_INACTIVE, 3, 3), new IconTexture(ClientData.SOUND_PING_INACTIVE_HOVERED, 3, 3), Toggleable.DISABLED);
        }, () -> this.stack);
        this.warningButton = new WarningButton(this.f_97735_ - 17, this.f_97736_ + 76, 21, 22, this.stack);
        this.hudButton = new HudButton(this.f_97735_ + 7, this.f_97736_ + 55, () -> this.stack){

            @Override
            public void onPopupExit() {
                CompassScreen.this.warningButton.hidden = false;
                CompassScreen.this.warningButton.updateState(CompassScreen.this.stack);
            }

            @Override
            public void onPopupEnter() {
                CompassScreen.this.warningButton.hidden = true;
                CompassScreen.this.warningButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237119_()));
            }
        };
        this.forceChunksLoadButton = new SettingsButton(this.f_97735_ + 39, this.f_97736_ + 23, 14, 14, CompassProperties.FORCE_CHUNKS_LOAD, value -> {
            if (((Boolean)value).booleanValue()) {
                return new SettingsButton.DisplayDataHolder(ClientData.FORCE_LOAD_ACTIVE.icon(2, 2), ClientData.FORCE_LOAD_ACTIVE_HOVERED.icon(2, 2), Toggleable.ENABLED);
            }
            return new SettingsButton.DisplayDataHolder(ClientData.FORCE_LOAD_INACTIVE.icon(2, 2), ClientData.FORCE_LOAD_INACTIVE_HOVERED.icon(2, 2), Toggleable.DISABLED);
        }, () -> this.stack);
        this.targetValidationButton = new SettingsButton(this.f_97735_ + 23, this.f_97736_ + 55, 14, 14, CompassProperties.TARGET_VALIDATION, value -> {
            if (((Boolean)value).booleanValue()) {
                return new SettingsButton.DisplayDataHolder(ClientData.TARGET_VALIDATION_ACTIVE.icon(3, 2), ClientData.TARGET_VALIDATION_ACTIVE_HOVERED.icon(3, 2), Toggleable.ENABLED);
            }
            return new SettingsButton.DisplayDataHolder(ClientData.TARGET_VALIDATION_INACTIVE.icon(3, 2), ClientData.TARGET_VALIDATION_INACTIVE_HOVERED.icon(3, 2), Toggleable.DISABLED);
        }, () -> this.stack);
        this.resetButton = new ResetButton(this.f_97735_ + 39, this.f_97736_ + 55, buttonDefault -> {
            this.resetSettings();
            this.entitiesSearchRange.updateState();
            this.chunksSearchRangeButton.updateState();
            this.wideSearchRange.updateState();
        });
        this.chunksSearchRangeButton = new RangeButton<Integer>(this.f_97735_ + 23, this.f_97736_ + 23, 14, 14, 1, TCConfig.BLOCKS_CHUNK_SEARCH_RANGE.get(), RangeUtils.INTEGER, new IconTexture(ClientData.CHUNKS_RANGE, 2, 2), CompassProperties.BLOCK_SEARCH_CHUNK_RANGE, () -> this.stack);
        this.entitiesSearchRange = new RangeButton<Integer>(this.f_97735_ + 23, this.f_97736_ + 7, 14, 14, 1, TCConfig.ENTITIES_SEARCH_RANGE.get(), RangeUtils.INTEGER, new IconTexture(ClientData.ENTITIES_RANGE, 2, 2), CompassProperties.ENTITIES_SEARCH_RANGE, () -> this.stack);
        this.wideSearchRange = new RangeButton<Integer>(this.f_97735_ + 39, this.f_97736_ + 7, 14, 14, 1, TCConfig.WIDE_SEARCH_RANGE.get(), RangeUtils.INTEGER, new IconTexture(ClientData.WIDE_SEARCH_RANGE, 2, 2), CompassProperties.WIDE_SEARCH_RANGE, () -> this.stack);
    }

    private void addSearchButtons() {
        this.m_142416_((GuiEventListener)this.blocksSearchButton);
        this.m_142416_((GuiEventListener)this.mobsSearchButton);
        this.m_142416_((GuiEventListener)this.containersSearchButton);
        this.m_142416_((GuiEventListener)this.villagersSearchButton);
        this.m_142416_((GuiEventListener)this.spawnersSearchButton);
        this.m_142416_((GuiEventListener)this.fluidsSearchButton);
        this.m_142416_((GuiEventListener)this.inventoriesSearchButton);
        this.m_142416_((GuiEventListener)this.itemEntitiesSearchButton);
        this.m_142416_((GuiEventListener)this.dropsSearchButton);
        this.m_142416_((GuiEventListener)this.pauseButton);
        this.m_142416_((GuiEventListener)this.wideSearchButton);
        this.m_142416_((GuiEventListener)this.infoButton);
    }

    private void removeSearchButtons() {
        this.m_169411_((GuiEventListener)this.blocksSearchButton);
        this.m_169411_((GuiEventListener)this.mobsSearchButton);
        this.m_169411_((GuiEventListener)this.containersSearchButton);
        this.m_169411_((GuiEventListener)this.villagersSearchButton);
        this.m_169411_((GuiEventListener)this.spawnersSearchButton);
        this.m_169411_((GuiEventListener)this.fluidsSearchButton);
        this.m_169411_((GuiEventListener)this.inventoriesSearchButton);
        this.m_169411_((GuiEventListener)this.itemEntitiesSearchButton);
        this.m_169411_((GuiEventListener)this.dropsSearchButton);
        this.m_169411_((GuiEventListener)this.pauseButton);
        this.m_169411_((GuiEventListener)this.wideSearchButton);
        this.m_169411_((GuiEventListener)this.infoButton);
    }

    private void addSettingsButton() {
        this.m_142416_((GuiEventListener)this.hudButton);
        this.m_142416_((GuiEventListener)this.forceChunksLoadButton);
        this.m_142416_((GuiEventListener)this.targetValidationButton);
        this.m_142416_((GuiEventListener)this.attitudeMarkerButton);
        this.m_142416_((GuiEventListener)this.soundPingButton);
        this.m_142416_((GuiEventListener)this.priorityButton);
        this.m_142416_((GuiEventListener)this.chunksSearchRangeButton);
        this.m_142416_((GuiEventListener)this.entitiesSearchRange);
        this.m_142416_((GuiEventListener)this.wideSearchRange);
        this.m_142416_((GuiEventListener)this.resetButton);
    }

    private void removeSettingsButton() {
        this.m_169411_((GuiEventListener)this.hudButton);
        this.m_169411_((GuiEventListener)this.forceChunksLoadButton);
        this.m_169411_((GuiEventListener)this.targetValidationButton);
        this.m_169411_((GuiEventListener)this.attitudeMarkerButton);
        this.m_169411_((GuiEventListener)this.soundPingButton);
        this.m_169411_((GuiEventListener)this.priorityButton);
        this.m_169411_((GuiEventListener)this.chunksSearchRangeButton);
        this.m_169411_((GuiEventListener)this.entitiesSearchRange);
        this.m_169411_((GuiEventListener)this.wideSearchRange);
        this.m_169411_((GuiEventListener)this.resetButton);
    }

    private void addTabButtons() {
        boolean searchMode = this.tabPage == TabPage.SEARCH;
        this.tabButton1 = (TabButton)this.m_142416_((GuiEventListener)new TabButton(this.f_97735_ + 130, this.f_97736_ + 8, 26, 24, 6, 4, searchMode, ClientData.SEARCH, button -> {
            if (this.tabPage == TabPage.SETTINGS) {
                this.tabButton1.enabled = true;
                this.tabButton2.enabled = false;
                CompassProperties.putFromClient(this.stack, CompassProperties.TAB_PAGE, TabPage.SEARCH);
                this.tabPage = TabPage.SEARCH;
                this.addSearchButtons();
                this.removeSettingsButton();
            }
        }, (Component)Component.m_237115_((String)"tooltip.travelerscompass.search")));
        this.tabButton2 = new TabButton(this.f_97735_ + 130, this.f_97736_ + 42, 26, 24, 6, 4, !searchMode, ClientData.SETTINGS, button -> {
            if (this.tabPage == TabPage.SEARCH) {
                this.tabButton1.enabled = false;
                this.tabButton2.enabled = true;
                CompassProperties.putFromClient(this.stack, CompassProperties.TAB_PAGE, TabPage.SETTINGS);
                this.tabPage = TabPage.SETTINGS;
                this.addSettingsButton();
                this.removeSearchButtons();
            }
        }, (Component)Component.m_237115_((String)"tooltip.travelerscompass.settings"));
        this.m_142416_((GuiEventListener)this.tabButton1);
        this.m_142416_((GuiEventListener)this.tabButton2);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null && this.f_96541_.f_91074_.m_21205_().m_41720_() instanceof TravelersCompassItem) {
            this.stack = this.f_96541_.f_91074_.m_21205_();
        }
    }

    protected void m_280072_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280072_(guiGraphics, mouseX, mouseY);
        if (!TCConfig.SEARCH_REQUIRES_XP.get().booleanValue()) {
            return;
        }
        Slot slot = this.f_97734_;
        if (slot != null && slot.f_40218_ instanceof CompassContainer) {
            Item carried = ((CompassMenu)this.m_6262_()).m_142621_().m_41720_();
            SearchCost sc = SearchCostHelper.getCost(carried);
            FilterReason reason = FilterManager.getFilterReason(carried);
            if (reason instanceof FilterReason.Allowed) {
                if (!sc.isFree() && !this.player.m_7500_()) {
                    ArrayList<MutableComponent> extra = new ArrayList<MutableComponent>();
                    extra.add(sc.reqAsComponent().m_130940_(sc.meetsRequirement(this.player.f_36078_) ? ChatFormatting.GRAY : ChatFormatting.RED));
                    extra.add(sc.costAsComponent().m_130940_(ChatFormatting.GRAY));
                    guiGraphics.m_280666_(this.f_96547_, extra, mouseX, mouseY);
                }
            } else {
                guiGraphics.m_280557_(this.f_96547_, ClientUtils.formatReason(reason), mouseX, mouseY);
            }
        }
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        this.m_280273_(graphics);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && this.stack != null) {
            graphics.m_280218_(this.tabPage.equals((Object)TabPage.SEARCH) ? TEXTURE_1 : TEXTURE_2, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
            for (int i : CompassProperties.get(this.stack, CompassProperties.PRIORITY_SLOTS)) {
                int j = i > 2 ? 1 : 0;
                j = i > 5 ? 2 : j;
                int c = i > 2 ? i - 3 : i;
                c = i > 5 ? i - 6 : c;
                graphics.m_280163_(PRIORITY_SLOT, this.f_97735_ + 72 + c * 18, this.f_97736_ + 10 + j * 18, 0.0f, 0.0f, 18, 18, 18, 18);
            }
        }
    }

    private void resetSettings() {
        List<DataStorage<Integer>> toReset = List.of(CompassProperties.TARGET_VALIDATION, CompassProperties.SOUND_PING, CompassProperties.HEIGHT_MARKER, CompassProperties.HUD_RENDER_MODE, CompassProperties.PRIORITY_MODE, CompassProperties.FORCE_CHUNKS_LOAD, CompassProperties.ENTITIES_SEARCH_RANGE, CompassProperties.BLOCK_SEARCH_CHUNK_RANGE, CompassProperties.WIDE_SEARCH_RANGE);
        for (DataStorage<Integer> data : toReset) {
            CompassProperties.writeDefaultFromClient(this.stack, data);
        }
        this.targetValidationButton.updateState();
        this.soundPingButton.updateState();
        this.attitudeMarkerButton.updateState();
        this.priorityButton.updateState();
        this.forceChunksLoadButton.updateState();
        this.entitiesSearchRange.updateState();
        this.chunksSearchRangeButton.updateState();
        this.wideSearchRange.updateState();
        this.hudButton.resetSettings(this.stack);
        this.hudButton.updateState();
    }

    public int leftPos() {
        return this.f_97735_;
    }

    public int topPos() {
        return this.f_97736_;
    }
}

