/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.utils;

import com.nine.travelerscompass.client.utils.IconTexture;
import com.nine.travelerscompass.client.utils.TextureData;
import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.search.location.WithContent;
import com.nine.travelerscompass.config.filter.FilterReason;
import com.nine.travelerscompass.platform.Platform;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class ClientUtils {
    public static final int SOFT_GRAY = 0xC8C8C8;
    public static final int GRAY = 0xAAAAAA;
    public static final int HONEY = 13939050;
    public static final int SOFT_HONEY = 16176273;
    public static final int SOFT_GREEN = 11462271;
    public static final int SOFT_RED = 12077385;
    public static final float MAX_SCALE = 3.0f;
    public static final float MIN_SCALE = 0.3f;
    public static final ResourceLocation SPACE_HELPER = new ResourceLocation("travelerscompass", "space_helper");
    public static final Component DESC_ARROW_INDENT = Component.m_237113_((String)"\uf820").m_130948_(Style.f_131099_.m_131150_(SPACE_HELPER));
    public static final Component DESC_ARROW = ClientUtils.coloredComponent(Component.m_237113_((String)"\u25b6").m_7220_(DESC_ARROW_INDENT), 0xC8C8C8);
    public static final Component DISABLED = Component.m_237115_((String)"tooltip.travelerscompass.disabled").m_130940_(ChatFormatting.GRAY);
    public static final Component ENABLED = Component.m_237115_((String)"tooltip.travelerscompass.enabled").m_130940_(ChatFormatting.GRAY);

    public static Component buildTooltip(Component title, Component ... toAppend) {
        MutableComponent ret = Component.m_237119_().m_7220_(title);
        for (Component component : toAppend) {
            ret = ret.m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_(component);
        }
        return ret;
    }

    public static Component buildSearchModeTooltip(String titleKey, List<String> descKeys, boolean state) {
        return ClientUtils.buildToggleTooltip(titleKey, descKeys, ENABLED, DISABLED, state);
    }

    public static Component buildToggleTooltip(String titleKey, List<String> descKeys, Component enabled, Component disabled, boolean state) {
        List<Component> components = ClientUtils.buildToggleComponentsList(titleKey, descKeys, state ? enabled : disabled);
        return ClientUtils.buildTooltip(components);
    }

    public static Component buildSearchModeTooltip(String titleKey, List<String> descKeys, Component state) {
        List<Component> components = ClientUtils.buildToggleComponentsList(titleKey, descKeys, state);
        return ClientUtils.buildTooltip(components);
    }

    public static List<Component> buildToggleComponentsList(String titleKey, List<String> descKeys, boolean state) {
        return ClientUtils.buildToggleComponentsList(titleKey, descKeys, state ? ENABLED : DISABLED);
    }

    public static List<Component> buildToggleComponentsList(String titleKey, List<String> descKeys, Component enabled, Component disabled, boolean state) {
        return ClientUtils.buildToggleComponentsList(titleKey, descKeys, state ? enabled : disabled);
    }

    public static List<Component> buildToggleComponentsList(String titleKey, List<String> descKeys, Component state) {
        ArrayList<Component> ret = new ArrayList<Component>();
        ret.add((Component)Component.m_237115_((String)titleKey).m_130940_(ChatFormatting.WHITE));
        if (descKeys != null) {
            for (String descKey : descKeys) {
                ret.add((Component)Component.m_237119_().m_7220_(DESC_ARROW).m_7220_((Component)Component.m_237115_((String)descKey).m_130940_(ChatFormatting.GRAY)));
            }
        }
        ret.add(state);
        return ret;
    }

    public static List<Component> buildSearchModeTooltip(Component title, List<String> descriptions, Component state) {
        ArrayList<Component> ret = new ArrayList<Component>();
        ret.add(title);
        if (descriptions != null) {
            for (String descKey : descriptions) {
                ret.add((Component)Component.m_237119_().m_7220_(DESC_ARROW).m_7220_((Component)Component.m_237115_((String)descKey).m_130940_(ChatFormatting.GRAY)));
            }
        }
        ret.add(state);
        return ret;
    }

    public static Component buildTooltip(List<Component> components) {
        if (components.isEmpty()) {
            return Component.m_237119_();
        }
        Iterator<Component> iterator = components.iterator();
        MutableComponent ret = Component.m_237119_().m_7220_(iterator.next());
        while (iterator.hasNext()) {
            ret = ret.m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_(iterator.next());
        }
        return ret;
    }

    public static MutableComponent coloredComponent(MutableComponent start, int color) {
        return start.m_130948_(start.m_7383_().m_178520_(color));
    }

    public static MutableComponent setColor(MutableComponent component, int color) {
        return component.m_130948_(component.m_7383_().m_178520_(color));
    }

    public static Component getDistance(BlockPos playerPos, BlockPos targetPos) {
        return Component.m_237113_((String)String.valueOf((int)Math.sqrt(playerPos.m_123331_((Vec3i)targetPos)))).m_130940_(ChatFormatting.GRAY);
    }

    public static Component getLocationObjectTargetName(ILocationObject object) {
        int softColor;
        boolean priority = object.priority();
        int defaultColor = priority ? 13939050 : 0xAAAAAA;
        int n = softColor = priority ? 16176273 : 0xC8C8C8;
        if (object instanceof WithContent) {
            WithContent withContent = (WithContent)((Object)object);
            MutableComponent ret = Component.m_237119_();
            ret.m_7220_((Component)ClientUtils.coloredComponent(Component.m_237115_((String)object.descriptionId()), defaultColor));
            ret.m_7220_((Component)ClientUtils.coloredComponent(Component.m_237113_((String)" ["), defaultColor));
            ret.m_7220_((Component)ClientUtils.coloredComponent(Component.m_237115_((String)withContent.contentId()), softColor));
            ret.m_7220_((Component)ClientUtils.coloredComponent(Component.m_237113_((String)"]"), defaultColor));
            return ret;
        }
        return ClientUtils.coloredComponent(Component.m_237115_((String)object.descriptionId()), defaultColor);
    }

    public static Component cutComponent(Font font, Component component, int availableWidth) {
        MutableComponent ret = Component.m_237119_();
        MutableComponent dots = Component.m_237113_((String)"...");
        int dotsWidth = font.m_92852_((FormattedText)dots);
        if (availableWidth <= font.m_92852_((FormattedText)dots)) {
            return dots;
        }
        int componentWidth = font.m_92852_((FormattedText)component);
        if (componentWidth <= availableWidth) {
            return component;
        }
        int widthUsed = 0;
        for (Component content : component.m_240407_()) {
            int contentWidth = font.m_92852_((FormattedText)content);
            if (widthUsed + contentWidth + dotsWidth <= availableWidth) {
                ret.m_7220_(content);
                widthUsed += contentWidth;
                continue;
            }
            String s = content.getString();
            if (widthUsed + dotsWidth >= availableWidth) {
                ret.m_7220_((Component)dots.m_130948_(content.m_7383_()));
                break;
            }
            MutableComponent formated = Component.m_237113_((String)font.m_92834_(s, availableWidth - widthUsed - dotsWidth)).m_130948_(content.m_7383_()).m_7220_((Component)dots.m_130948_(content.m_7383_()));
            ret.m_7220_((Component)formated);
            break;
        }
        return ret;
    }

    public static String compressNumber(int val) {
        int abs = Math.abs(val);
        if (abs >= 1000000) {
            return val / 1000000 + Component.m_237115_((String)"hud.travelerscompass.number.mega").getString();
        }
        if (abs >= 1000) {
            return val / 1000 + Component.m_237115_((String)"hud.travelerscompass.number.kilo").getString();
        }
        return String.valueOf(val);
    }

    public static Component formatReason(FilterReason reason) {
        if (reason instanceof FilterReason.ByModId) {
            FilterReason.ByModId byMod = (FilterReason.ByModId)reason;
            return Component.m_237110_((String)"tooltip.travelerscompass.config.filter_reason.mod", (Object[])new Object[]{Platform.PLATFORM.getModName(byMod.modId())}).m_130940_(ChatFormatting.RED);
        }
        if (reason instanceof FilterReason.ByItemId) {
            return Component.m_237115_((String)"tooltip.travelerscompass.config.filter_reason.item").m_130940_(ChatFormatting.RED);
        }
        if (reason instanceof FilterReason.ByTag) {
            FilterReason.ByTag byTag = (FilterReason.ByTag)reason;
            return Component.m_237110_((String)"tooltip.travelerscompass.config.filter_reason.tag", (Object[])new Object[]{byTag.tag().f_203868_().toString()}).m_130940_(ChatFormatting.RED);
        }
        if (reason instanceof FilterReason.ByEntityType) {
            FilterReason.ByEntityType byEntityType = (FilterReason.ByEntityType)reason;
            Component entityName = byEntityType.type().m_20676_();
            return Component.m_237110_((String)"tooltip.travelerscompass.config.filter_reason.entity", (Object[])new Object[]{entityName}).m_130940_(ChatFormatting.RED);
        }
        return Component.m_237119_();
    }

    public static void renderTexture(GuiGraphics graphics, IconTexture iconTexture, int x, int y) {
        ClientUtils.renderTexture(graphics, iconTexture.textureData(), x + iconTexture.xOffset(), y + iconTexture.yOffset());
    }

    public static void renderTexture(GuiGraphics graphics, TextureData data, int x, int y) {
        graphics.m_280411_(data.getLocation(), x, y, data.getRenderWidth(), data.getRenderHeight(), (float)data.getU(), (float)data.getV(), data.getWidth(), data.getHeight(), data.getTextureWidth(), data.getTextureHeight());
    }
}

