/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.search;

import com.nine.travelerscompass.common.search.location.ILocationObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SearchResult {
    private static final int MAX_SIZE = 100000;
    private static final int MAX_PER_KEY = 1000;
    private final List<ILocationObject> result = new ArrayList<ILocationObject>();
    private final Map<String, Integer> keyCounts = new HashMap<String, Integer>();

    private static String extractKey(ILocationObject locationObject) {
        return locationObject.descriptionId();
    }

    public void addAll(List<ILocationObject> locationObjects) {
        for (ILocationObject obj : locationObjects) {
            this.add(obj);
        }
    }

    public boolean add(ILocationObject locationObject) {
        if (this.result.size() > 100000) {
            return false;
        }
        String key = SearchResult.extractKey(locationObject);
        int current = this.keyCounts.getOrDefault(key, 0);
        if (current >= 1000) {
            return false;
        }
        this.keyCounts.put(key, current + 1);
        this.result.add(locationObject);
        return true;
    }

    public List<ILocationObject> get() {
        return this.result;
    }
}

