/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.search.location;

import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.search.location.WithContent;
import com.nine.travelerscompass.common.search.location.codec.LocationCodec;
import com.nine.travelerscompass.platform.Platform;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public record ContainerLocationObject(BlockPos blockPos, int slotIndex, boolean priority, int containerSlotIndex, String descriptionId, String contentId, ResourceLocation blockId) implements ILocationObject,
WithContent
{
    public static ResourceLocation TYPE = new ResourceLocation("travelerscompass", "container_location_codec");
    public static final LocationCodec<ContainerLocationObject> CODEC = new LocationCodec<ContainerLocationObject>(){

        @Override
        public void write(FriendlyByteBuf buf, ContainerLocationObject obj) {
            this.writePosSafe(buf, obj.blockPos);
            buf.writeInt(obj.slotIndex);
            buf.writeBoolean(obj.priority);
            buf.writeInt(obj.containerSlotIndex);
            buf.m_130070_(obj.descriptionId);
            buf.m_130070_(obj.contentId);
            buf.m_130085_(obj.blockId);
        }

        @Override
        public ContainerLocationObject read(FriendlyByteBuf buf) {
            BlockPos blockPos = this.readPosSafe(buf);
            int slotIndex = buf.readInt();
            boolean priority = buf.readBoolean();
            int containerSlotIndex = buf.readInt();
            String descriptionId = buf.m_130277_();
            String containerId = buf.m_130277_();
            ResourceLocation blockId = buf.m_130281_();
            return new ContainerLocationObject(blockPos, slotIndex, priority, containerSlotIndex, descriptionId, containerId, blockId);
        }
    };

    @Override
    public ResourceLocation type() {
        return TYPE;
    }

    @Override
    public boolean isValid(ServerLevel level) {
        BlockEntity blockEntity;
        boolean loaded = level.m_46749_(this.blockPos);
        if (!loaded) {
            return true;
        }
        Block block = level.m_8055_(this.blockPos).m_60734_();
        boolean sameBlock = ((Block)BuiltInRegistries.f_256975_.m_7745_(this.blockId)).equals(block);
        if (sameBlock && (blockEntity = level.m_7702_(this.blockPos)) != null) {
            Item item = Platform.PLATFORM.getContainerItemByIndex(this.containerSlotIndex, blockEntity);
            return Objects.equals(item.m_5524_(), this.contentId);
        }
        return sameBlock;
    }

    @Override
    public ILocationObject copy(BlockPos blockPos, int slotIndex, boolean priority, String descriptionId) {
        return new ContainerLocationObject(blockPos, slotIndex, priority, this.containerSlotIndex, descriptionId, this.contentId, this.blockId);
    }

    @Override
    public Optional<ILocationObject> update(ServerLevel level) {
        return Optional.of(this);
    }

    @Override
    public String toString() {
        return "Block Container Entity [" + this.descriptionId + ": " + this.contentId + "], " + String.valueOf(this.blockPos) + (this.priority ? " [priority]" : "");
    }
}

