/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.network.packet.c2s;

import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.data.DataStorage;
import com.nine.travelerscompass.common.item.TravelersCompassItem;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class CompassDataPacket {
    private final ResourceLocation id;
    private final CompoundTag tag;

    public CompassDataPacket(DataStorage<?> data, CompoundTag tag) {
        this.id = data.getId();
        this.tag = tag;
    }

    public CompassDataPacket(FriendlyByteBuf buf) {
        this.id = buf.m_130281_();
        this.tag = CompassProperties.CLIENT_EDITABLE.containsKey(this.id) ? buf.m_130260_() : null;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.id);
        if (CompassProperties.CLIENT_EDITABLE.containsKey(this.id)) {
            buf.m_130079_(this.tag);
        }
    }

    public void onMessage(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        ServerPlayer player = context.getSender();
        if (player == null) {
            return;
        }
        context.enqueueWork(() -> {
            if (!CompassProperties.CLIENT_EDITABLE.containsKey(this.id)) {
                return;
            }
            ItemStack stack = player.m_21205_();
            DataStorage<?> dataStorage = CompassProperties.REGISTRY.get(this.id);
            if (stack.m_41720_() instanceof TravelersCompassItem && this.tag != null) {
                Object value = CompassProperties.get(this.tag, dataStorage);
                DataStorage<?> resDataStorage = dataStorage;
                CompassProperties.putWithValidation(stack, resDataStorage, value);
            }
        });
        context.setPacketHandled(true);
    }
}

