/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.network.packet.c2s;

import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.item.TravelersCompassItem;
import com.nine.travelerscompass.common.search.SearchManager;
import com.nine.travelerscompass.common.utils.SearchState;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PausePacket {
    private final UUID uuid;

    public PausePacket(UUID uuid) {
        this.uuid = uuid;
    }

    public PausePacket(FriendlyByteBuf buf) {
        this.uuid = buf.m_130259_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.uuid);
    }

    public void onMessage(Supplier<NetworkEvent.Context> contextSupplier) {
        ServerPlayer player = contextSupplier.get().getSender();
        if (player == null) {
            return;
        }
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> this.lambda$onMessage$0((Player)player));
        context.setPacketHandled(true);
    }

    private /* synthetic */ void lambda$onMessage$0(Player player) {
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() instanceof TravelersCompassItem && Objects.equals(CompassProperties.COMPASS_UUID.get(stack), this.uuid) && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SearchManager.stopScan(this.uuid);
            SearchManager.removeWatcher(this.uuid, serverPlayer);
            CompassProperties.SEARCH_STATE.put(stack, SearchState.IDLE);
        }
    }
}

