/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.network.packet.s2c;

import com.nine.travelerscompass.client.ClientData;
import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.search.location.codec.LocationCodecs;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class HudLocationDataPacket {
    private final ILocationObject object;
    private final UUID uuid;
    private final boolean valid;

    public HudLocationDataPacket(ILocationObject object, UUID uuid) {
        this.valid = object != null;
        this.object = object;
        this.uuid = uuid;
    }

    public HudLocationDataPacket(FriendlyByteBuf buf) {
        this.valid = buf.readBoolean();
        this.object = this.valid ? LocationCodecs.read(buf) : null;
        this.uuid = buf.m_130259_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.valid);
        if (this.valid) {
            LocationCodecs.write(buf, this.object);
        }
        buf.m_130077_(this.uuid);
    }

    public static void onMessage(HudLocationDataPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            UUID uuid = packet.uuid;
            ILocationObject object = packet.object;
            if (ClientData.HUD_DATA_CACHE.containsKey(uuid)) {
                ClientData.HUD_DATA_CACHE.get(uuid).setLocationObject(object);
            }
        }));
        ctx.get().setPacketHandled(true);
    }
}

