/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.platform;

import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.search.SearchOptions;
import com.nine.travelerscompass.common.search.criterion.ISearchCriterion;
import com.nine.travelerscompass.common.search.criterion.TypedCriteria;
import com.nine.travelerscompass.common.search.location.ContainerLocationObject;
import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.search.matcher.BlockEntityMatcher;
import com.nine.travelerscompass.common.search.matcher.EntityMatcher;
import com.nine.travelerscompass.compat.CompatibilityHelper;
import com.nine.travelerscompass.compat.lootr.ForgeLootrHelper;
import com.nine.travelerscompass.compat.lootr.LootrSearchMode;
import com.nine.travelerscompass.config.TCConfig;
import com.nine.travelerscompass.platform.IPlatformMatchersHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class ForgePlatformMatchersHelper
implements IPlatformMatchersHelper {
    public static final EntityMatcher LOOTR_MINECART_MATCHER = new EntityMatcher(){

        @Override
        public List<ILocationObject> match(TypedCriteria criteria, SearchOptions options, Entity entity, Level level, BlockPos pos) {
            return ForgeLootrHelper.minecartMatch(criteria, options, entity, level, pos);
        }

        @Override
        public boolean isAllowed(SearchOptions options) {
            if (!options.get(CompassProperties.MINECARTS).booleanValue() || !TCConfig.ENABLE_BLOCK_CONTAINERS_SEARCH.get().booleanValue()) {
                return false;
            }
            return CompatibilityHelper.LOOTR_LOADED && options.get(CompassProperties.LOOTR_MODE) != LootrSearchMode.OFF;
        }
    };
    public static final BlockEntityMatcher LOOTR_CONTAINER_MATCHER = new BlockEntityMatcher(){

        @Override
        public List<ILocationObject> match(TypedCriteria criteria, SearchOptions options, BlockPos pos, BlockState state, BlockEntity be) {
            return ForgeLootrHelper.matchLootrContainer(criteria, options, pos, state, be);
        }

        @Override
        public boolean isAllowed(SearchOptions options) {
            if (!options.get(CompassProperties.CONTAINERS).booleanValue() || !TCConfig.ENABLE_BLOCK_CONTAINERS_SEARCH.get().booleanValue()) {
                return false;
            }
            return CompatibilityHelper.LOOTR_LOADED && options.get(CompassProperties.LOOTR_MODE) != LootrSearchMode.OFF;
        }
    };
    public static final BlockEntityMatcher CONTAINER_MATCHER = new BlockEntityMatcher(){

        @Override
        public List<ILocationObject> match(TypedCriteria criteria, SearchOptions options, BlockPos pos, BlockState state, BlockEntity be) {
            Optional resolved;
            ArrayList<ILocationObject> ret = new ArrayList<ILocationObject>();
            if (criteria.itemCriteria.isEmpty()) {
                return List.of();
            }
            LazyOptional cap = be.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
            if (cap.isPresent() && (resolved = cap.resolve()).isPresent()) {
                IItemHandler itemHandler = (IItemHandler)resolved.get();
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    Item item = itemHandler.getStackInSlot(i).m_41720_();
                    if (!criteria.itemCriteriaMap.containsKey(item)) continue;
                    ISearchCriterion criterion = criteria.itemCriteriaMap.get(item);
                    ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
                    ret.add(new ContainerLocationObject(pos.m_7949_(), criterion.slot(), criterion.priority(), i, state.m_60734_().m_7705_(), item.m_5524_(), id));
                }
            }
            return ret;
        }

        @Override
        public boolean isAllowed(SearchOptions options) {
            if (!options.get(CompassProperties.CONTAINERS).booleanValue() || !TCConfig.ENABLE_BLOCK_CONTAINERS_SEARCH.get().booleanValue()) {
                return false;
            }
            return options.get(CompassProperties.CONTAINERS_CHESTS);
        }
    };

    @Override
    public BlockEntityMatcher lootrContainerMatcher() {
        return LOOTR_CONTAINER_MATCHER;
    }

    @Override
    public EntityMatcher lootrMinecartMatcher() {
        return LOOTR_MINECART_MATCHER;
    }

    @Override
    public BlockEntityMatcher containerMatcher() {
        return CONTAINER_MATCHER;
    }
}

