/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.compat.top;

import com.nine.travelerscompass.common.container.CompassContainer;
import com.nine.travelerscompass.common.item.TravelersCompassItem;
import com.nine.travelerscompass.config.TCConfig;
import com.nine.travelerscompass.config.cost.SearchCost;
import com.nine.travelerscompass.config.cost.SearchCostHelper;
import com.nine.travelerscompass.config.filter.FilterManager;
import com.nine.travelerscompass.config.filter.FilterReason;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class TOPBlockComponentProvider
implements IProbeInfoProvider {
    public void addProbeInfo(ProbeMode probeMode, IProbeInfo info, Player player, Level level, BlockState state, IProbeHitData data) {
        Block block = state.getBlock();
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof TravelersCompassItem)) {
            return;
        }
        if (probeMode == ProbeMode.EXTENDED && !player.isShiftKeyDown()) {
            return;
        }
        FilterReason reason = FilterManager.getFilterReason(block.asItem());
        if (reason instanceof FilterReason.Allowed) {
            CompassContainer compassContainer = CompassContainer.container(stack);
            if (!compassContainer.getList().contains(block.asItem()) && !compassContainer.getList().contains(stack.getItem())) {
                boolean reqOk;
                info.text(CompoundText.create().style(TextStyleClass.LABEL).text((Component)Component.translatable((String)"waila.travelerscompass.info.block")).style(TextStyleClass.LABEL));
                if (!TCConfig.SEARCH_REQUIRES_XP.get().booleanValue()) {
                    return;
                }
                SearchCost sc = SearchCostHelper.getCost(block.asItem());
                if (sc.isFree()) {
                    return;
                }
                boolean bl = reqOk = sc.meetsRequirement(player.experienceLevel) || player.isCreative();
                if (!sc.meetsRequirement(player.experienceLevel)) {
                    info.text(CompoundText.create().style(TextStyleClass.ERROR).text((Component)sc.reqAsComponent()).style(TextStyleClass.ERROR));
                }
                if (sc.costLevel() > 0) {
                    info.text(CompoundText.create().style(reqOk ? TextStyleClass.LABEL : TextStyleClass.ERROR).text((Component)sc.costAsComponent()).style(reqOk ? TextStyleClass.LABEL : TextStyleClass.ERROR));
                }
            }
        } else {
            info.text(CompoundText.create().style(TextStyleClass.ERROR).text((Component)Component.translatable((String)"waila.travelerscompass.forbidden_block")).style(TextStyleClass.ERROR));
        }
    }

    public ResourceLocation getID() {
        return ResourceLocation.fromNamespaceAndPath((String)"travelerscompass", (String)"block_info");
    }
}

