/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button;

import com.nine.travelerscompass.client.component.button.BaseButton;
import com.nine.travelerscompass.client.component.element.NewPopupElement;
import com.nine.travelerscompass.client.utils.TextureData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;

public class PopupButton
extends BaseButton {
    protected final TextureData popupConnector;
    protected final TextureData popup;
    protected final Rect2i mainRect;
    protected final Rect2i popupRect;
    private boolean popupVisible = false;
    protected List<NewPopupElement> popupElements = new ArrayList<NewPopupElement>();

    protected PopupButton(int x, int y, int width, int height, TextureData popupConnector, TextureData popupTexture, Rect2i mainRect, Rect2i popupRect) {
        super(x, y, width, height);
        this.mainRect = mainRect;
        this.popupRect = popupRect;
        this.popupConnector = popupConnector;
        this.popup = popupTexture;
    }

    protected int getPopupXOffset() {
        return 0;
    }

    protected int getPopupYOffset() {
        return 0;
    }

    protected int getConnectorXOffset() {
        return 0;
    }

    protected int getConnectorYOffset() {
        return 0;
    }

    protected boolean isPopupVisible() {
        return this.popupVisible && this.isEnabled();
    }

    protected boolean isEnabled() {
        return true;
    }

    private void updateRectsOffset() {
        this.mainRect.setPosition(this.getX(), this.getY());
        this.popupRect.setPosition(this.getX() + this.getPopupXOffset(), this.getY() + this.getPopupYOffset());
    }

    public void onPopupExit() {
    }

    public void onPopupEnter() {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int mX = (int)mouseX;
        int mY = (int)mouseY;
        if (this.isEnabled()) {
            if (this.popupRect.contains(mX, mY) && this.isPopupVisible()) {
                for (NewPopupElement popupElement : this.popupElements) {
                    popupElement.handleClick(mX, mY, button);
                }
            } else if (this.mainRect.contains(mX, mY)) {
                this.onMainButtonClick(button);
            }
            this.afterClick(button);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        int mX = (int)mouseX;
        int mY = (int)mouseY;
        if (this.isEnabled() && this.popupRect.contains(mX, mY) && this.isPopupVisible()) {
            for (NewPopupElement popupElement : this.popupElements) {
                popupElement.handleMouseScroll(mX, mY, scrollY);
            }
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    protected void onMainButtonClick(int button) {
    }

    protected void afterClick(int button) {
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        this.updateRectsOffset();
        if (this.mainRect.contains(mouseX, mouseY)) {
            if (!this.popupVisible) {
                this.onPopupEnter();
            }
            this.popupVisible = true;
        } else if (this.popupVisible && !this.popupRect.contains(mouseX, mouseY)) {
            this.onPopupExit();
            this.popupVisible = false;
        }
        this.renderIcon(graphics, mouseX, mouseY, partialTicks);
        if (this.isPopupVisible()) {
            this.renderPopup(graphics, mouseX, mouseY, partialTicks);
            for (NewPopupElement popupElement : this.popupElements) {
                popupElement.render(graphics, mouseX, mouseY, this.getX() + popupElement.getXOffset(), this.getY() + popupElement.getYOffset());
            }
        }
    }

    @Override
    protected void renderIcon(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
    }

    protected void renderPopup(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.blit(this.popupConnector.getLocation(), this.getX() + this.getConnectorXOffset(), this.getY() + this.getConnectorYOffset(), 0.0f, 0.0f, this.popupConnector.getRenderWidth(), this.popupConnector.getTextureHeight(), this.popupConnector.getRenderWidth(), this.popupConnector.getTextureHeight());
        graphics.blit(this.popup.getLocation(), this.getX() + this.getPopupXOffset(), this.getY() + this.getPopupYOffset(), 0.0f, 0.0f, this.popup.getRenderWidth(), this.popup.getTextureHeight(), this.popup.getRenderWidth(), this.popup.getTextureHeight());
    }
}

