/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.network;

import com.nine.travelerscompass.network.TCNetworkManager;
import com.nine.travelerscompass.network.packet.PacketHolder;
import com.nine.travelerscompass.network.packet.c2s.C2SPacket;
import com.nine.travelerscompass.network.packet.s2c.S2CPacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.Channel;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.SimpleChannel;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ForgeNetworkHandler {
    public static final ResourceLocation PROTOCOL_NAME = ResourceLocation.fromNamespaceAndPath((String)"travelerscompass", (String)"network_packets");
    public static final SimpleChannel CHANNEL = ChannelBuilder.named((ResourceLocation)PROTOCOL_NAME).networkProtocolVersion(4).optionalClient().optionalServer().clientAcceptedVersions(Channel.VersionTest.exact((int)4)).simpleChannel();

    public static void init() {
        TCNetworkManager.init();
        for (PacketHolder<? extends C2SPacket> packetHolder : TCNetworkManager.C2S_PACKETS) {
            ForgeNetworkHandler.registerC2S(packetHolder);
        }
        for (PacketHolder<Object> packetHolder : TCNetworkManager.S2C_PACKETS) {
            ForgeNetworkHandler.registerS2C(packetHolder);
        }
    }

    private static <T extends S2CPacket> void registerS2C(PacketHolder<T> holder) {
        CHANNEL.messageBuilder(holder.clazz()).encoder((msg, buf) -> holder.codec().encode((Object)new RegistryFriendlyByteBuf((ByteBuf)buf, ForgeNetworkHandler.getServerRegistryAccess()), msg)).decoder(buf -> (S2CPacket)holder.codec().decode((Object)new RegistryFriendlyByteBuf((ByteBuf)buf, ForgeNetworkHandler.getClientRegistryAccess()))).consumerMainThread(ForgeNetworkHandler::handle).add();
    }

    private static <T extends C2SPacket> void registerC2S(PacketHolder<T> holder) {
        CHANNEL.messageBuilder(holder.clazz()).encoder((msg, buf) -> holder.codec().encode((Object)new RegistryFriendlyByteBuf((ByteBuf)buf, ForgeNetworkHandler.getClientRegistryAccess()), msg)).decoder(buf -> (C2SPacket)holder.codec().decode((Object)new RegistryFriendlyByteBuf((ByteBuf)buf, ForgeNetworkHandler.getServerRegistryAccess()))).consumerMainThread(ForgeNetworkHandler::handle).add();
    }

    private static RegistryAccess getClientRegistryAccess() {
        Minecraft mc = Minecraft.getInstance();
        RegistryAccess registryAccess = null;
        if (mc.level != null) {
            registryAccess = mc.level.registryAccess();
        }
        return registryAccess;
    }

    private static RegistryAccess getServerRegistryAccess() {
        RegistryAccess.Frozen registryAccess = null;
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            registryAccess = server.registryAccess();
        }
        return registryAccess;
    }

    public static void handle(S2CPacket packet, CustomPayloadEvent.Context context) {
        context.enqueueWork(packet::handle);
        context.setPacketHandled(true);
    }

    public static void handle(C2SPacket packet, CustomPayloadEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            if (sender != null) {
                packet.handle(sender);
            }
        });
        context.setPacketHandled(true);
    }
}

