/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass;

import com.nine.travelerscompass.TCClient;
import com.nine.travelerscompass.TCCommon;
import com.nine.travelerscompass.client.screen.CompassScreen;
import com.nine.travelerscompass.common.data.CompassProperties;
import com.nine.travelerscompass.common.search.SearchManager;
import com.nine.travelerscompass.init.CreativeTabRegistry;
import com.nine.travelerscompass.init.ItemRegistry;
import com.nine.travelerscompass.init.MenuRegistry;
import com.nine.travelerscompass.init.PropertiesRegistry;
import com.nine.travelerscompass.network.ForgeNetworkHandler;
import com.nine.travelerscompass.platform.ForgePlatformConfigHelper;
import com.nine.travelerscompass.platform.ForgePlatformRegistryHelper;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="travelerscompass")
public class TCForge {
    public TCForge(FMLJavaModLoadingContext context) {
        this.loadConfig(context);
        IEventBus eventBus = context.getModEventBus();
        eventBus.addListener(this::setupNetwork);
        eventBus.addListener(this::setupClient);
        eventBus.addListener(this::commonSetup);
        eventBus.addListener(event -> TCCommon.updateCache());
        ItemRegistry.init();
        CompassProperties.init();
        CreativeTabRegistry.init();
        MenuRegistry.init();
        ForgePlatformRegistryHelper.ITEMS.register(eventBus);
        ForgePlatformRegistryHelper.DATA_COMPONENTS.register(eventBus);
        ForgePlatformRegistryHelper.TAB.register(eventBus);
        ForgePlatformRegistryHelper.MENUS.register(eventBus);
    }

    public void commonSetup(FMLCommonSetupEvent setupEvent) {
        TCCommon.updateCache();
        MinecraftForge.EVENT_BUS.addListener(event -> SearchManager.tick());
        MinecraftForge.EVENT_BUS.addListener(event -> {
            Player patt0$temp = event.getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                TCCommon.onServerPlayerLogin(player);
            }
        });
    }

    public void setupClient(FMLClientSetupEvent setupEvent) {
        MenuScreens.register((MenuType)((MenuType)MenuRegistry.COMPASS_MENU.get()), CompassScreen::new);
        PropertiesRegistry.init();
        MinecraftForge.EVENT_BUS.addListener(event -> TCClient.onClientPlayerLogout(event.getPlayer()));
    }

    public void loadConfig(FMLJavaModLoadingContext context) {
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ForgePlatformConfigHelper.COMMON_CONFIG, "travelerscompass-common.toml");
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ForgePlatformConfigHelper.COST_CONFIG, "travelerscompass-cost.toml");
    }

    private void setupNetwork(FMLCommonSetupEvent event) {
        ForgeNetworkHandler.init();
    }
}

