/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.utils;

import net.minecraft.network.chat.Component;

public class RangeUtils {
    public static final RangeAdapter<Integer> INTEGER = new IntegerAdapter();
    public static final RangeAdapter<Float> FLOAT = new FloatAdapter();

    public static <T extends Number> boolean changeValue(RangeButtonHandler<T> handler, boolean sub, boolean ctrlPressed) {
        return RangeUtils.changeValue(handler, sub, ctrlPressed, 1.0, 5.0);
    }

    public static <T extends Number> boolean changeValue(RangeButtonHandler<T> handler, boolean sub, boolean ctrlPressed, double step, double ctrlStep) {
        boolean changed;
        T current = handler.current();
        double change = (double)(sub ? -1 : 1) * (ctrlPressed ? ctrlStep : step);
        T added = handler.adapter().add(current, change);
        T balanced = handler.adapter().clamp(added, handler.min(), handler.max());
        boolean bl = changed = !balanced.equals(current);
        if (changed) {
            handler.set(balanced);
        }
        return changed;
    }

    public static <T extends Number> boolean isOutOfBounds(RangeButtonHandler<T> handler, T value) {
        double val = value.doubleValue();
        return val < ((Number)handler.min()).doubleValue() || val > ((Number)handler.max()).doubleValue();
    }

    public static interface RangeButtonHandler<T extends Number> {
        public T current();

        public void set(T var1);

        public T min();

        public T max();

        public RangeAdapter<T> adapter();
    }

    public static interface RangeAdapter<T extends Number> {
        public T add(T var1, double var2);

        default public T clamp(T value, T min, T max) {
            double v = ((Number)value).doubleValue();
            double minVal = ((Number)min).doubleValue();
            double maxVal = ((Number)max).doubleValue();
            if (v < minVal) {
                return min;
            }
            if (v > maxVal) {
                return max;
            }
            return value;
        }

        default public Component format(T value) {
            return Component.literal((String)String.valueOf(value));
        }
    }

    private static class IntegerAdapter
    implements RangeAdapter<Integer> {
        private IntegerAdapter() {
        }

        @Override
        public Integer add(Integer value, double delta) {
            return value + (int)delta;
        }
    }

    private static class FloatAdapter
    implements RangeAdapter<Float> {
        private FloatAdapter() {
        }

        @Override
        public Float add(Float value, double delta) {
            return Float.valueOf(value.floatValue() + (float)delta);
        }

        @Override
        public Component format(Float value) {
            return Component.literal((String)String.format("%.2f", value));
        }
    }
}

