/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass;

import com.nine.travelerscompass.TCClient;
import com.nine.travelerscompass.TCCommon;
import com.nine.travelerscompass.client.hud.HudRenderer;
import com.nine.travelerscompass.client.screen.CompassScreen;
import com.nine.travelerscompass.common.data.CompassComponents;
import com.nine.travelerscompass.common.search.SearchManager;
import com.nine.travelerscompass.init.CreativeTabRegistry;
import com.nine.travelerscompass.init.ItemPropertyRegistry;
import com.nine.travelerscompass.init.ItemRegistry;
import com.nine.travelerscompass.init.MenuRegistry;
import com.nine.travelerscompass.network.NeoForgeNetworkHandler;
import com.nine.travelerscompass.platform.NeoForgePlatformConfigHelper;
import com.nine.travelerscompass.platform.NeoForgePlatformRegistryHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;

@Mod(value="travelerscompass")
public class TCNeoForge {
    public TCNeoForge(IEventBus eventBus) {
        this.loadConfig(ModLoadingContext.get().getActiveContainer());
        eventBus.addListener(this::setupNetwork);
        eventBus.addListener(this::setupClientEvents);
        eventBus.addListener(this::setupScreen);
        eventBus.addListener(this::setupCommon);
        eventBus.addListener(this::creativeTabSetup);
        eventBus.addListener(this::imeSetup);
        this.setupProperties();
        ItemRegistry.init();
        CompassComponents.init();
        CreativeTabRegistry.init();
        MenuRegistry.init();
        NeoForgePlatformRegistryHelper.ITEMS.register(eventBus);
        NeoForgePlatformRegistryHelper.DATA_COMPONENTS.register(eventBus);
        NeoForgePlatformRegistryHelper.TAB.register(eventBus);
        NeoForgePlatformRegistryHelper.MENUS.register(eventBus);
    }

    private void creativeTabSetup(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.insertAfter(new ItemStack((ItemLike)Items.COMPASS), new ItemStack((ItemLike)ItemRegistry.TRAVELERS_COMPASS.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    public void loadConfig(ModContainer container) {
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)NeoForgePlatformConfigHelper.COMMON_CONFIG);
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)NeoForgePlatformConfigHelper.COST_CONFIG, "travelerscompass-cost.toml");
    }

    public void setupProperties() {
        if (FMLEnvironment.getDist().isClient()) {
            ItemPropertyRegistry.init();
        }
    }

    public void setupCommon(FMLCommonSetupEvent setupEvent) {
        setupEvent.enqueueWork(TCCommon::init);
        NeoForge.EVENT_BUS.addListener(event -> SearchManager.tick());
        NeoForge.EVENT_BUS.addListener(event -> {
            Player patt0$temp = event.getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                TCCommon.onServerPlayerLogin(player);
            }
        });
    }

    public void setupScreen(RegisterMenuScreensEvent event) {
        event.register((MenuType)MenuRegistry.COMPASS_MENU.get(), CompassScreen::new);
    }

    public void setupClientEvents(FMLClientSetupEvent setupEvent) {
        NeoForge.EVENT_BUS.addListener(event -> HudRenderer.renderTick(event.getGuiGraphics(), event.getPartialTick()));
        NeoForge.EVENT_BUS.addListener(event -> TCClient.onClientPlayerLogout(event.getPlayer()));
        NeoForge.EVENT_BUS.addListener(event -> HudRenderer.renderTick(event.getGuiGraphics(), event.getPartialTick()));
    }

    public void setupNetwork(RegisterPayloadHandlersEvent event) {
        NeoForgeNetworkHandler.init(event);
    }

    public void imeSetup(InterModEnqueueEvent event) {
    }
}

