/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button;

import com.nine.travelerscompass.client.CompassUI;
import com.nine.travelerscompass.client.component.button.base.BaseIconButton;
import com.nine.travelerscompass.client.component.button.settings.ButtonGenericSettings;
import com.nine.travelerscompass.client.utils.Icon;
import com.nine.travelerscompass.client.utils.TextureData;
import com.nine.travelerscompass.client.utils.TooltipBuilder;
import com.nine.travelerscompass.common.container.CompassContainer;
import com.nine.travelerscompass.common.data.CompassComponents;
import com.nine.travelerscompass.common.utils.SearchState;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class WarningButton
extends BaseIconButton {
    public boolean hidden = false;
    private Warning warning;

    public WarningButton(ButtonGenericSettings settings) {
        super(settings);
        this.refreshTooltip();
    }

    @Override
    protected TextureData getMainLayerTexture() {
        return CompassUI.TabTextures.WARNING_TAB;
    }

    @Override
    protected Icon getIcon() {
        return CompassUI.SettingsTextures.WARNING_SIGN_ICON;
    }

    public void updateState(ItemStack stack) {
        if (this.hidden) {
            return;
        }
        this.warning = CompassComponents.PAUSE.get(stack) != false && CompassComponents.SEARCH_STATE.get(stack) != SearchState.WIDE_SEARCHING ? Warning.PAUSED : (CompassContainer.container(stack).isEmpty() ? Warning.EMPTY : (CompassComponents.BLOCKS.get(stack) == false && CompassComponents.MOBS.get(stack) == false && CompassComponents.SPAWNERS.get(stack) == false && CompassComponents.INVENTORIES.get(stack) == false && CompassComponents.DROP.get(stack) == false && CompassComponents.VILLAGERS.get(stack) == false && CompassComponents.CONTAINERS.get(stack) == false && CompassComponents.FLUIDS.get(stack) == false && CompassComponents.ITEM_ENTITIES.get(stack) == false ? Warning.INACTIVE : Warning.NORMAL));
        this.refreshTooltip();
    }

    @Override
    public void tick() {
        this.refreshTooltip();
    }

    @Override
    public void refreshTooltip() {
        if (this.warning == Warning.NORMAL || this.hidden) {
            this.setTooltip(Tooltip.create((Component)Component.empty()));
            return;
        }
        String key = "tooltip.travelerscompass.warning." + this.warning.name().toLowerCase();
        this.setTooltip(TooltipBuilder.builder().title(key).desc(key).buildAsTooltip());
    }

    public static enum Warning {
        PAUSED,
        EMPTY,
        INACTIVE,
        NORMAL;

    }
}

