/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button.base;

import com.nine.travelerscompass.client.component.button.settings.ButtonGenericSettings;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;

public abstract class BaseButton
extends Button {
    protected boolean shiftPressed = false;
    protected boolean ctrlPressed = false;
    protected boolean hoverFlag = false;
    protected final Supplier<ItemStack> stackSupplier;
    private final Consumer<BaseButton> onLeftClick;
    private final Consumer<BaseButton> onRightClick;
    private final Consumer<BaseButton> afterInteraction;
    protected final UUID uuid;

    public BaseButton(ButtonGenericSettings settings) {
        super(settings.x, settings.y, settings.width, settings.height, (Component)Component.empty(), b -> {}, DEFAULT_NARRATION);
        this.stackSupplier = settings.supplier;
        this.onLeftClick = settings.afterLeftClick;
        this.onRightClick = settings.afterRightClick;
        this.afterInteraction = settings.afterInteraction;
        this.uuid = settings.uuid;
    }

    public ItemStack stack() {
        return this.stackSupplier.get();
    }

    public Supplier<ItemStack> stackSupplier() {
        return this.stackSupplier;
    }

    protected void onKeyModifierChanged() {
        this.refreshTooltip();
    }

    public void refreshTooltip() {
    }

    public void updateState() {
    }

    protected void onEnter() {
        this.updateState();
        this.refreshTooltip();
    }

    protected void onExit() {
    }

    public void tick() {
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (!(this.active && this.visible && this.isMouseOver(mouseX, mouseY))) {
            return false;
        }
        boolean handled = this.onMouseScroll(mouseX, mouseY, scrollX, scrollY);
        if (handled) {
            this.playMouseScrollSound(Minecraft.getInstance().getSoundManager(), scrollX, scrollY);
            this.updateState();
            this.refreshTooltip();
            if (this.afterInteraction != null) {
                this.afterInteraction.accept(this);
            }
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean bl) {
        double mouseX = event.x();
        double mouseY = event.y();
        if (!(this.active && this.visible && this.isMouseOver(mouseX, mouseY))) {
            return false;
        }
        boolean handled = false;
        if (event.button() == 0) {
            handled = this.onLeftClick(mouseX, mouseY);
            if (this.onLeftClick != null) {
                this.onLeftClick.accept(this);
                handled = true;
            }
        } else if (event.button() == 1) {
            handled = this.onRightClick(mouseX, mouseY);
            if (this.onRightClick != null) {
                this.onRightClick.accept(this);
                handled = true;
            }
        }
        if (handled) {
            this.playDownSound(Minecraft.getInstance().getSoundManager());
            this.updateState();
            this.refreshTooltip();
            if (this.afterInteraction != null) {
                this.afterInteraction.accept(this);
            }
            return true;
        }
        return false;
    }

    public void playMouseScrollSound(SoundManager soundManager, double scrollX, double scrollY) {
        soundManager.play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    }

    public boolean onMouseScroll(double mouseX, double mouseY, double scrollX, double scrollY) {
        return false;
    }

    public boolean onRightClick(double mouseX, double mouseY) {
        return false;
    }

    public boolean onLeftClick(double mouseX, double mouseY) {
        return false;
    }

    protected boolean isValidClickButton(MouseButtonInfo info) {
        return info.button() == 0 || info.button() == 1;
    }

    public final void onClick(MouseButtonEvent event, boolean bl) {
        this.onLeftClick(event.x(), event.y());
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        boolean shiftDown = Minecraft.getInstance().hasShiftDown();
        boolean ctrlDown = Minecraft.getInstance().hasControlDown();
        if (shiftDown != this.shiftPressed || ctrlDown != this.ctrlPressed) {
            this.ctrlPressed = ctrlDown;
            this.shiftPressed = shiftDown;
            this.onKeyModifierChanged();
        }
        if (this.isHovered()) {
            if (!this.hoverFlag) {
                this.hoverFlag = true;
                this.refreshTooltip();
                this.onEnter();
            }
        } else if (this.hoverFlag) {
            this.hoverFlag = false;
            this.onExit();
        }
    }
}

