/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button.hud;

import com.nine.travelerscompass.client.ClientCache;
import com.nine.travelerscompass.client.CompassUI;
import com.nine.travelerscompass.client.component.button.SettingsButton;
import com.nine.travelerscompass.client.component.button.hud.HudPosButton;
import com.nine.travelerscompass.client.component.button.hud.HudResetButton;
import com.nine.travelerscompass.client.component.button.hud.HudSizeButton;
import com.nine.travelerscompass.client.component.button.popup.PopupButton;
import com.nine.travelerscompass.client.component.button.range.FloatRangeButton;
import com.nine.travelerscompass.client.component.button.settings.ButtonGenericSettings;
import com.nine.travelerscompass.client.component.button.settings.ButtonRangeSettings;
import com.nine.travelerscompass.client.component.button.settings.ButtonSearchModeSettings;
import com.nine.travelerscompass.client.hud.Alignment;
import com.nine.travelerscompass.client.hud.HudRenderMode;
import com.nine.travelerscompass.client.hud.HudRenderer;
import com.nine.travelerscompass.client.hud.HudSize;
import com.nine.travelerscompass.client.hud.HudType;
import com.nine.travelerscompass.client.hud.anchor.HudAnchorX;
import com.nine.travelerscompass.client.hud.anchor.HudAnchorY;
import com.nine.travelerscompass.client.utils.ButtonGrid;
import com.nine.travelerscompass.client.utils.Icon;
import com.nine.travelerscompass.client.utils.TextureData;
import com.nine.travelerscompass.client.utils.TooltipBuilder;
import com.nine.travelerscompass.common.data.CompassComponents;
import com.nine.travelerscompass.config.TCConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class HudButton
extends PopupButton {
    private final boolean configEnabled = TCConfig.ENABLE_HUD.get();
    private HudRenderMode cached;

    public HudButton(ButtonGenericSettings settings) {
        super(settings, CompassUI.PopupTextures.POPUP_3X3.layer(-41, -13), CompassUI.PopupTextures.CONNECTOR_VERTICAL.layer(-1, 1));
        this.updateState();
        ButtonSearchModeSettings.Builder builder = (ButtonSearchModeSettings.Builder)((ButtonSearchModeSettings.Builder)((ButtonSearchModeSettings.Builder)((ButtonSearchModeSettings.Builder)((ButtonSearchModeSettings.Builder)ButtonSearchModeSettings.builder().position(this.getX(), this.getY())).size(10, 10)).uuid(this.uuid)).lockIcon(CompassUI.CommonTextures.SMALL_LOCK_ICON).mainLayerSet(CompassUI.ButtonTextures.SMALL_TOGGLE_BUTTON)).stackSup(this.stackSupplier());
        ButtonRangeSettings.Builder rangeBuilder = ButtonRangeSettings.builder(builder).minusIcons(CompassUI.CommonTextures.MINUS_SMALL_ICON, CompassUI.CommonTextures.MINUS_SMALL_HOVERED_ICON, CompassUI.CommonTextures.MINUS_SMALL_INACTIVE_ICON).plusIcons(CompassUI.CommonTextures.PLUS_SMALL_ICON, CompassUI.CommonTextures.PLUS_SMALL_HOVERED_ICON, CompassUI.CommonTextures.PLUS_SMALL_INACTIVE_ICON);
        ButtonGrid grid = new ButtonGrid(this.getX() - 37, this.getY() - 9, 10, 10, 1, 1);
        SettingsButton<Boolean> hudWithChatButton = SettingsButton.create(((ButtonSearchModeSettings.Builder)((ButtonSearchModeSettings.Builder)builder.copy().position(grid.x(1), grid.y(2))).afterInteraction(b -> ClientCache.updateHudSettings(this.uuid, modifier -> modifier.hudWithChat((Boolean)((SettingsButton)b).cached)))).build(), CompassComponents.HUD_WITH_CHAT, (cached, hovered) -> {
            if (cached.booleanValue()) {
                return hovered != false ? CompassUI.SettingsTextures.HUD_CHAT_ACTIVE_HOVERED_ICON : CompassUI.SettingsTextures.HUD_CHAT_ACTIVE_ICON;
            }
            return hovered != false ? CompassUI.SettingsTextures.HUD_CHAT_INACTIVE_HOVERED_ICON : CompassUI.SettingsTextures.HUD_CHAT_INACTIVE_ICON;
        });
        SettingsButton<Alignment> hudAlignmentButton = new SettingsButton<Alignment>(((ButtonSearchModeSettings.Builder)((ButtonSearchModeSettings.Builder)builder.copy().position(grid.x(2), grid.y(1))).afterInteraction(b -> {
            Alignment alignment = (Alignment)((Object)((Object)((SettingsButton)b).cached));
            ClientCache.updateHudSettings(this.uuid, modifier -> modifier.alignment(alignment));
        })).build(), CompassComponents.HUD_ALIGNMENT, (cached, hovered) -> switch (cached) {
            default -> throw new MatchException(null, null);
            case Alignment.LEFT -> {
                if (hovered.booleanValue()) {
                    yield CompassUI.SettingsTextures.HUD_ALIGNMENT_LEFT_HOVERED_ICON;
                }
                yield CompassUI.SettingsTextures.HUD_ALIGNMENT_LEFT_ICON;
            }
            case Alignment.CENTER -> {
                if (hovered.booleanValue()) {
                    yield CompassUI.SettingsTextures.HUD_ALIGNMENT_CENTER_HOVERED_ICON;
                }
                yield CompassUI.SettingsTextures.HUD_ALIGNMENT_CENTER_ICON;
            }
            case Alignment.RIGHT -> hovered != false ? CompassUI.SettingsTextures.HUD_ALIGNMENT_RIGHT_HOVERED_ICON : CompassUI.SettingsTextures.HUD_ALIGNMENT_RIGHT_ICON;
        }, cached -> Component.translatable((String)("tooltip.travelerscompass.settings.hud_alignment." + cached.name().toLowerCase())).withStyle(ChatFormatting.GRAY));
        HudPosButton xHudPosButton = new HudPosButton(((ButtonRangeSettings.Builder)((ButtonRangeSettings.Builder)rangeBuilder.copy().position(grid.x(0), grid.y(0))).icon(CompassUI.SettingsTextures.HUD_X_POS_ICON).afterInteraction(b -> {
            ClientCache.updateHudSettings(this.uuid, modifier -> modifier.xPos((Integer)((HudPosButton)b).cached));
            ClientCache.updateHudSettings(this.uuid, modifier -> modifier.anchorX((HudAnchorX)((HudPosButton)b).cachedAnchor));
        })).build(), 0, Minecraft.getInstance().getWindow().getGuiScaledWidth(), (Component)Component.literal((String)"X").withColor(0xC8C8C8), CompassComponents.HUD_X_ANCHOR, CompassComponents.HUD_X_POS);
        HudPosButton yHudPosButton = new HudPosButton(((ButtonRangeSettings.Builder)((ButtonRangeSettings.Builder)rangeBuilder.copy().position(grid.x(1), grid.y(0))).icon(CompassUI.SettingsTextures.HUD_Y_POS_ICON).afterInteraction(b -> {
            ClientCache.updateHudSettings(this.uuid, modifier -> modifier.yPos((Integer)((HudPosButton)b).cached));
            ClientCache.updateHudSettings(this.uuid, modifier -> modifier.anchorY((HudAnchorY)((HudPosButton)b).cachedAnchor));
        })).build(), 0, Minecraft.getInstance().getWindow().getGuiScaledHeight(), (Component)Component.literal((String)"Y").withColor(0xC8C8C8), CompassComponents.HUD_Y_ANCHOR, CompassComponents.HUD_Y_POS);
        HudSizeButton hudWidthButton = new HudSizeButton(((ButtonRangeSettings.Builder)((ButtonRangeSettings.Builder)rangeBuilder.copy().position(grid.x(0), grid.y(1))).icon(CompassUI.SettingsTextures.HUD_WIDTH_ICON).afterInteraction(b -> ClientCache.updateHudSettings(this.uuid, modifier -> modifier.width((Integer)((HudSizeButton)b).cached)))).build(), true);
        HudSizeButton hudHeightButton = new HudSizeButton(((ButtonRangeSettings.Builder)((ButtonRangeSettings.Builder)rangeBuilder.copy().position(grid.x(1), grid.y(1))).icon(CompassUI.SettingsTextures.HUD_HEIGHT_ICON).afterInteraction(b -> ClientCache.updateHudSettings(this.uuid, modifier -> modifier.height((Integer)((HudSizeButton)b).cached)))).build(), false);
        FloatRangeButton scaleRangeButton = new FloatRangeButton(((ButtonRangeSettings.Builder)((ButtonRangeSettings.Builder)rangeBuilder.copy().position(grid.x(0), grid.y(2))).icon(CompassUI.SettingsTextures.HUD_SCALE_ICON).afterInteraction(b -> ClientCache.updateHudSettings(this.uuid, modifier -> modifier.scale(((Float)((FloatRangeButton)b).cached).floatValue())))).build(), Float.valueOf(0.1f), Float.valueOf(3.0f), Float.valueOf(0.01f), Float.valueOf(0.1f), CompassComponents.HUD_SCALE);
        SettingsButton<HudType> hudTypeButton = new SettingsButton<HudType>(((ButtonSearchModeSettings.Builder)((ButtonSearchModeSettings.Builder)builder.copy().position(grid.x(2), grid.y(0))).afterInteraction(b -> {
            HudType type = (HudType)((Object)((Object)((SettingsButton)b).cached));
            HudSize size = CompassComponents.HUD_SIZE.get(this.stack());
            ClientCache.updateHudSettings(this.uuid, modifier -> modifier.hudType(type));
            ClientCache.updateHudSettings(this.uuid, modifier -> modifier.width(size.getWidth(type)));
            ClientCache.updateHudSettings(this.uuid, modifier -> modifier.height(size.getHeight(type)));
        })).build(), CompassComponents.HUD_TYPE, (cached, hovered) -> switch (cached) {
            default -> throw new MatchException(null, null);
            case HudType.COMPACT -> {
                if (hovered.booleanValue()) {
                    yield CompassUI.SettingsTextures.HUD_TYPE_COMPACT_HOVERED_ICON;
                }
                yield CompassUI.SettingsTextures.HUD_TYPE_COMPACT_ICON;
            }
            case HudType.EXTENDED -> hovered != false ? CompassUI.SettingsTextures.HUD_TYPE_EXTENDED_HOVERED_ICON : CompassUI.SettingsTextures.HUD_TYPE_EXTENDED_ICON;
        }, cached -> switch (cached) {
            default -> throw new MatchException(null, null);
            case HudType.COMPACT -> Component.translatable((String)"tooltip.travelerscompass.settings.hud_type.compact").withStyle(ChatFormatting.GRAY);
            case HudType.EXTENDED -> Component.translatable((String)"tooltip.travelerscompass.settings.hud_type.extended").withStyle(ChatFormatting.GRAY);
        });
        HudResetButton resetButton = new HudResetButton(((ButtonSearchModeSettings.Builder)((ButtonSearchModeSettings.Builder)builder.copy().position(grid.x(2), grid.y(2))).afterLeftClick(button -> {
            HudButton.resetHudSettings(this.stack());
            this.updatePopupButtons();
            ClientCache.updateAllHudSettings(this.stack(), true);
        })).build());
        this.popupButtons.add(xHudPosButton);
        this.popupButtons.add(yHudPosButton);
        this.popupButtons.add(hudWidthButton);
        this.popupButtons.add(hudWithChatButton);
        this.popupButtons.add(hudHeightButton);
        this.popupButtons.add(scaleRangeButton);
        this.popupButtons.add(hudTypeButton);
        this.popupButtons.add(hudAlignmentButton);
        this.popupButtons.add(resetButton);
    }

    public static void resetHudSettings(ItemStack stack) {
        CompassComponents.putDefaultToServer(stack, CompassComponents.HUD_X_POS);
        CompassComponents.putDefaultToServer(stack, CompassComponents.HUD_Y_POS);
        CompassComponents.putDefaultToServer(stack, CompassComponents.HUD_SIZE);
        CompassComponents.putDefaultToServer(stack, CompassComponents.HUD_SCALE);
        CompassComponents.putDefaultToServer(stack, CompassComponents.HUD_TYPE);
        CompassComponents.putDefaultToServer(stack, CompassComponents.HUD_ALIGNMENT);
        CompassComponents.putDefaultToServer(stack, CompassComponents.HUD_WITH_CHAT);
        CompassComponents.putDefaultToServer(stack, CompassComponents.HUD_Y_ANCHOR);
        CompassComponents.putDefaultToServer(stack, CompassComponents.HUD_X_ANCHOR);
    }

    @Override
    public void updateState() {
        this.cached = CompassComponents.HUD_RENDER_MODE.get(this.stack());
        this.refreshTooltip();
        ClientCache.updateHudSettings(this.uuid, modifier -> modifier.renderMode(this.cached));
    }

    @Override
    public boolean onLeftClick(double mouseX, double mouseY) {
        CompassComponents.toggleToServer(this.stack(), CompassComponents.HUD_RENDER_MODE, true);
        return true;
    }

    @Override
    public void afterPopupClick() {
        this.refreshTooltip();
    }

    @Override
    protected TextureData getMainLayerTexture() {
        return this.buttonTexturesSet().get(false, this.isHovered, this.configEnabled);
    }

    @Override
    protected Icon getIcon() {
        Icon iconTexture;
        if (this.configEnabled) {
            iconTexture = switch (this.cached) {
                default -> throw new MatchException(null, null);
                case HudRenderMode.OFF -> {
                    if (this.isHovered) {
                        yield CompassUI.SettingsTextures.HUD_OFF_HOVERED_ICON;
                    }
                    yield CompassUI.SettingsTextures.HUD_OFF_ICON;
                }
                case HudRenderMode.ALWAYS -> {
                    if (this.isHovered) {
                        yield CompassUI.SettingsTextures.HUD_ALWAYS_HOVERED_ICON;
                    }
                    yield CompassUI.SettingsTextures.HUD_ALWAYS_ICON;
                }
                case HudRenderMode.HAND_ONLY -> this.isHovered ? CompassUI.SettingsTextures.HUD_HAND_HOVERED_ICON : CompassUI.SettingsTextures.HUD_HAND_ICON;
            };
        } else {
            iconTexture = CompassUI.CommonTextures.LOCK_ICON;
        }
        return iconTexture;
    }

    @Override
    public boolean isPopupVisible() {
        return super.isPopupVisible() && this.configEnabled && this.cached != HudRenderMode.OFF;
    }

    @Override
    protected void renderIcon(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderIcon(graphics, mouseX, mouseY, partialTicks);
        if (this.isPopupVisible()) {
            HudRenderer.forceRender(graphics, partialTicks, this.uuid);
        }
    }

    @Override
    public void refreshTooltip() {
        Component state;
        TooltipBuilder builder = TooltipBuilder.builder();
        String key = "tooltip.travelerscompass.settings.hud";
        builder.state(key);
        if (this.configEnabled) {
            switch (this.cached) {
                default: {
                    throw new MatchException(null, null);
                }
                case OFF: {
                    Component component = CompassUI.DISABLED;
                    break;
                }
                case HAND_ONLY: {
                    Component component = CompassUI.HUD_REQUIRES_HAND;
                    break;
                }
                case ALWAYS: {
                    Component component = state = CompassUI.HUD_ENABLED;
                }
            }
            if (this.shiftPressed) {
                builder.desc(key + ".desc");
            }
        } else {
            state = CompassUI.CONFIG_DISABLED;
        }
        builder.state(state);
        this.setTooltip(builder.buildAsTooltip());
    }
}

