/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button.popup;

import com.nine.travelerscompass.client.component.button.base.BaseButton;
import com.nine.travelerscompass.client.component.button.base.BaseIconButton;
import com.nine.travelerscompass.client.component.button.settings.ButtonGenericSettings;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.client.utils.IconLayer;
import com.nine.travelerscompass.client.utils.TextureData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.Rect2i;

public abstract class PopupButton
extends BaseIconButton {
    protected final IconLayer popupLayer;
    protected final IconLayer connectorLayer;
    protected final Rect2i popupRect;
    private boolean popupVisible = false;
    public List<BaseButton> popupButtons = new ArrayList<BaseButton>();
    private static final int POPUP_PADDING = 1;

    protected PopupButton(ButtonGenericSettings settings, IconLayer popupLayer, IconLayer connectorLayer) {
        super(settings);
        this.popupLayer = popupLayer;
        this.connectorLayer = connectorLayer;
        this.popupRect = this.calculatePopupRect(this.popupLayer);
    }

    protected Rect2i calculatePopupRect(IconLayer popupTexture) {
        TextureData textureData = popupTexture.textureData();
        int x = (int)((float)this.getX() + popupTexture.xOffset() - 1.0f);
        int y = (int)((float)this.getY() + popupTexture.yOffset() - 1.0f);
        int width = textureData.width() + 1;
        int height = textureData.height() + 1;
        return new Rect2i(x, y, width, height);
    }

    public boolean isPopupVisible() {
        return this.popupVisible;
    }

    public void onPopupClosed() {
    }

    public void onPopupOpened() {
    }

    public void popupMouseClicked(MouseButtonEvent event, boolean bl) {
        if (this.isPopupVisible() && this.popupRect.contains((int)event.x(), (int)event.y())) {
            for (BaseButton popupElement : this.popupButtons) {
                popupElement.mouseClicked(event, bl);
            }
        }
    }

    public void updatePopupButtons() {
        for (BaseButton b : this.popupButtons) {
            b.updateState();
        }
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        int mX = (int)mouseX;
        int mY = (int)mouseY;
        if (this.isPopupVisible() && this.popupRect.contains(mX, mY)) {
            for (BaseButton popupElement : this.popupButtons) {
                popupElement.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
            }
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public void afterPopupClick() {
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        if (this.isHovered) {
            if (!this.popupVisible) {
                this.onPopupOpened();
            }
            this.popupVisible = true;
        } else if (this.popupVisible && !this.popupRect.contains(mouseX, mouseY)) {
            this.onPopupClosed();
            this.popupVisible = false;
        }
        if (this.isPopupVisible()) {
            this.renderPopup(graphics, mouseX, mouseY, partialTicks);
            for (BaseButton button : this.popupButtons) {
                button.render(graphics, mouseX, mouseY, partialTicks);
            }
        }
    }

    protected void renderPopup(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        ClientUtils.renderIconLayer(graphics, this.popupLayer, this.getX(), this.getY());
        ClientUtils.renderIconLayer(graphics, this.connectorLayer, this.getX(), this.getY());
    }
}

