/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button.range;

import com.nine.travelerscompass.client.component.button.base.BaseIconButton;
import com.nine.travelerscompass.client.component.button.settings.ButtonRangeSettings;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.client.utils.Icon;
import com.nine.travelerscompass.client.utils.RangeIconVariants;
import com.nine.travelerscompass.client.utils.TextureData;
import com.nine.travelerscompass.client.utils.TooltipBuilder;
import com.nine.travelerscompass.common.data.DataStorage;
import java.util.Objects;
import java.util.function.DoubleFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class RangeButton<T extends Number>
extends BaseIconButton {
    public T cached;
    protected boolean outOfBounds = false;
    private final Icon icon;
    private final RangeIconVariants plusIcons;
    private final RangeIconVariants minusIcons;
    protected final DataStorage<T> data;
    private final T min;
    private final T max;
    private final T step;
    private final T ctrlStep;
    private final DoubleFunction<T> fromDouble;

    public RangeButton(ButtonRangeSettings settings, T minValue, T maxValue, T step, T ctrlStep, DoubleFunction<T> fromDouble, DataStorage<T> data) {
        super(settings);
        this.data = data;
        this.fromDouble = fromDouble;
        this.min = minValue;
        this.max = maxValue;
        this.step = step;
        this.ctrlStep = ctrlStep;
        this.icon = settings.icon;
        this.plusIcons = settings.plusIcons;
        this.minusIcons = settings.minusIcons;
        this.updateState();
    }

    protected T min() {
        return this.min;
    }

    protected T max() {
        return this.max;
    }

    protected boolean set(T value) {
        if (!Objects.equals(this.cached, value = this.clamp(value))) {
            this.onValueChanged(this.cached, value);
            return true;
        }
        return false;
    }

    protected void onValueChanged(T oldValue, T newValue) {
        this.data.syncToServer(this.stack(), newValue);
    }

    public final boolean isOutOfBounds(double v) {
        return Double.isNaN(v) || v < ((Number)this.min()).doubleValue() || v > ((Number)this.max()).doubleValue();
    }

    private T clamp(T value) {
        double v = ((Number)value).doubleValue();
        double minVal = ((Number)this.min()).doubleValue();
        double maxVal = ((Number)this.max()).doubleValue();
        if (v < minVal) {
            return this.min();
        }
        if (v > maxVal) {
            return this.max();
        }
        return value;
    }

    protected Component holdToDecreaseComponent() {
        MutableComponent shift = ClientUtils.coloredComponent(Component.translatable((String)"tooltip.travelerscompass.settings.modification.shift"), this.shiftPressed ? 0xAAAAAA : 0xC8C8C8);
        return Component.translatable((String)"tooltip.travelerscompass.settings.modification.hold_to_decrease", (Object[])new Object[]{shift}).withStyle(ChatFormatting.GRAY);
    }

    protected Component holdToChangeFaster() {
        MutableComponent ctrl = ClientUtils.coloredComponent(Component.translatable((String)"tooltip.travelerscompass.settings.modification.ctrl"), this.ctrlPressed ? 0xAAAAAA : 0xC8C8C8);
        return Component.translatable((String)"tooltip.travelerscompass.settings.modification.hold_to_change_faster", (Object[])new Object[]{ctrl}).withStyle(ChatFormatting.GRAY);
    }

    public void updateCache() {
        this.cached = (Number)this.data.get(this.stack());
    }

    @Override
    protected void onKeyModifierChanged() {
        super.onKeyModifierChanged();
        this.updateState();
    }

    @Override
    public void updateState() {
        this.updateCache();
        this.outOfBounds = this.isOutOfBounds(((Number)this.cached).doubleValue() + (double)(this.shiftPressed ? -1 : 1) * ((Number)(this.ctrlPressed ? this.ctrlStep : this.step)).doubleValue());
    }

    @Override
    public boolean onMouseScroll(double mouseX, double mouseY, double scrollX, double scrollY) {
        return this.set((Number)this.fromDouble.apply(((Number)this.cached).doubleValue() + (double)(scrollY < 0.0 ? -1 : 1) * ((Number)(this.ctrlPressed ? this.ctrlStep : this.step)).doubleValue()));
    }

    @Override
    public boolean onLeftClick(double mouseX, double mouseY) {
        return this.set((Number)this.fromDouble.apply(((Number)this.cached).doubleValue() + (double)(this.shiftPressed ? -1 : 1) * ((Number)(this.ctrlPressed ? this.ctrlStep : this.step)).doubleValue()));
    }

    @Override
    public void playMouseScrollSound(SoundManager soundManager, double scrollX, double scrollY) {
        soundManager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value()), (float)1.05f, (float)0.12f));
    }

    @Override
    protected TextureData getMainLayerTexture() {
        return this.buttonTexturesSet().get(false, this.isHovered, !this.outOfBounds || !this.isHovered);
    }

    @Override
    protected Icon getIcon() {
        Icon ret = this.isHovered ? (this.shiftPressed ? this.minusIcons.get(this.ctrlPressed, !this.outOfBounds) : this.plusIcons.get(this.ctrlPressed, !this.outOfBounds)) : this.icon;
        return ret;
    }

    public String cachedAsString() {
        return String.valueOf(this.cached);
    }

    @Override
    public void refreshTooltip() {
        TooltipBuilder builder = TooltipBuilder.builder();
        String key = "tooltip.travelerscompass.settings." + this.data.id();
        builder.title(key);
        builder.line(this.holdToDecreaseComponent());
        builder.line(this.holdToChangeFaster());
        builder.descIf(key, this.shiftPressed);
        MutableComponent value = Component.literal((String)String.valueOf(this.cachedAsString())).withColor(0xC8C8C8);
        builder.state((Component)Component.translatable((String)(key + ".value"), (Object[])new Object[]{value}).withStyle(ChatFormatting.GRAY));
        this.setTooltip(builder.buildAsTooltip());
    }
}

