/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.component.button.search;

import com.nine.travelerscompass.client.CompassUI;
import com.nine.travelerscompass.client.component.button.base.ToggleableButton;
import com.nine.travelerscompass.client.component.button.settings.ButtonSearchModeSettings;
import com.nine.travelerscompass.client.utils.Icon;
import com.nine.travelerscompass.client.utils.TextureData;
import com.nine.travelerscompass.client.utils.TooltipBuilder;
import com.nine.travelerscompass.common.data.CompassComponents;
import com.nine.travelerscompass.common.data.DataStorage;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public class SearchModeButton
extends ToggleableButton {
    private final DataStorage<Boolean> data;
    protected final Icon iconInactive;
    protected final Icon iconActive;
    protected final Icon iconLock;
    private final boolean configEnabled;
    private final List<Component> descriptions;

    public SearchModeButton(ButtonSearchModeSettings settings) {
        super(settings);
        this.data = settings.data;
        this.iconActive = settings.iconActive;
        this.iconInactive = settings.iconInactive;
        this.iconLock = settings.iconLock;
        this.configEnabled = settings.configEnabled;
        this.descriptions = settings.descriptions;
        this.active = this.configEnabled;
        this.setToggled(this.data.get(this.stack()));
        this.refreshTooltip();
    }

    @Override
    public boolean onLeftClick(double mouseX, double mouseY) {
        CompassComponents.toggleToServer(this.stack(), this.data, true);
        this.setToggled(this.data.get(this.stack()));
        this.refreshTooltip();
        return true;
    }

    @Override
    protected TextureData getMainLayerTexture() {
        return this.buttonTexturesSet().get(this.toggled, this.isHovered, this.configEnabled);
    }

    @Override
    protected Icon getIcon() {
        return this.configEnabled ? (this.toggled ? this.iconActive : this.iconInactive) : this.iconLock;
    }

    @Override
    public void refreshTooltip() {
        String key = "tooltip.travelerscompass.search_mode." + this.data.id();
        TooltipBuilder builder = TooltipBuilder.builder().title(key);
        if (this.configEnabled && this.shiftPressed) {
            if (this.descriptions != null && !this.descriptions.isEmpty()) {
                this.descriptions.forEach(builder::desc);
            } else {
                builder.desc((Component)Component.translatable((String)(key + ".desc")).withStyle(ChatFormatting.GRAY));
            }
        }
        builder.state(this.configEnabled ? (this.isToggled() ? CompassUI.ENABLED : CompassUI.DISABLED) : CompassUI.CONFIG_DISABLED);
        this.setTooltip(builder.buildAsTooltip());
    }
}

