/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.hud;

import com.nine.travelerscompass.client.ClientCache;
import com.nine.travelerscompass.client.hud.HudData;
import com.nine.travelerscompass.client.hud.HudRenderMode;
import com.nine.travelerscompass.client.hud.HudSettings;
import com.nine.travelerscompass.client.hud.anchor.HudAnchorX;
import com.nine.travelerscompass.client.hud.anchor.HudAnchorY;
import com.nine.travelerscompass.client.hud.type.IHudTypeRenderer;
import com.nine.travelerscompass.common.data.CompassComponents;
import com.nine.travelerscompass.config.TCConfig;
import com.nine.travelerscompass.init.ItemRegistry;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class HudRenderer {
    public static final ResourceLocation EDGES_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"travelerscompass", (String)"textures/gui/hud_edges.png");
    private static final int EDGE_PADDING = 7;
    private static final int HEIGHT_PADDING = 2;
    private static final int WIDTH_PADDING = 2;
    static final Minecraft minecraft = Minecraft.getInstance();
    private static int renderTicksCount = 0;

    public static void renderTick(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        HudRenderer.renderTick(guiGraphics, deltaTracker.getGameTimeDeltaPartialTick(false));
    }

    public static void renderTick(GuiGraphics graphics, float partialTicks) {
        LocalPlayer player = HudRenderer.minecraft.player;
        if (player != null) {
            if (player.tickCount % 100 == 0) {
                HashSet<UUID> validUUIDs = new HashSet<UUID>();
                for (ItemStack stack : player.getInventory().getNonEquipmentItems()) {
                    if (!stack.is((Item)ItemRegistry.TRAVELERS_COMPASS.get())) continue;
                    UUID uuid2 = CompassComponents.get(stack, CompassComponents.COMPASS_UUID);
                    validUUIDs.add(uuid2);
                }
                ClientCache.HUD_DATA_CACHE.keySet().removeIf(uuid -> !validUUIDs.contains(uuid));
            }
            if (!HudRenderer.shouldShow()) {
                return;
            }
            for (HudData hudData : ClientCache.HUD_DATA_CACHE.values()) {
                HudSettings settings = hudData.getSettings();
                if (settings.renderMode() == HudRenderMode.OFF || settings.renderMode() == HudRenderMode.HAND_ONLY && !hudData.isSelected() || HudRenderer.minecraft.screen instanceof ChatScreen && !settings.hudWithChat() || HudRenderer.minecraft.screen != null && !(HudRenderer.minecraft.screen instanceof ChatScreen)) continue;
                HudRenderer.renderHud(graphics, hudData, false, partialTicks);
            }
        }
        if (player != null && renderTicksCount % 3000 == 0) {
            renderTicksCount = 0;
        }
    }

    public static void forceRender(GuiGraphics graphics, float partialTicks, UUID uuid) {
        if (ClientCache.HUD_DATA_CACHE.containsKey(uuid)) {
            HudRenderer.renderHud(graphics, ClientCache.HUD_DATA_CACHE.get(uuid), true, partialTicks);
        }
    }

    private static void renderHud(GuiGraphics graphics, HudData hudData, boolean drawEdges, float partialTicks) {
        float off;
        HudSettings settings = hudData.getSettings();
        IHudTypeRenderer renderer = settings.hudType().renderer;
        int scaledScreenWidth = minecraft.getWindow().getGuiScaledWidth();
        int scaledScreenHeight = minecraft.getWindow().getGuiScaledHeight();
        int x = Math.min(settings.xPos(), scaledScreenWidth);
        int y = Math.min(settings.yPos(), scaledScreenHeight);
        int width = Math.min(scaledScreenWidth, settings.width());
        int height = Math.min(scaledScreenHeight, settings.height());
        graphics.pose().pushMatrix();
        if (settings.anchorX() == HudAnchorX.RIGHT) {
            x = scaledScreenWidth - width - x;
            off = (float)width - (float)width * settings.scale();
            graphics.pose().translate(off, 0.0f);
        }
        if (settings.anchorY() == HudAnchorY.BOTTOM) {
            y = scaledScreenHeight - height - y;
            off = (float)height - (float)height * settings.scale();
            graphics.pose().translate(0.0f, off);
        }
        graphics.pose().translate((float)x, (float)y);
        graphics.pose().scale(settings.scale());
        renderer.render(graphics, (Player)HudRenderer.minecraft.player, HudRenderer.minecraft.font, hudData, 2, 2, width - 2, height - 2);
        if (drawEdges) {
            HudRenderer.drawEdges(graphics, 0, 0, width, height, partialTicks);
        }
        graphics.pose().popMatrix();
    }

    private static boolean shouldShow() {
        return TCConfig.ENABLE_HUD.get() != false && HudRenderer.minecraft.level != null && !HudRenderer.minecraft.options.hideGui;
    }

    protected static void drawEdges(GuiGraphics graphics, int xPos, int yPos, int width, int height, float partialTicks) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        float pulse = 0.8f + 0.2f * Mth.sin((float)((partialTicks + (float)player.tickCount) * 0.1f));
        int padding = 7;
        int opacity = ARGB.white((float)pulse);
        graphics.blit(RenderPipelines.GUI_TEXTURED, EDGES_TEXTURE, xPos, yPos, 0.0f, 0.0f, 7, 7, 14, 14, opacity);
        graphics.blit(RenderPipelines.GUI_TEXTURED, EDGES_TEXTURE, xPos + width - 7, yPos, 7.0f, 0.0f, 7, 7, 14, 14, opacity);
        graphics.blit(RenderPipelines.GUI_TEXTURED, EDGES_TEXTURE, xPos, yPos + height - 7, 0.0f, 7.0f, 7, 7, 14, 14, opacity);
        graphics.blit(RenderPipelines.GUI_TEXTURED, EDGES_TEXTURE, xPos + width - 7, yPos + height - 7, 7.0f, 7.0f, 7, 7, 14, 14, opacity);
    }
}

