/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.hud.type;

import com.nine.travelerscompass.client.hud.Alignment;
import com.nine.travelerscompass.client.hud.HudData;
import com.nine.travelerscompass.client.hud.HudSettings;
import com.nine.travelerscompass.client.hud.type.IHudTypeRenderer;
import com.nine.travelerscompass.client.utils.ClientUtils;
import com.nine.travelerscompass.common.search.location.ILocationObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class CompactHudTypeRenderer
implements IHudTypeRenderer {
    public static final int MAX_LINES = 4;

    @Override
    public void render(GuiGraphics graphics, Player player, Font font, HudData hudData, int x, int y, int width, int height) {
        if (hudData.isDirty()) {
            int prefixWidth = font.width((FormattedText)Component.translatable((String)"hud.travelerscompass.compact.target", (Object[])new Object[]{""}));
            hudData.updateCachedData(font, prefixWidth);
            hudData.clearDirty();
        }
        HudSettings settings = hudData.getSettings();
        int xPos = x;
        int yPos = y;
        ILocationObject locationObject = hudData.getLocationObject();
        boolean valid = locationObject != null;
        ArrayList<Component> components = new ArrayList<Component>();
        MutableComponent state = Component.translatable((String)"hud.travelerscompass.compact.state", (Object[])new Object[]{hudData.getState()}).withStyle(ChatFormatting.WHITE);
        components.add((Component)state);
        if (valid) {
            MutableComponent finalName = Component.translatable((String)"hud.travelerscompass.compact.target", (Object[])new Object[]{hudData.getTargetName()}).withStyle(ChatFormatting.WHITE);
            components.add((Component)finalName);
            BlockPos blockPos = locationObject.blockPos();
            if (blockPos != null) {
                Component position = CompactHudTypeRenderer.formatCoordsCompact(blockPos, font, width);
                MutableComponent distance = Component.translatable((String)"hud.travelerscompass.compact.distance", (Object[])new Object[]{ClientUtils.getDistance(player.blockPosition(), blockPos)}).withStyle(ChatFormatting.WHITE);
                components.add(position);
                components.add((Component)distance);
            }
        }
        CompactHudTypeRenderer.drawCompactLines(graphics, font, xPos, yPos, width, height, settings.alignment(), 4, components);
    }

    public static void drawCompactLines(GuiGraphics graphics, Font font, int xPos, int yPos, int width, int height, Alignment alignment, int maxLines, List<Component> components) {
        if (components.isEmpty()) {
            return;
        }
        Objects.requireNonNull(font);
        int linesHeight = maxLines * 9;
        int gap = components.size() > 1 ? (height - linesHeight) / (maxLines - 1) : 0;
        int currentY = yPos;
        for (Component component : components) {
            int currentX = xPos;
            switch (alignment) {
                case LEFT: {
                    break;
                }
                case RIGHT: {
                    currentX += width - font.width((FormattedText)component);
                    break;
                }
                case CENTER: {
                    currentX += (width - font.width((FormattedText)component)) / 2;
                }
            }
            graphics.drawString(font, component, currentX, currentY, -5592406);
            Objects.requireNonNull(font);
            currentY += 9 + gap;
        }
    }

    public static Component formatCoordsCompact(BlockPos pos, Font font, int maxWidth) {
        MutableComponent coords = Component.literal((String)(pos.getX() + ", " + pos.getY() + ", " + pos.getZ())).withStyle(ChatFormatting.GRAY);
        MutableComponent full = Component.translatable((String)"hud.travelerscompass.compact.position", (Object[])new Object[]{coords}).withStyle(ChatFormatting.WHITE);
        if (font.width((FormattedText)full) <= maxWidth) {
            return full;
        }
        coords = Component.literal((String)(pos.getX() + ", " + pos.getZ())).withStyle(ChatFormatting.GRAY);
        full = Component.translatable((String)"hud.travelerscompass.compact.position", (Object[])new Object[]{coords}).withStyle(ChatFormatting.WHITE);
        if (font.width((FormattedText)full) <= maxWidth) {
            return full;
        }
        coords = Component.literal((String)(pos.getX() + ", " + pos.getZ())).withStyle(ChatFormatting.GRAY);
        full = Component.translatable((String)"hud.travelerscompass.compact.position_short", (Object[])new Object[]{coords}).withStyle(ChatFormatting.WHITE);
        if (font.width((FormattedText)full) <= maxWidth) {
            return full;
        }
        coords = Component.literal((String)(ClientUtils.compressNumber(pos.getX()) + ", " + ClientUtils.compressNumber(pos.getZ()))).withStyle(ChatFormatting.GRAY);
        full = Component.translatable((String)"hud.travelerscompass.compact.position_short", (Object[])new Object[]{coords}).withStyle(ChatFormatting.WHITE);
        if (font.width((FormattedText)full) <= maxWidth) {
            return full;
        }
        return Component.translatable((String)"hud.travelerscompass.compact.position_short", (Object[])new Object[]{Component.literal((String)"...").withStyle(ChatFormatting.GRAY)}).withStyle(ChatFormatting.WHITE);
    }
}

