/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.render.item;

import com.nine.travelerscompass.common.data.CompassComponents;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.properties.numeric.NeedleDirectionHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class TravelersCompassAngleState
extends NeedleDirectionHelper {
    private final RandomSource random = RandomSource.create();
    private final NeedleDirectionHelper.Wobbler noTargetWobbler = this.newWobbler(0.8f);
    private final NeedleDirectionHelper.Wobbler wobbler = this.newWobbler(0.8f);

    public TravelersCompassAngleState() {
        super(true);
    }

    protected float calculate(ItemStack stack, ClientLevel level, int seed, ItemOwner owner) {
        BlockPos pos = CompassComponents.FOUND_BLOCK_POS.get(stack).blockPos();
        long time = level.getGameTime();
        return !this.isValidCompassTargetPos(pos) ? this.getRandomlySpinningRotation(seed, time) : this.getRotationTowardsCompassTarget(seed, owner, time, pos);
    }

    private float getRandomlySpinningRotation(int seed, long time) {
        if (this.noTargetWobbler.shouldUpdate(time)) {
            this.noTargetWobbler.update(time, this.random.nextFloat());
        }
        float f = this.noTargetWobbler.rotation() + (float)TravelersCompassAngleState.hash(seed) / 2.1474836E9f;
        return Mth.positiveModulo((float)f, (float)1.0f);
    }

    private float getRotationTowardsCompassTarget(int seed, ItemOwner owner, long gameTime, BlockPos targetPos) {
        float ret;
        Player player;
        float toTarget = (float)TravelersCompassAngleState.getAngleFromEntityToPos(owner, targetPos);
        float camYaw = TravelersCompassAngleState.getWrappedVisualRotationY(owner);
        LivingEntity livingEntity = owner.asLivingEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).isLocalPlayer() && player.level().tickRateManager().runsNormally()) {
            if (this.wobbler.shouldUpdate(gameTime)) {
                this.wobbler.update(gameTime, 0.5f - (camYaw - 0.25f));
            }
            ret = toTarget + this.wobbler.rotation();
        } else {
            ret = 0.5f - (camYaw - 0.25f - toTarget);
        }
        return Mth.positiveModulo((float)ret, (float)1.0f);
    }

    private boolean isValidCompassTargetPos(BlockPos pos) {
        return pos != null;
    }

    private static double getAngleFromEntityToPos(ItemOwner owner, BlockPos pos) {
        Vec3 vec3 = Vec3.atCenterOf((Vec3i)pos);
        LivingEntity living = owner.asLivingEntity();
        if (living == null) {
            return 0.0;
        }
        return Math.atan2(vec3.z() - living.getZ(), vec3.x() - living.getX()) / 6.2831854820251465;
    }

    private static float getWrappedVisualRotationY(ItemOwner owner) {
        return Mth.positiveModulo((float)(owner.getVisualRotationYInDegrees() / 360.0f), (float)1.0f);
    }

    private static int hash(int seed) {
        return seed * 1327217883;
    }
}

