/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.screen;

import com.nine.travelerscompass.client.ClientCache;
import com.nine.travelerscompass.client.CompassUI;
import com.nine.travelerscompass.client.component.button.InfoButton;
import com.nine.travelerscompass.client.component.button.PauseButton;
import com.nine.travelerscompass.client.component.button.ResetButton;
import com.nine.travelerscompass.client.component.button.SettingsButton;
import com.nine.travelerscompass.client.component.button.TabButton;
import com.nine.travelerscompass.client.component.button.WideSearchButton;
import com.nine.travelerscompass.client.component.button.base.BaseButton;
import com.nine.travelerscompass.client.component.button.hud.HudButton;
import com.nine.travelerscompass.client.component.button.popup.PopupButton;
import com.nine.travelerscompass.client.component.button.range.IntRangeButton;
import com.nine.travelerscompass.client.component.button.search.ContainersButton;
import com.nine.travelerscompass.client.component.button.search.FluidSearchModeButton;
import com.nine.travelerscompass.client.component.button.search.InventoriesButton;
import com.nine.travelerscompass.client.component.button.search.SearchModeButton;
import com.nine.travelerscompass.client.component.button.search.VillagersButton;
import com.nine.travelerscompass.client.component.button.settings.ButtonGenericSettings;
import com.nine.travelerscompass.client.component.button.settings.ButtonRangeSettings;
import com.nine.travelerscompass.client.component.button.settings.ButtonSearchModeSettings;
import com.nine.travelerscompass.client.utils.ButtonGrid;
import com.nine.travelerscompass.client.utils.GhostStack;
import com.nine.travelerscompass.client.utils.Icon;
import com.nine.travelerscompass.common.container.CompassContainer;
import com.nine.travelerscompass.common.container.menu.CompassMenu;
import com.nine.travelerscompass.common.data.CompassComponents;
import com.nine.travelerscompass.common.item.TravelersCompassItem;
import com.nine.travelerscompass.common.utils.PriorityMode;
import com.nine.travelerscompass.common.utils.TabPage;
import com.nine.travelerscompass.config.TCConfig;
import com.nine.travelerscompass.config.cost.SearchCost;
import com.nine.travelerscompass.config.cost.SearchCostHelper;
import com.nine.travelerscompass.config.filter.FilterManager;
import com.nine.travelerscompass.config.filter.FilterReason;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CompassScreen
extends AbstractContainerScreen<CompassMenu> {
    private static final ResourceLocation SEARCH_SCREEN_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"travelerscompass", (String)"textures/gui/container/compass_screen_1.png");
    private static final ResourceLocation SETTINGS_SCREEN_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"travelerscompass", (String)"textures/gui/container/compass_screen_2.png");
    public static final ResourceLocation PRIORITY_SLOT = ResourceLocation.fromNamespaceAndPath((String)"travelerscompass", (String)"textures/gui/priority_slot.png");
    public GhostStack ghostStack = GhostStack.EMPTY;
    private final List<ButtonEntry> buttonEntries = new ArrayList<ButtonEntry>();
    private Player player;
    private ItemStack stack;
    private TabPage tabPage;
    private UUID uuid;
    private ButtonGrid grid;
    private TabButton searchTabButton;
    private TabButton settingsTabButton;

    public CompassScreen(CompassMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.imageWidth = 177;
        this.imageHeight = 169;
        this.tabPage = TabPage.SEARCH;
    }

    protected void init() {
        ItemStack stack;
        super.init();
        this.player = Minecraft.getInstance().player;
        if (this.player == null) {
            return;
        }
        this.stack = stack = this.player.getMainHandItem();
        this.grid = new ButtonGrid(this.leftPos + 7, this.topPos + 7, 14, 14, 2, 2);
        this.uuid = CompassComponents.get(stack, CompassComponents.COMPASS_UUID);
        this.tabPage = CompassComponents.get(stack, CompassComponents.TAB_PAGE);
        this.initButtons();
        this.revealButtons(ButtonCategory.STATIC);
        this.revealButtons(this.tabPage == TabPage.SETTINGS ? ButtonCategory.SETTINGS : ButtonCategory.SEARCH);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        for (ButtonEntry entry : this.buttonEntries) {
            PopupButton popupButton;
            BaseButton button = entry.button;
            if (!entry.active) continue;
            if (button.isMouseOver(mouseX, mouseY)) {
                button.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
            }
            if (!(button instanceof PopupButton) || !(popupButton = (PopupButton)button).isPopupVisible()) continue;
            popupButton.popupButtons.forEach(b -> {
                if (b.isMouseOver(mouseX, mouseY)) {
                    b.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
                }
            });
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean bl) {
        for (ButtonEntry entry : this.buttonEntries) {
            BaseButton baseButton = entry.button;
            if (!(baseButton instanceof PopupButton)) continue;
            PopupButton popupButton = (PopupButton)baseButton;
            if (!entry.active) continue;
            popupButton.popupMouseClicked(event, bl);
            popupButton.afterPopupClick();
        }
        return super.mouseClicked(event, bl);
    }

    protected void containerTick() {
        for (ButtonEntry entry : this.buttonEntries) {
            if (!entry.active) continue;
            entry.button.tick();
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    private void initSearchModeButtons() {
        ButtonSearchModeSettings.Builder settings = ((ButtonSearchModeSettings.Builder)((ButtonSearchModeSettings.Builder)((ButtonSearchModeSettings.Builder)((ButtonSearchModeSettings.Builder)ButtonSearchModeSettings.builder().size(14, 14)).stackSup(() -> this.stack)).uuid(this.uuid)).mainLayerSet(CompassUI.ButtonTextures.TOGGLE_BUTTON)).lockIcon(CompassUI.CommonTextures.LOCK_ICON);
        this.addButton(new SearchModeButton(((ButtonSearchModeSettings.Builder)settings.copy().position(this.grid.x(0), this.grid.y(0))).data(CompassComponents.BLOCKS).configEnabled(TCConfig.ENABLE_BLOCKS_SEARCH.get()).icons(CompassUI.SearchModeTextures.BLOCKS_ACTIVE_ICON, CompassUI.SearchModeTextures.BLOCKS_INACTIVE_ICON).build()), ButtonCategory.SEARCH);
        this.addButton(new SearchModeButton(((ButtonSearchModeSettings.Builder)settings.copy().position(this.grid.x(1), this.grid.y(0))).descriptions(new Component[]{Component.translatable((String)"tooltip.travelerscompass.search_mode.mobs.desc").withStyle(ChatFormatting.GRAY), Component.translatable((String)"tooltip.travelerscompass.search_mode.mobs_shift_click.desc", (Object[])new Object[]{Component.translatable((String)"tooltip.travelerscompass.settings.modification.shift_click")}).withStyle(ChatFormatting.GRAY)}).data(CompassComponents.MOBS).configEnabled(TCConfig.ENABLE_MOBS_SEARCH.get()).icons(CompassUI.SearchModeTextures.MOBS_ACTIVE_ICON, CompassUI.SearchModeTextures.MOBS_INACTIVE_ICON).build()), ButtonCategory.SEARCH);
        this.addButton(new FluidSearchModeButton(((ButtonSearchModeSettings.Builder)settings.copy().position(this.grid.x(2), this.grid.y(1))).data(CompassComponents.FLUIDS).configEnabled(TCConfig.ENABLE_FLUIDS_SEARCH.get()).icons(CompassUI.SearchModeTextures.FLUIDS_ACTIVE_ICON, CompassUI.SearchModeTextures.FLUIDS_INACTIVE_ICON).build()), ButtonCategory.SEARCH);
        this.addButton(new SearchModeButton(((ButtonSearchModeSettings.Builder)settings.copy().position(this.grid.x(1), this.grid.y(1))).data(CompassComponents.SPAWNERS).configEnabled(TCConfig.ENABLE_SPAWNERS_SEARCH.get()).icons(CompassUI.SearchModeTextures.SPAWNERS_ACTIVE_ICON, CompassUI.SearchModeTextures.SPAWNERS_INACTIVE_ICON).build()), ButtonCategory.SEARCH);
        this.addButton(new SearchModeButton(((ButtonSearchModeSettings.Builder)settings.copy().position(this.grid.x(2), this.grid.y(2))).data(CompassComponents.DROP).configEnabled(TCConfig.ENABLE_DROPS_SEARCH.get()).icons(CompassUI.SearchModeTextures.DROP_ACTIVE_ICON, CompassUI.SearchModeTextures.DROP_INACTIVE_ICON).build()), ButtonCategory.SEARCH);
        this.addButton(new SearchModeButton(((ButtonSearchModeSettings.Builder)settings.copy().position(this.grid.x(1), this.grid.y(2))).data(CompassComponents.ITEM_ENTITIES).configEnabled(TCConfig.ENABLE_ITEM_ENTITIES_SEARCH.get()).icons(CompassUI.SearchModeTextures.ITEM_ENTITIES_ACTIVE_ICON, CompassUI.SearchModeTextures.ITEM_ENTITIES_INACTIVE_ICON).build()), ButtonCategory.SEARCH);
        this.addButton(new ContainersButton(((ButtonSearchModeSettings.Builder)settings.copy().position(this.grid.x(2), this.grid.y(0))).data(CompassComponents.CONTAINERS).configEnabled(TCConfig.ENABLE_BLOCK_CONTAINERS_SEARCH.get()).icons(CompassUI.SearchModeTextures.CONTAINERS_ACTIVE_ICON, CompassUI.SearchModeTextures.CONTAINERS_INACTIVE_ICON).build()), ButtonCategory.SEARCH);
        this.addButton(new VillagersButton(((ButtonSearchModeSettings.Builder)settings.copy().position(this.grid.x(0), this.grid.y(1))).data(CompassComponents.VILLAGERS).configEnabled(TCConfig.ENABLE_VILLAGERS_SEARCH.get()).icons(CompassUI.SearchModeTextures.VILLAGERS_ACTIVE_ICON, CompassUI.SearchModeTextures.VILLAGERS_INACTIVE_ICON).build()), ButtonCategory.SEARCH);
        this.addButton(new InventoriesButton(((ButtonSearchModeSettings.Builder)settings.copy().position(this.grid.x(0), this.grid.y(2))).data(CompassComponents.INVENTORIES).configEnabled(TCConfig.ENABLE_INVENTORIES_SEARCH.get()).icons(CompassUI.SearchModeTextures.INVENTORIES_ACTIVE_ICON, CompassUI.SearchModeTextures.INVENTORIES_INACTIVE_ICON).build()), ButtonCategory.SEARCH);
    }

    private void initUtilButtons() {
        Object settings = ((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)ButtonGenericSettings.builder().uuid(this.uuid)).size(14, 14)).mainLayerSet(CompassUI.ButtonTextures.TOGGLE_BUTTON)).stackSup(() -> this.stack);
        this.addButton(new InfoButton(((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)settings).copy()).position(this.grid.x(2), this.grid.y(3))).build()), ButtonCategory.SEARCH);
        this.addButton(new WideSearchButton(((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)settings).copy()).position(this.grid.x(1), this.grid.y(3))).build()), ButtonCategory.SEARCH);
        this.addButton(new PauseButton(((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)settings).copy()).position(this.grid.x(0), this.grid.y(3))).build()), ButtonCategory.SEARCH);
    }

    private void initSettingsButtons() {
        Object settings = ((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)ButtonGenericSettings.builder().uuid(this.uuid)).size(14, 14)).mainLayerSet(CompassUI.ButtonTextures.TOGGLE_BUTTON)).stackSup(() -> this.stack);
        this.addButton(SettingsButton.create(((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)settings).copy()).position(this.grid.x(2), this.grid.y(2))).build(), CompassComponents.HEIGHT_MARKER, (cached, hovered) -> {
            if (cached.booleanValue()) {
                return hovered != false ? CompassUI.SettingsTextures.HEIGHT_MARKER_ACTIVE_HOVERED_ICON : CompassUI.SettingsTextures.HEIGHT_MARKER_ACTIVE_ICON;
            }
            return hovered != false ? CompassUI.SettingsTextures.HEIGHT_MARKER_INACTIVE_HOVERED_ICON : CompassUI.SettingsTextures.HEIGHT_MARKER_INACTIVE_ICON;
        }), ButtonCategory.SETTINGS);
        this.addButton(SettingsButton.create(((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)settings).copy()).position(this.grid.x(1), this.grid.y(3))).build(), CompassComponents.TARGET_VALIDATION, (cached, hovered) -> {
            if (cached.booleanValue()) {
                return hovered != false ? CompassUI.SettingsTextures.TARGET_VALIDATION_ACTIVE_HOVERED_ICON : CompassUI.SettingsTextures.TARGET_VALIDATION_ACTIVE_ICON;
            }
            return hovered != false ? CompassUI.SettingsTextures.TARGET_VALIDATION_INACTIVE_HOVERED_ICON : CompassUI.SettingsTextures.TARGET_VALIDATION_INACTIVE_ICON;
        }), ButtonCategory.SETTINGS);
        this.addButton(SettingsButton.create(((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)settings).copy()).position(this.grid.x(0), this.grid.y(2))).build(), CompassComponents.SOUND_PING, (cached, hovered) -> {
            if (cached.booleanValue()) {
                return hovered != false ? CompassUI.SettingsTextures.SOUND_PING_ACTIVE_HOVERED_ICON : CompassUI.SettingsTextures.SOUND_PING_ACTIVE_ICON;
            }
            return hovered != false ? CompassUI.SettingsTextures.SOUND_PING_INACTIVE_HOVERED_ICON : CompassUI.SettingsTextures.SOUND_PING_INACTIVE_ICON;
        }), ButtonCategory.SETTINGS);
        this.addButton(SettingsButton.create(((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)settings).copy()).position(this.grid.x(2), this.grid.y(1))).build(), CompassComponents.FORCE_CHUNKS_LOAD, (cached, hovered) -> {
            if (cached.booleanValue()) {
                return hovered != false ? CompassUI.SettingsTextures.FORCE_LOAD_ACTIVE_HOVERED_ICON : CompassUI.SettingsTextures.FORCE_LOAD_ACTIVE_ICON;
            }
            return hovered != false ? CompassUI.SettingsTextures.FORCE_LOAD_INACTIVE_HOVERED_ICON : CompassUI.SettingsTextures.FORCE_LOAD_INACTIVE_ICON;
        }), ButtonCategory.SETTINGS);
        this.addButton(new SettingsButton<PriorityMode>(((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)settings).copy()).position(this.grid.x(1), this.grid.y(2))).build(), CompassComponents.PRIORITY_MODE, (cached, hovered) -> switch (cached) {
            default -> throw new MatchException(null, null);
            case PriorityMode.OFF -> {
                if (hovered.booleanValue()) {
                    yield CompassUI.SettingsTextures.PRIORITY_OFF_HOVERED_ICON;
                }
                yield CompassUI.SettingsTextures.PRIORITY_OFF_ICON;
            }
            case PriorityMode.NORMAL -> {
                if (hovered.booleanValue()) {
                    yield CompassUI.SettingsTextures.PRIORITY_NORMAL_HOVERED_ICON;
                }
                yield CompassUI.SettingsTextures.PRIORITY_NORMAL_ICON;
            }
            case PriorityMode.INVERTED -> hovered != false ? CompassUI.SettingsTextures.PRIORITY_INVERT_HOVERED_ICON : CompassUI.SettingsTextures.PRIORITY_INVERT_ICON;
        }, cached -> "tooltip.travelerscompass.settings.priority_mode." + cached.name().toLowerCase(), cached -> switch (cached) {
            default -> throw new MatchException(null, null);
            case PriorityMode.OFF -> CompassUI.DISABLED;
            case PriorityMode.NORMAL -> CompassUI.ENABLED;
            case PriorityMode.INVERTED -> CompassUI.INVERTED;
        }), ButtonCategory.SETTINGS);
        this.addButton(new ResetButton(((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)settings).copy()).position(this.grid.x(2), this.grid.y(3))).afterLeftClick(button -> {
            HudButton.resetHudSettings(this.stack);
            CompassScreen.resetSettings(this.stack);
            this.updateButtons(ButtonCategory.SETTINGS);
            ClientCache.updateAllHudSettings(this.stack, true);
        })).build()), ButtonCategory.SETTINGS);
        this.addButton(new HudButton(((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)settings).copy()).position(this.grid.x(0), this.grid.y(3))).build()), ButtonCategory.SETTINGS);
        ButtonRangeSettings.Builder rangeSettings = ButtonRangeSettings.builder(settings).minusIcons(CompassUI.CommonTextures.MINUS_ICON, CompassUI.CommonTextures.MINUS_HOVERED_ICON, CompassUI.CommonTextures.MINUS_INACTIVE_ICON).plusIcons(CompassUI.CommonTextures.PLUS_ICON, CompassUI.CommonTextures.PLUS_HOVERED_ICON, CompassUI.CommonTextures.PLUS_INACTIVE_ICON);
        this.addButton(new IntRangeButton(((ButtonRangeSettings.Builder)rangeSettings.copy().position(this.grid.x(1), this.grid.y(0))).icon(CompassUI.SettingsTextures.CHUNKS_RANGE_ICON).build(), 1, TCConfig.BLOCKS_CHUNK_SEARCH_RANGE.get(), 1, 5, CompassComponents.BLOCK_SEARCH_CHUNK_RANGE), ButtonCategory.SETTINGS);
        this.addButton(new IntRangeButton(((ButtonRangeSettings.Builder)rangeSettings.copy().position(this.grid.x(2), this.grid.y(0))).icon(CompassUI.SettingsTextures.ENTITIES_RANGE_ICON).build(), 1, TCConfig.ENTITIES_SEARCH_RANGE.get(), 1, 5, CompassComponents.ENTITIES_SEARCH_RANGE), ButtonCategory.SETTINGS);
        this.addButton(new IntRangeButton(((ButtonRangeSettings.Builder)rangeSettings.copy().position(this.grid.x(1), this.grid.y(1))).icon(CompassUI.SettingsTextures.WIDE_SEARCH_RANGE_ICON).build(), 1, TCConfig.WIDE_SEARCH_RANGE.get(), 1, 5, CompassComponents.WIDE_SEARCH_RANGE), ButtonCategory.SETTINGS);
    }

    private void initTabButtons() {
        Object settings = ((ButtonGenericSettings.Builder)ButtonGenericSettings.builder().size(26, 24)).stackSup(() -> this.stack);
        this.searchTabButton = this.addButton(new TabButton(((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)settings).position(this.leftPos + 130, this.topPos + 8)).afterLeftClick(b -> {
            if (this.tabPage == TabPage.SETTINGS) {
                this.searchTabButton.selected = true;
                this.settingsTabButton.selected = false;
                CompassComponents.TAB_PAGE.syncToServer(this.stack, TabPage.SEARCH);
                this.tabPage = TabPage.SEARCH;
                this.revealButtons(ButtonCategory.SEARCH);
                this.hideButtons(ButtonCategory.SETTINGS);
            }
        })).build(), this.tabPage == TabPage.SEARCH, Icon.of(CompassUI.CommonTextures.SEARCH, 6.0f, 4.0f), (Component)Component.translatable((String)"tooltip.travelerscompass.search")), ButtonCategory.STATIC);
        this.settingsTabButton = this.addButton(new TabButton(((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)((ButtonGenericSettings.Builder)settings).position(this.leftPos + 130, this.topPos + 42)).afterLeftClick(b -> {
            if (this.tabPage == TabPage.SEARCH) {
                this.searchTabButton.selected = false;
                this.settingsTabButton.selected = true;
                CompassComponents.TAB_PAGE.syncToServer(this.stack, TabPage.SETTINGS);
                this.tabPage = TabPage.SETTINGS;
                this.revealButtons(ButtonCategory.SETTINGS);
                this.hideButtons(ButtonCategory.SEARCH);
            }
        })).build(), this.tabPage == TabPage.SETTINGS, Icon.of(CompassUI.CommonTextures.SETTINGS, 6.0f, 4.0f), (Component)Component.translatable((String)"tooltip.travelerscompass.settings")), ButtonCategory.STATIC);
    }

    private void initButtons() {
        this.buttonEntries.clear();
        this.initTabButtons();
        this.initSearchModeButtons();
        this.initUtilButtons();
        this.initSettingsButtons();
    }

    public static void resetSettings(ItemStack stack) {
        CompassComponents.putDefaultToServer(stack, CompassComponents.WIDE_SEARCH_RANGE);
        CompassComponents.putDefaultToServer(stack, CompassComponents.ENTITIES_SEARCH_RANGE);
        CompassComponents.putDefaultToServer(stack, CompassComponents.BLOCK_SEARCH_CHUNK_RANGE);
        CompassComponents.putDefaultToServer(stack, CompassComponents.FORCE_CHUNKS_LOAD);
        CompassComponents.putDefaultToServer(stack, CompassComponents.SOUND_PING);
        CompassComponents.putDefaultToServer(stack, CompassComponents.PRIORITY_MODE);
        CompassComponents.putDefaultToServer(stack, CompassComponents.HEIGHT_MARKER);
        CompassComponents.putDefaultToServer(stack, CompassComponents.HUD_RENDER_MODE);
        CompassComponents.putDefaultToServer(stack, CompassComponents.TARGET_VALIDATION);
    }

    private void updateButtons(ButtonCategory category) {
        for (ButtonEntry entry : this.buttonEntries) {
            if (!category.equals((Object)entry.category)) continue;
            BaseButton button = entry.button;
            button.updateState();
            if (!(button instanceof PopupButton)) continue;
            PopupButton popupButton = (PopupButton)button;
            popupButton.updatePopupButtons();
        }
    }

    private void revealButtons(ButtonCategory category) {
        for (ButtonEntry entry : this.buttonEntries) {
            if (!category.equals((Object)entry.category)) continue;
            entry.setActive(true);
            this.addRenderableWidget((GuiEventListener)entry.button);
        }
    }

    private void hideButtons(ButtonCategory category) {
        for (ButtonEntry entry : this.buttonEntries) {
            if (!category.equals((Object)entry.category)) continue;
            entry.setActive(false);
            this.removeWidget((GuiEventListener)entry.button);
        }
    }

    private <T extends BaseButton> T addButton(T button, ButtonCategory category) {
        this.buttonEntries.add(new ButtonEntry(button, category));
        return button;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.minecraft != null && this.minecraft.player != null && this.minecraft.player.getMainHandItem().getItem() instanceof TravelersCompassItem) {
            this.stack = this.minecraft.player.getMainHandItem();
        }
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        Slot slot = this.hoveredSlot;
        if (slot != null && slot.container instanceof CompassContainer) {
            ItemStack carriedStack = ((CompassMenu)this.getMenu()).getCarried();
            if (carriedStack.isEmpty() && this.ghostStack.valid()) {
                if (!this.ghostStack.allowed()) {
                    guiGraphics.setTooltipForNextFrame(this.font, (Component)Component.translatable((String)"nei.travelerscompass.dragging_disabled", (Object[])new Object[]{Component.translatable((String)("nei.travelerscompass." + this.ghostStack.nei().name().toLowerCase()))}).withStyle(ChatFormatting.RED), mouseX, mouseY, (ResourceLocation)carriedStack.get(DataComponents.TOOLTIP_STYLE));
                    return;
                }
                carriedStack = this.ghostStack.stack();
            }
            if (carriedStack.isEmpty() || !TCConfig.SEARCH_REQUIRES_XP.get().booleanValue()) {
                return;
            }
            Item carried = carriedStack.getItem();
            SearchCost sc = SearchCostHelper.getCost(carried);
            FilterReason filterReason = FilterManager.getFilterReason(carried);
            if (filterReason.isAllowed()) {
                if (!sc.isFree() && !this.player.isCreative()) {
                    ArrayList<MutableComponent> extra = new ArrayList<MutableComponent>();
                    MutableComponent req = sc.reqAsComponent().withStyle(sc.meetsRequirement(this.player.experienceLevel) ? ChatFormatting.GRAY : ChatFormatting.RED);
                    MutableComponent cost = sc.costAsComponent().withStyle(ChatFormatting.GRAY);
                    extra.add(req);
                    extra.add(cost);
                    guiGraphics.setComponentTooltipForNextFrame(this.font, extra, mouseX, mouseY, (ResourceLocation)carriedStack.get(DataComponents.TOOLTIP_STYLE));
                }
            } else {
                guiGraphics.setTooltipForNextFrame(this.font, ClientCache.formatFilterReason(filterReason), mouseX, mouseY, (ResourceLocation)carriedStack.get(DataComponents.TOOLTIP_STYLE));
            }
        }
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && this.stack != null) {
            int w = (this.width - this.imageWidth) / 2;
            int h = (this.height - this.imageHeight) / 2;
            graphics.blit(RenderPipelines.GUI_TEXTURED, this.tabPage.equals((Object)TabPage.SEARCH) ? SEARCH_SCREEN_LOCATION : SETTINGS_SCREEN_LOCATION, w, h, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
            for (int i : CompassComponents.get(this.stack, CompassComponents.PRIORITY_SLOTS)) {
                int j = i > 2 ? 1 : 0;
                j = i > 5 ? 2 : j;
                int c = i > 2 ? i - 3 : i;
                c = i > 5 ? i - 6 : c;
                graphics.blit(RenderPipelines.GUI_TEXTURED, PRIORITY_SLOT, this.leftPos + 72 + c * 18, this.topPos + 10 + j * 18, 0.0f, 0.0f, 18, 18, 18, 18);
            }
        }
    }

    public int leftPos() {
        return this.leftPos;
    }

    public int topPos() {
        return this.topPos;
    }

    private static enum ButtonCategory {
        SEARCH,
        SETTINGS,
        STATIC;

    }

    private static class ButtonEntry {
        public final BaseButton button;
        public final ButtonCategory category;
        public boolean active;

        private ButtonEntry(BaseButton button, ButtonCategory category) {
            this.button = button;
            this.category = category;
            this.active = false;
        }

        public void setActive(boolean active) {
            this.active = active;
        }
    }
}

