/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.utils;

import com.nine.travelerscompass.client.CompassUI;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class TooltipBuilder {
    private final List<Component> lines = new ArrayList<Component>();
    private final List<Component> bottomLines = new ArrayList<Component>();

    private TooltipBuilder() {
    }

    public static TooltipBuilder builder() {
        return new TooltipBuilder();
    }

    public TooltipBuilder title(String key) {
        return this.title((Component)Component.translatable((String)key));
    }

    public TooltipBuilder title(Component component) {
        this.lines.addFirst(component);
        return this;
    }

    public TooltipBuilder descIf(Component desc, boolean cond) {
        if (cond) {
            return this.desc(desc);
        }
        return this;
    }

    public TooltipBuilder descIf(String baseKey, boolean cond) {
        if (cond) {
            return this.desc(baseKey);
        }
        return this;
    }

    public TooltipBuilder desc(String baseKey) {
        return this.desc((Component)Component.translatable((String)(baseKey + ".desc")).copy().withStyle(ChatFormatting.GRAY));
    }

    public TooltipBuilder desc(Component component) {
        return this.line((Component)CompassUI.DESC_ARROW.copy().append((Component)component.copy()));
    }

    public TooltipBuilder lineIf(String component, boolean condition) {
        if (condition) {
            return this.line(component);
        }
        return this;
    }

    public TooltipBuilder lineIf(Component component, boolean condition) {
        if (condition) {
            return this.line(component);
        }
        return this;
    }

    public TooltipBuilder line(Component component) {
        this.lines.add(component);
        return this;
    }

    public TooltipBuilder line(String text) {
        this.lines.add((Component)Component.translatable((String)text));
        return this;
    }

    public TooltipBuilder state(String key) {
        return this.state((Component)Component.translatable((String)key));
    }

    public TooltipBuilder state(Component state) {
        this.bottomLines.add(state);
        return this;
    }

    public Component build() {
        boolean firstLine = true;
        MutableComponent ret = Component.empty();
        for (Component line : this.lines) {
            if (firstLine) {
                ret.append(line);
                firstLine = false;
                continue;
            }
            ret.append("\n").append(line);
        }
        for (Component line : this.bottomLines) {
            if (firstLine) {
                ret.append(line);
                firstLine = false;
                continue;
            }
            ret.append("\n").append(line);
        }
        return ret;
    }

    public Tooltip buildAsTooltip() {
        return Tooltip.create((Component)this.build());
    }
}

