/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.search;

import com.nine.travelerscompass.common.data.CompassComponents;
import com.nine.travelerscompass.common.data.DataStorage;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class SearchOptions {
    private final Map<DataStorage<?>, Object> options = new HashMap();
    private final int entitiesSearchRange;
    private final int chunksSearchRange;
    private final boolean wideSearch;
    private final UUID playerUUID;
    private final ServerPlayer player;

    public SearchOptions(ItemStack stack, ServerPlayer player, boolean wideSearch) {
        for (DataStorage<?> property : CompassComponents.SEARCH_OPTIONS) {
            this.options.put(property, CompassComponents.get(stack, property));
        }
        this.entitiesSearchRange = CompassComponents.ENTITIES_SEARCH_RANGE.get(stack);
        this.chunksSearchRange = wideSearch ? CompassComponents.WIDE_SEARCH_RANGE.get(stack) : CompassComponents.BLOCK_SEARCH_CHUNK_RANGE.get(stack);
        this.playerUUID = player.getUUID();
        this.player = player;
        this.wideSearch = wideSearch;
    }

    public int getEntitiesSearchRange() {
        return this.entitiesSearchRange;
    }

    public int getChunksSearchRange() {
        return this.chunksSearchRange;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public ServerPlayer player() {
        return this.player;
    }

    public boolean wideSearch() {
        return this.wideSearch;
    }

    public <T> T get(DataStorage<T> option) {
        return (T)this.options.get(option);
    }
}

