/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.search;

import com.nine.travelerscompass.common.search.ChunkIterator;
import com.nine.travelerscompass.common.search.SearchManager;
import com.nine.travelerscompass.common.search.SearchOptions;
import com.nine.travelerscompass.common.search.SearchResult;
import com.nine.travelerscompass.common.search.criterion.TypedCriteria;
import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.search.matcher.BlockEntityMatcher;
import com.nine.travelerscompass.common.search.matcher.BlockMatcher;
import com.nine.travelerscompass.common.search.matcher.EntityMatcher;
import com.nine.travelerscompass.config.filter.FilterManager;
import com.nine.travelerscompass.config.filter.FilterReason;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SearchProcess {
    private volatile boolean isAsyncRunning;
    private final AtomicBoolean canceled = new AtomicBoolean(false);
    final List<BlockMatcher> blockMatchers;
    final List<BlockEntityMatcher> blockEntityMatchers;
    final List<EntityMatcher> entityMatchers;
    final SearchOptions options;
    final TypedCriteria criteria;
    public final boolean allowChunkGen;
    public final boolean wideSearch;
    public final Level level;
    final BlockPos playerPos;
    final Queue<ChunkPos> deferredChunks = new ArrayDeque<ChunkPos>();
    private final ChunkIterator chunkIterator;
    int lastSyncedProgress;
    public final int chunksToScan;
    public int chunksPassed = 0;
    public int chunksPassedLastTick = 0;
    public int chunksLoaded = 0;
    int chunksLoadedLastTick = 0;
    public int chunksForceLoaded = 0;
    public int chunksForceLoadedLastTick = 0;
    final int entitiesSearchRange;
    public final SearchResult result = new SearchResult();
    public final Consumer<SearchResult> onComplete;

    public SearchProcess(Player player, boolean allowChunkGen, SearchOptions options, TypedCriteria criteria, List<BlockMatcher> bMatchers, List<BlockEntityMatcher> beMatchers, List<EntityMatcher> eMatchers, Consumer<SearchResult> onComplete) {
        this.allowChunkGen = allowChunkGen;
        this.wideSearch = options.wideSearch();
        this.level = player.level();
        this.criteria = criteria;
        this.options = options;
        this.entitiesSearchRange = options.getEntitiesSearchRange();
        this.playerPos = player.blockPosition();
        this.blockMatchers = bMatchers;
        this.blockEntityMatchers = beMatchers;
        this.entityMatchers = eMatchers;
        this.onComplete = onComplete;
        this.chunksToScan = (int)Math.pow(1 + options.getChunksSearchRange() * 2, 2.0);
        this.chunkIterator = new ChunkIterator(this.playerPos, options.getChunksSearchRange());
    }

    public void scanEntities() {
        AABB aabb = new AABB(Vec3.atLowerCornerOf((Vec3i)this.playerPos.offset(-this.entitiesSearchRange, -this.entitiesSearchRange, -this.entitiesSearchRange)), Vec3.atLowerCornerOf((Vec3i)this.playerPos.offset(this.entitiesSearchRange, this.entitiesSearchRange, this.entitiesSearchRange)));
        List list = this.level.getEntitiesOfClass(Entity.class, aabb);
        if (this.entityMatchers.isEmpty()) {
            return;
        }
        for (Entity entity : list) {
            FilterReason filterReason = FilterManager.getFilterReason(entity.getType());
            if (!filterReason.isAllowed()) continue;
            for (EntityMatcher matcher : this.entityMatchers) {
                List<ILocationObject> data = matcher.match(this.criteria, this.options, entity, this.level, entity.blockPosition());
                if (data == null) continue;
                this.result.addAll(data);
            }
        }
    }

    public boolean tickAsync(int chunksLimit, int generationLimit) {
        if (this.isAsyncRunning || chunksLimit == 0) {
            return false;
        }
        MinecraftServer server = this.level.getServer();
        if (server == null || this.canceled.get()) {
            return true;
        }
        this.chunksPassedLastTick = 0;
        this.chunksForceLoadedLastTick = 0;
        this.chunksLoadedLastTick = 0;
        ArrayList<ChunkAccess> chunkList = new ArrayList<ChunkAccess>();
        while (this.chunkIterator.hasNext()) {
            boolean force;
            ++this.chunksPassed;
            ++this.chunksPassedLastTick;
            ChunkPos pos = this.chunkIterator.next();
            boolean chunkLoaded = this.level.hasChunk(pos.x, pos.z);
            boolean bl = force = this.allowChunkGen && !chunkLoaded && generationLimit > 0 && this.chunksForceLoadedLastTick <= generationLimit;
            if (force || chunkLoaded) {
                ChunkAccess chunkAccess = this.level.getChunk(pos.x, pos.z, ChunkStatus.FULL, force);
                ++this.chunksLoaded;
                ++this.chunksLoadedLastTick;
                if (force) {
                    ++this.chunksForceLoaded;
                    ++this.chunksForceLoadedLastTick;
                }
                if (chunkAccess != null) {
                    chunkList.add(chunkAccess);
                }
            } else if (this.allowChunkGen && this.wideSearch) {
                this.deferredChunks.add(pos);
            }
            if (this.chunksPassedLastTick < chunksLimit) continue;
            break;
        }
        if (this.wideSearch && this.allowChunkGen && this.chunksLoadedLastTick < chunksLimit) {
            int lim = chunksLimit - chunkList.size();
            while (lim > 0 && !this.deferredChunks.isEmpty()) {
                boolean force;
                ChunkPos pos = this.deferredChunks.peek();
                boolean loaded = this.level.hasChunk(pos.x, pos.z);
                boolean bl = force = generationLimit > 0 && this.chunksForceLoadedLastTick < generationLimit;
                if (!loaded && force) break;
                ChunkAccess currentChunk = this.level.getChunk(pos.x, pos.z, ChunkStatus.FULL, !loaded);
                if (currentChunk == null) break;
                this.deferredChunks.poll();
                chunkList.add(currentChunk);
                --lim;
                if (!loaded) {
                    ++this.chunksForceLoaded;
                    ++this.chunksForceLoadedLastTick;
                }
                ++this.chunksLoaded;
                ++this.chunksLoadedLastTick;
            }
        }
        ArrayList blockEntityPositions = new ArrayList();
        this.isAsyncRunning = true;
        CompletableFuture.supplyAsync(() -> {
            ArrayList<ILocationObject> localDataList = new ArrayList<ILocationObject>();
            for (ChunkAccess chunkAccess : chunkList) {
                LevelChunkSection[] sections = chunkAccess.getSections();
                int minSectionY = chunkAccess.getMinSectionY();
                int baseX = chunkAccess.getPos().x << 4;
                int baseZ = chunkAccess.getPos().z << 4;
                blockEntityPositions.addAll(chunkAccess.getBlockEntitiesPos());
                for (int s = 0; s < sections.length; ++s) {
                    PalettedContainer palette;
                    boolean shouldScanBlocks;
                    LevelChunkSection section = sections[s];
                    if (section == null || section.hasOnlyAir() || !(shouldScanBlocks = (palette = section.getStates()).maybeHas(state -> this.criteria.placeableBlocks.contains(state.getBlock())))) continue;
                    int baseY = minSectionY + s << 4;
                    BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
                    for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            for (int y = 0; y < 16; ++y) {
                                BlockState state2 = section.getBlockState(x, y, z);
                                if (state2.isAir()) continue;
                                for (BlockMatcher matcher : this.blockMatchers) {
                                    mutablePos.set(baseX + x, baseY + y, baseZ + z);
                                    ILocationObject data = matcher.match(this.criteria, mutablePos.immutable(), state2);
                                    if (data == null) continue;
                                    localDataList.add(data);
                                }
                            }
                        }
                    }
                }
            }
            return localDataList;
        }).thenAcceptAsync(threadResult -> server.execute(() -> {
            if (this.canceled.get()) {
                this.isAsyncRunning = false;
                return;
            }
            try {
                for (BlockPos pos : blockEntityPositions) {
                    BlockState state = this.level.getBlockState(pos);
                    BlockEntity be = this.level.getBlockEntity(pos);
                    if (be == null) continue;
                    for (BlockEntityMatcher matcher : this.blockEntityMatchers) {
                        List<ILocationObject> data = matcher.match(this.criteria, this.options, pos, state, be);
                        if (data == null) continue;
                        this.result.addAll(data);
                    }
                }
                this.result.addAll((List<ILocationObject>)threadResult);
            }
            finally {
                this.isAsyncRunning = false;
            }
        }), (Executor)SearchManager.SCAN_EXECUTOR);
        return this.chunksPassed >= this.chunksToScan && !this.canScanAboveLimit() || this.canceled.get();
    }

    private boolean canScanAboveLimit() {
        return this.wideSearch && this.allowChunkGen && !this.deferredChunks.isEmpty();
    }

    public void setCanceled() {
        this.canceled.set(true);
    }

    public boolean shouldSyncProgress() {
        int current = this.chunksPassed * 100 / this.chunksToScan;
        if (current != this.lastSyncedProgress || this.chunksToScan <= this.chunksPassed) {
            this.lastSyncedProgress = current;
            return true;
        }
        return false;
    }
}

