/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.utils;

import com.nine.travelerscompass.mixin.accessor.LootItemAccessor;
import com.nine.travelerscompass.mixin.accessor.LootPoolAccessor;
import com.nine.travelerscompass.mixin.accessor.LootTableAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;

public class LootUtils {
    private static final Map<ResourceLocation, Set<Item>> LOOT_CACHE = new HashMap<ResourceLocation, Set<Item>>();

    public static List<LootPool> getPools(LootTable lootTable) {
        return ((LootTableAccessor)lootTable).travelerscompass$pools();
    }

    public static List<LootPoolEntryContainer> getEntries(LootPool lootPool) {
        return ((LootPoolAccessor)lootPool).travelerscompass$entries();
    }

    public static List<LootItem> getLootItems(LootTable lootTable) {
        ArrayList<LootItem> dropList = new ArrayList<LootItem>();
        LootUtils.getPools(lootTable).forEach(lootPool -> LootUtils.getEntries(lootPool).stream().filter(entry -> entry instanceof LootItem).map(entry -> (LootItem)entry).forEach(dropList::add));
        dropList.removeIf(Objects::isNull);
        return dropList;
    }

    public static Set<Item> getItemsFromLootTable(ResourceKey<LootTable> resourceKey, Level level) {
        ResourceLocation location = resourceKey.location();
        if (LOOT_CACHE.containsKey(location)) {
            return LOOT_CACHE.get(location);
        }
        MinecraftServer server = level.getServer();
        if (server != null) {
            LootTable lootTable = server.reloadableRegistries().getLootTable(resourceKey);
            HashSet dropStackList = new HashSet();
            LootUtils.getLootItems(lootTable).stream().map(lootItem -> ((LootItemAccessor)lootItem).travelerscompass$item()).forEach(itemHolder -> dropStackList.add((Item)itemHolder.value()));
            LOOT_CACHE.put(location, dropStackList);
        }
        return LOOT_CACHE.getOrDefault(location, Set.of());
    }
}

