/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.compat.jei;

import com.nine.travelerscompass.client.screen.CompassScreen;
import com.nine.travelerscompass.common.container.menu.CompassMenu;
import com.nine.travelerscompass.compat.BaseGhostTargetHandler;
import com.nine.travelerscompass.compat.NEI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class JeiGhostTargetHandler
extends BaseGhostTargetHandler
implements IGhostIngredientHandler<CompassScreen> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(CompassScreen screen, ITypedIngredient<I> ingredient, boolean doStart) {
        ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        if (ingredient.getType() != VanillaTypes.ITEM_STACK) {
            return targets;
        }
        Optional opt = ingredient.getItemStack();
        if (opt.isPresent() && !((ItemStack)opt.get()).isEmpty()) {
            if (doStart) {
                this.setGhostStack(screen, (ItemStack)opt.get());
            }
            targets.addAll(((CompassMenu)screen.getMenu()).slots.stream().filter(x$0 -> this.isCompassSlot((Slot)x$0)).map(slot -> this.createTarget(screen, (Slot)slot)).map(target -> target).toList());
        }
        return targets;
    }

    private IGhostIngredientHandler.Target<ItemStack> createTarget(final CompassScreen screen, final Slot slot) {
        return new IGhostIngredientHandler.Target<ItemStack>(){

            public Rect2i getArea() {
                return JeiGhostTargetHandler.this.slotArea(screen, slot);
            }

            public void accept(ItemStack stack) {
                JeiGhostTargetHandler.this.applyGhostStack(slot, stack);
            }
        };
    }

    public void onComplete() {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof CompassScreen) {
            CompassScreen compassScreen = (CompassScreen)screen;
            this.setGhostStack(compassScreen, null);
        }
    }

    @Override
    public NEI nei() {
        return NEI.JEI;
    }
}

