/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.compat.lootr;

import com.nine.travelerscompass.common.data.CompassComponents;
import com.nine.travelerscompass.common.search.SearchOptions;
import com.nine.travelerscompass.common.search.criterion.ISearchCriterion;
import com.nine.travelerscompass.common.search.criterion.TypedCriteria;
import com.nine.travelerscompass.common.search.location.ILocationObject;
import com.nine.travelerscompass.common.search.location.LootrContainerLocationObject;
import com.nine.travelerscompass.common.search.location.LootrMinecartLocationObject;
import com.nine.travelerscompass.compat.lootr.LootrSearchMode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import noobanidus.mods.lootr.common.api.data.DefaultLootFiller;
import noobanidus.mods.lootr.common.api.data.ILootrInfoProvider;
import noobanidus.mods.lootr.common.api.data.LootFiller;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.api.data.inventory.ILootrInventory;
import noobanidus.mods.lootr.common.data.DataStorage;
import noobanidus.mods.lootr.common.entity.LootrChestMinecartEntity;

public class NeoForgeLootrHelper {
    public static List<ILocationObject> minecartMatch(TypedCriteria criteria, SearchOptions options, Entity entity, Level level, BlockPos pos) {
        ArrayList<ILocationObject> ret = new ArrayList<ILocationObject>();
        if (entity instanceof LootrChestMinecartEntity) {
            LootrChestMinecartEntity minecart = (LootrChestMinecartEntity)entity;
            if (criteria.itemCriteria.isEmpty()) {
                return List.of();
            }
            if (!NeoForgeLootrHelper.shouldCheckLootrContainer((ILootrInfoProvider)minecart, options)) {
                return ret;
            }
            ILootrInventory inventory = DataStorage.getInventory((ILootrInfoProvider)minecart, (ServerPlayer)options.player(), (LootFiller)DefaultLootFiller.getInstance());
            if (inventory != null) {
                String id = entity.getType().getDescriptionId();
                for (ItemStack stack : inventory.getInventoryContents()) {
                    Item item = stack.getItem();
                    if (!criteria.itemCriteriaMap.containsKey(item)) continue;
                    ISearchCriterion criterion = criteria.itemCriteriaMap.get(item);
                    ret.add(new LootrMinecartLocationObject(pos.immutable(), criterion.slot(), criterion.priority(), id, item.getDescriptionId(), entity.getUUID()));
                }
            }
        }
        return ret;
    }

    public static List<ILocationObject> matchLootrContainer(TypedCriteria criteria, SearchOptions options, BlockPos pos, BlockState state, BlockEntity be) {
        ArrayList<ILocationObject> ret = new ArrayList<ILocationObject>();
        if (be instanceof ILootrBlockEntity) {
            ILootrBlockEntity lootEntity = (ILootrBlockEntity)be;
            if (criteria.itemCriteria.isEmpty()) {
                return List.of();
            }
            if (!NeoForgeLootrHelper.shouldCheckLootrContainer((ILootrInfoProvider)lootEntity, options)) {
                return ret;
            }
            ILootrInventory inventory = DataStorage.getInventory((ILootrInfoProvider)lootEntity, (ServerPlayer)options.player(), (LootFiller)DefaultLootFiller.getInstance());
            if (inventory != null) {
                ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
                for (ItemStack stack : inventory.getInventoryContents()) {
                    Item item = stack.getItem();
                    if (!criteria.itemCriteriaMap.containsKey(item)) continue;
                    ISearchCriterion criterion = criteria.itemCriteriaMap.get(item);
                    ret.add(new LootrContainerLocationObject(pos.immutable(), criterion.slot(), criterion.priority(), 0, state.getBlock().getDescriptionId(), item.getDescriptionId(), id));
                }
            }
        }
        return ret;
    }

    public static boolean shouldCheckLootrContainer(ILootrInfoProvider iHasOpeners, SearchOptions options) {
        LootrSearchMode searchMode = options.get(CompassComponents.LOOTR_MODE);
        if (iHasOpeners.getActualOpeners() == null) {
            return false;
        }
        boolean opened = iHasOpeners.getActualOpeners().contains(options.getPlayerUUID());
        return switch (searchMode) {
            case LootrSearchMode.ALL -> true;
            case LootrSearchMode.OPENED -> opened;
            case LootrSearchMode.CLOSED -> {
                if (!opened) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }
}

