/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.config.filter;

import com.nine.travelerscompass.client.CompassUI;
import com.nine.travelerscompass.platform.Platform;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;

public sealed interface FilterReason {
    public boolean isAllowed();

    public Component toComponent();

    public record ByEntityType(EntityType<?> type) implements FilterReason
    {
        @Override
        public boolean isAllowed() {
            return false;
        }

        @Override
        public Component toComponent() {
            Component entityName = this.type.getDescription();
            return Component.translatable((String)"tooltip.travelerscompass.config.filter_reason.entity", (Object[])new Object[]{entityName}).withStyle(ChatFormatting.RED);
        }
    }

    public record ByTag(TagKey<Item> tag) implements FilterReason
    {
        @Override
        public boolean isAllowed() {
            return false;
        }

        @Override
        public Component toComponent() {
            return Component.translatable((String)"tooltip.travelerscompass.config.filter_reason.tag", (Object[])new Object[]{this.tag.location().toString()}).withStyle(ChatFormatting.RED);
        }
    }

    public record ByItemId(ResourceLocation id) implements FilterReason
    {
        @Override
        public boolean isAllowed() {
            return false;
        }

        @Override
        public Component toComponent() {
            return CompassUI.FILTER_BY_ITEM_ID;
        }
    }

    public record ByModId(String modId) implements FilterReason
    {
        @Override
        public boolean isAllowed() {
            return false;
        }

        @Override
        public Component toComponent() {
            return Component.translatable((String)"tooltip.travelerscompass.config.filter_reason.mod", (Object[])new Object[]{Platform.PLATFORM.getModName(this.modId)}).withStyle(ChatFormatting.RED);
        }
    }

    public record Allowed() implements FilterReason
    {
        @Override
        public boolean isAllowed() {
            return true;
        }

        @Override
        public Component toComponent() {
            return Component.empty();
        }
    }
}

