/*
 * Decompiled with CFR 0.152.
 */
package com.example.client;

import com.example.client.ItemDetailScreen;
import com.example.client.ItemInfo;
import com.example.client.ItemInfoLoader;
import com.example.mixin.client.HandledScreenAccessor;
import com.example.mixin.client.HandledScreenInvoker;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_490;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_7923;
import net.minecraft.class_9304;

@Environment(value=EnvType.CLIENT)
public class InventoryPanelRenderer {
    private static class_1799 lastHoveredStack = null;
    private static ItemInfo lastHoveredInfo = null;

    public static void openDetailScreen(class_437 currentScreen) {
        if (lastHoveredStack != null && !lastHoveredStack.method_7960()) {
            class_310.method_1551().method_1507((class_437)new ItemDetailScreen(currentScreen, lastHoveredStack, lastHoveredInfo));
        }
    }

    public static void render(class_332 ctx, class_437 screen, int mouseX, int mouseY, float tickDelta) {
        int y;
        int x;
        if (!(screen instanceof class_490)) {
            return;
        }
        if (!(screen instanceof class_465)) {
            return;
        }
        class_465 handled = (class_465)screen;
        int baseWidth = 170;
        int baseHeight = 200;
        int margin = 10;
        int winW = class_310.method_1551().method_22683().method_4486();
        int winH = class_310.method_1551().method_22683().method_4502();
        HandledScreenAccessor acc = (HandledScreenAccessor)handled;
        int invX = acc.getX();
        int invY = acc.getY();
        int invW = acc.getBackgroundWidth();
        int invH = acc.getBackgroundHeight();
        int availableWidth = Math.max(invX - margin * 2, winW - (invX + invW) - margin * 2);
        int availableHeight = Math.max(invY - margin * 2, winH - (invY + invH) - margin * 2);
        int panelWidth = baseWidth;
        int panelHeight = baseHeight;
        if (availableWidth < baseWidth || availableHeight < baseHeight) {
            int minWidth = 150;
            int minHeight = 180;
            panelWidth = Math.max(minWidth, Math.min(baseWidth, availableWidth));
            panelHeight = Math.max(minHeight, Math.min(baseHeight, availableHeight));
        }
        if (invX - margin >= panelWidth + margin) {
            x = invX - panelWidth - margin;
            y = Math.max(margin, Math.min(invY, winH - panelHeight - margin));
        } else if (winW - (invX + invW) - margin >= panelWidth + margin) {
            x = invX + invW + margin;
            y = Math.max(margin, Math.min(invY, winH - panelHeight - margin));
        } else if (winH - (invY + invH) - margin >= panelHeight + margin) {
            x = Math.max(margin, Math.min(winW - panelWidth - margin, invX));
            y = invY + invH + margin;
        } else if (invY - margin >= panelHeight + margin) {
            x = Math.max(margin, Math.min(winW - panelWidth - margin, invX));
            y = invY - panelHeight - margin;
        } else {
            panelWidth = Math.min(130, winW - margin * 2);
            panelHeight = Math.min(150, winH - margin * 2);
            x = margin;
            y = margin;
        }
        InventoryPanelRenderer.fillRounded(ctx, x + 2, y + 2, panelWidth, panelHeight, 8, 0x40000000);
        InventoryPanelRenderer.fillRounded(ctx, x, y, panelWidth, panelHeight, 8, -870704614);
        InventoryPanelRenderer.drawRoundedBorder(ctx, x, y, panelWidth, panelHeight, 8, -2008791996);
        InventoryPanelRenderer.fillRounded(ctx, x + 4, y + 4, panelWidth - 8, 3, 1, -11171585);
        class_1735 slot = null;
        try {
            slot = ((HandledScreenInvoker)handled).invokeGetSlotAt(mouseX, mouseY);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (slot == null) {
            slot = ((HandledScreenAccessor)handled).getFocusedSlot();
        }
        if (slot == null || !slot.method_7681()) {
            return;
        }
        class_1799 stack = slot.method_7677();
        lastHoveredStack = stack.method_7972();
        class_2960 id = class_7923.field_41178.method_10221((Object)stack.method_7909());
        lastHoveredInfo = ItemInfoLoader.get(id);
        int iconSize = 16;
        int iconX = x + (panelWidth - iconSize) / 2;
        int iconY = y + 14;
        ctx.method_51427(stack, iconX, iconY);
        class_2561 name = stack.method_7964();
        int textLeft = x + 10;
        int nameWidth = class_310.method_1551().field_1772.method_27525((class_5348)name);
        int nameX = x + (panelWidth - nameWidth) / 2;
        ctx.method_51439(class_310.method_1551().field_1772, name, nameX, iconY + iconSize + 6, -1, true);
        ItemInfo info = lastHoveredInfo;
        int textX = textLeft;
        int lineY = iconY + iconSize + 20;
        int contentBottom = y + panelHeight - 8;
        int wrapWidth = panelWidth - 20;
        ctx.method_44379(x + 6, y + 6, x + panelWidth - 6, y + panelHeight - 6);
        if (stack.method_7942()) {
            ctx.method_25294(textX, lineY + 3, textX + 2, lineY + 8, -5635841);
            ctx.method_51439(class_310.method_1551().field_1772, (class_2561)class_2561.method_43470((String)"Enchantments:"), textX + 6, lineY, -5635841, false);
            class_9304 enchantments = stack.method_58657();
            int[] currentY = new int[]{lineY += 12};
            enchantments.method_57534().forEach(entry -> {
                class_1887 enchantment = (class_1887)entry.comp_349();
                int level = enchantments.method_57536(entry);
                String enchName = enchantment.comp_2686().getString();
                Object levelStr = level > 1 ? " " + level : "";
                for (class_5481 t : class_310.method_1551().field_1772.method_1728((class_5348)class_2561.method_43470((String)("  \u2022 " + enchName + (String)levelStr)), wrapWidth - 4)) {
                    if (currentY[0] + 10 > contentBottom) {
                        return;
                    }
                    ctx.method_51430(class_310.method_1551().field_1772, t, textX + 4, currentY[0], -3368449, false);
                    currentY[0] = currentY[0] + 10;
                }
            });
            lineY = currentY[0] + 4;
        }
        if (info != null) {
            ctx.method_25294(textX, lineY + 3, textX + 2, lineY + 8, -13210);
            ctx.method_51439(class_310.method_1551().field_1772, (class_2561)class_2561.method_43470((String)"Category:"), textX + 6, lineY, -13210, false);
            lineY += 11;
            for (class_5481 t : class_310.method_1551().field_1772.method_1728((class_5348)class_2561.method_43470((String)info.category), wrapWidth - 8)) {
                if (lineY + 10 > contentBottom) break;
                ctx.method_51430(class_310.method_1551().field_1772, t, textX + 10, lineY, -13210, false);
                lineY += 10;
            }
            ctx.method_25294(textX, (lineY += 3) + 3, textX + 2, lineY + 8, -7807489);
            ctx.method_51439(class_310.method_1551().field_1772, (class_2561)class_2561.method_43470((String)"Origin:"), textX + 6, lineY, -7807489, false);
            lineY += 11;
            for (class_5481 t : class_310.method_1551().field_1772.method_1728((class_5348)class_2561.method_43470((String)info.origin), wrapWidth - 8)) {
                if (lineY + 10 > contentBottom) break;
                ctx.method_51430(class_310.method_1551().field_1772, t, textX + 10, lineY, -7807489, false);
                lineY += 10;
            }
            ctx.method_51439(class_310.method_1551().field_1772, (class_2561)class_2561.method_43470((String)"Description:"), textX, lineY += 3, -5592406, false);
            lineY += 11;
            for (class_5481 t : class_310.method_1551().field_1772.method_1728((class_5348)class_2561.method_43470((String)info.description), wrapWidth - 8)) {
                if (lineY + 10 > contentBottom) break;
                ctx.method_51430(class_310.method_1551().field_1772, t, textX + 4, lineY, -3355444, false);
                lineY += 10;
            }
        }
        ctx.method_44380();
        class_5250 hint = class_2561.method_43470((String)"Press G to show more");
        int hintWidth = class_310.method_1551().field_1772.method_27525((class_5348)hint);
        int hintX = x + (panelWidth - hintWidth) / 2;
        int hintY = y + panelHeight - 8;
        ctx.method_51439(class_310.method_1551().field_1772, (class_2561)hint, hintX, hintY, -10066330, false);
    }

    private static void fillRounded(class_332 ctx, int x, int y, int w, int h, int r, int color) {
        int x2 = x + w;
        int y2 = y + h;
        ctx.method_25294(x + r, y, x2 - r, y2, color);
        ctx.method_25294(x, y + r, x + r, y2 - r, color);
        ctx.method_25294(x2 - r, y + r, x2, y2 - r, color);
        for (int i = 0; i < r; ++i) {
            int width = (int)Math.sqrt(r * r - (r - i) * (r - i));
            ctx.method_25294(x + r - width, y + i, x + r, y + i + 1, color);
            ctx.method_25294(x2 - r, y + i, x2 - r + width, y + i + 1, color);
            ctx.method_25294(x + r - width, y2 - i - 1, x + r, y2 - i, color);
            ctx.method_25294(x2 - r, y2 - i - 1, x2 - r + width, y2 - i, color);
        }
    }

    private static void drawRoundedBorder(class_332 ctx, int x, int y, int w, int h, int r, int color) {
        int x2 = x + w;
        int y2 = y + h;
        ctx.method_25294(x + r, y, x2 - r, y + 1, color);
        ctx.method_25294(x + r, y2 - 1, x2 - r, y2, color);
        ctx.method_25294(x, y + r, x + 1, y2 - r, color);
        ctx.method_25294(x2 - 1, y + r, x2, y2 - r, color);
    }
}

