/*
 * Decompiled with CFR 0.152.
 */
package com.example.client;

import com.example.client.ItemInfo;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public class ItemInfoLoader {
    private static final Gson GSON = new Gson();
    private static final Map<class_2960, ItemInfo> ITEM_INFO = new HashMap<class_2960, ItemInfo>();
    private static final String ITEMS_JSON_PATH = "assets/itempro/items.json";

    public static void init() {
        ITEM_INFO.clear();
        try {
            ClassLoader cl = ItemInfoLoader.class.getClassLoader();
            try (InputStream in = cl.getResourceAsStream(ITEMS_JSON_PATH);){
                if (in == null) {
                    System.err.println("[ItemPro] Could not find items.json at: assets/itempro/items.json");
                    return;
                }
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                    JsonObject root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                    if (root == null) {
                        System.err.println("[ItemPro] Failed to parse items.json");
                        return;
                    }
                    for (Map.Entry e : root.entrySet()) {
                        class_2960 id = class_2960.method_12829((String)((String)e.getKey()));
                        if (id == null) continue;
                        JsonObject obj = ((JsonElement)e.getValue()).getAsJsonObject();
                        String category = obj.has("category") ? obj.get("category").getAsString() : "";
                        String origin = obj.has("origin") ? obj.get("origin").getAsString() : "";
                        String description = obj.has("description") ? obj.get("description").getAsString() : "";
                        ITEM_INFO.put(id, new ItemInfo(category, origin, description));
                    }
                    System.out.println("[ItemPro] Loaded " + ITEM_INFO.size() + " item definitions");
                }
            }
        }
        catch (Exception e) {
            System.err.println("[ItemPro] Error loading items.json: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static ItemInfo get(class_2960 id) {
        return ITEM_INFO.get(id);
    }
}

