/*
 * Decompiled with CFR 0.152.
 */
package com.example.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class ItemProConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("itempro.json");
    private static ItemProConfig INSTANCE = new ItemProConfig();
    public boolean panelEnabled = true;
    public PanelPosition panelPosition = PanelPosition.AUTO;
    public int panelWidth = 170;
    public int panelHeight = 200;
    public float panelOpacity = 0.8f;
    public int detailViewKey = 71;
    public String accentColor = "#5588FF";
    public String categoryColor = "#FFCC66";
    public String originColor = "#88DDFF";
    public String enchantmentColor = "#AA00FF";
    public boolean showEnchantments = true;
    public boolean showCategory = true;
    public boolean showOrigin = true;
    public boolean showDescription = true;

    public static ItemProConfig getInstance() {
        return INSTANCE;
    }

    public static void load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                String json = Files.readString(CONFIG_PATH);
                INSTANCE = (ItemProConfig)GSON.fromJson(json, ItemProConfig.class);
                if (INSTANCE == null) {
                    INSTANCE = new ItemProConfig();
                }
            }
            catch (Exception e) {
                System.err.println("[ItemPro] Failed to load config: " + e.getMessage());
                INSTANCE = new ItemProConfig();
            }
        }
        ItemProConfig.save();
    }

    public static void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            String json = GSON.toJson((Object)INSTANCE);
            Files.writeString(CONFIG_PATH, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            System.err.println("[ItemPro] Failed to save config: " + e.getMessage());
        }
    }

    public int getAccentColorInt() {
        return this.parseColor(this.accentColor, -11171585);
    }

    public int getCategoryColorInt() {
        return this.parseColor(this.categoryColor, -13210);
    }

    public int getOriginColorInt() {
        return this.parseColor(this.originColor, -7807489);
    }

    public int getEnchantmentColorInt() {
        return this.parseColor(this.enchantmentColor, -5635841);
    }

    private int parseColor(String hex, int defaultColor) {
        try {
            if (hex.startsWith("#")) {
                hex = hex.substring(1);
            }
            if (hex.length() == 6) {
                return 0xFF000000 | Integer.parseInt(hex, 16);
            }
            return defaultColor;
        }
        catch (Exception e) {
            return defaultColor;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum PanelPosition {
        AUTO,
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

