/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.block.custom;

import com.mojang.serialization.MapCodec;
import net.luckystudio.spelunkers_charm.block.custom.blaster.BlasterUtil;
import net.luckystudio.spelunkers_charm.block.util.ModBlockStateProperties;
import net.luckystudio.spelunkers_charm.block.util.enums.GeyserState;
import net.luckystudio.spelunkers_charm.block.util.enums.GeyserType;
import net.luckystudio.spelunkers_charm.init.ModSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeyserBlock
extends Block {
    public static final MapCodec<GeyserBlock> CODEC = GeyserBlock.simpleCodec(GeyserBlock::new);
    public static final EnumProperty<GeyserState> GEYSER_STATE = ModBlockStateProperties.GEYSER_STATE;
    public static final EnumProperty<GeyserType> GEYSER_TYPE = ModBlockStateProperties.GEYSER_TYPE;
    public static final IntegerProperty DURATION = IntegerProperty.create((String)"duration", (int)0, (int)100);

    public GeyserBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(GEYSER_STATE, (Comparable)((Object)GeyserState.DORMANT))).setValue(GEYSER_TYPE, (Comparable)((Object)GeyserType.NONE))).setValue((Property)DURATION, (Comparable)Integer.valueOf(0)));
    }

    @NotNull
    protected MapCodec<? extends Block> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{GEYSER_STATE, GEYSER_TYPE, DURATION});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState blockState = this.defaultBlockState();
        return (BlockState)blockState.setValue(GEYSER_TYPE, (Comparable)((Object)GeyserBlock.determineType(pContext.getLevel().getBlockState(pContext.getClickedPos().below()))));
    }

    protected BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        BlockPos blockPosBelow = pPos.below();
        return (BlockState)pState.setValue(GEYSER_TYPE, (Comparable)((Object)GeyserBlock.determineType(pLevel.getBlockState(blockPosBelow))));
    }

    private static GeyserType determineType(BlockState neighborState) {
        if (neighborState.getBlock() == Blocks.LAVA) {
            return GeyserType.LAVA;
        }
        if (neighborState.getBlock() == Blocks.WATER) {
            return GeyserType.WATER;
        }
        return GeyserType.NONE;
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        Item item = pStack.getItem();
        if (item == Items.FLINT_AND_STEEL || item == Items.FIRE_CHARGE) {
            if (item == Items.FLINT_AND_STEEL) {
                pStack.hurtAndBreak(1, (LivingEntity)pPlayer, LivingEntity.getSlotForHand((InteractionHand)pHand));
            } else {
                pStack.shrink(1);
            }
            this.tryAndStartCharging(pLevel, pPos, pState);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(pStack, pState, pLevel, pPos, pPlayer, pHand, pHitResult);
    }

    protected boolean isRandomlyTicking(BlockState pState) {
        return pState.getValue(GEYSER_STATE) == GeyserState.DORMANT && pState.getValue(GEYSER_TYPE) != GeyserType.NONE;
    }

    protected void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        this.tryAndStartCharging((Level)pLevel, pPos, pState);
        super.randomTick(pState, pLevel, pPos, pRandom);
    }

    public void tryAndStartCharging(Level world, BlockPos pos, BlockState state) {
        if (world.getBlockState(pos.below()).getBlock() == Blocks.LAVA || world.getBlockState(pos.below()).getBlock() == Blocks.WATER) {
            world.setBlock(pos, (BlockState)((BlockState)state.setValue(GEYSER_STATE, (Comparable)((Object)GeyserState.CHARGING))).setValue((Property)DURATION, (Comparable)Integer.valueOf(0)), 3);
            world.playSound(null, pos, ModSoundEvents.GEYSER_CHARGE.get(), SoundSource.BLOCKS, 1.0f, 0.5f);
            world.scheduleTick(pos, (Block)this, 1);
        }
    }

    protected void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.tick(pState, pLevel, pPos, pRandom);
        int duration = (Integer)pState.getValue((Property)DURATION);
        GeyserState geyserState = (GeyserState)((Object)pState.getValue(GEYSER_STATE));
        switch (geyserState) {
            case CHARGING: {
                this.handleChargingState(pState, pLevel, pPos, duration);
                break;
            }
            case ERUPTING: {
                this.handleActiveState(pState, pLevel, pPos, duration);
                break;
            }
        }
    }

    private void handleChargingState(BlockState state, ServerLevel serverLevel, BlockPos pos, int duration) {
        if (duration < 60) {
            serverLevel.setBlock(pos, (BlockState)state.setValue((Property)DURATION, (Comparable)Integer.valueOf(duration + 1)), 3);
        } else {
            this.start(state, serverLevel, pos);
        }
        serverLevel.scheduleTick(pos, (Block)this, 1);
    }

    private void start(BlockState state, ServerLevel serverWorld, BlockPos pos) {
        serverWorld.setBlock(pos, (BlockState)((BlockState)state.setValue(GEYSER_STATE, (Comparable)((Object)GeyserState.ERUPTING))).setValue((Property)DURATION, (Comparable)Integer.valueOf(0)), 3);
        double xx = (double)pos.getX() + 0.5;
        double yy = (double)pos.getY() + 1.1;
        double zz = (double)pos.getZ() + 0.5;
        int particleCount = 20;
        double speed = 0.1;
        GeyserType geyserType = (GeyserType)((Object)state.getValue(GEYSER_TYPE));
        if (geyserType == GeyserType.LAVA) {
            serverWorld.playSound(null, xx, yy, zz, (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.BLOCKS, 0.5f, 0.1f);
            serverWorld.sendParticles((ParticleOptions)ParticleTypes.LAVA, xx, yy, zz, 16, 0.0, 0.0, 0.0, 0.5);
            this.spawnParticleRing(serverWorld, xx, yy, zz, particleCount, speed, ParticleTypes.CAMPFIRE_COSY_SMOKE);
        } else if (geyserType == GeyserType.WATER) {
            serverWorld.playSound(null, xx, yy, zz, ModSoundEvents.GEYSER_ERUPT_WATER.get(), SoundSource.BLOCKS, 0.5f, 0.1f);
            this.spawnParticleRing(serverWorld, xx, yy, zz, particleCount, speed, ParticleTypes.CLOUD);
        }
    }

    private void spawnParticleRing(ServerLevel world, double x, double y, double z, int count, double speed, SimpleParticleType particleType) {
        for (int i = 0; i < count; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)count;
            double xSpeed = Math.cos(angle) * speed;
            double zSpeed = Math.sin(angle) * speed;
            world.sendParticles((ParticleOptions)particleType, x, y, z, 0, xSpeed, 0.0, zSpeed, 0.5);
        }
    }

    private void handleActiveState(BlockState state, ServerLevel level, BlockPos pos, int duration) {
        GeyserType geyserType = (GeyserType)((Object)state.getValue(GEYSER_TYPE));
        if (duration < 100) {
            BlasterUtil.shoot((Level)level, pos, geyserType, Direction.UP);
            level.setBlock(pos, (BlockState)state.setValue((Property)DURATION, (Comparable)Integer.valueOf(duration + 1)), 3);
            level.scheduleTick(pos, (Block)this, 1);
        } else {
            level.setBlock(pos, (BlockState)((BlockState)state.setValue(GEYSER_STATE, (Comparable)((Object)GeyserState.DORMANT))).setValue((Property)DURATION, (Comparable)Integer.valueOf(0)), 3);
        }
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        SimpleParticleType particleEffect;
        super.animateTick(pState, pLevel, pPos, pRandom);
        if (pState.getValue(GEYSER_TYPE) != GeyserType.NONE && pState.getValue(GEYSER_STATE) == GeyserState.DORMANT && (particleEffect = this.getAmbientParticleEffect(pState)) != null) {
            for (int i = 0; i < 3; ++i) {
                double d = (double)pPos.getX() + pRandom.nextDouble();
                double e = (double)pPos.getY() + pRandom.nextDouble() * 0.5 + 1.0;
                double f = (double)pPos.getZ() + pRandom.nextDouble();
                pLevel.addAlwaysVisibleParticle((ParticleOptions)particleEffect, true, d, e, f, 0.0, 0.0, 0.0);
            }
        }
    }

    private SimpleParticleType getAmbientParticleEffect(BlockState state) {
        GeyserType geyserType = (GeyserType)((Object)state.getValue(GEYSER_TYPE));
        return switch (geyserType) {
            case GeyserType.LAVA -> ParticleTypes.LARGE_SMOKE;
            case GeyserType.WATER -> ParticleTypes.CLOUD;
            default -> null;
        };
    }
}

