/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.block.custom;

import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.luckystudio.spelunkers_charm.init.ModBlocks;
import net.luckystudio.spelunkers_charm.init.ModParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ModPointedBlock
extends PointedDripstoneBlock {
    private static final VoxelShape REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public ModPointedBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TIP_DIRECTION, THICKNESS, WATERLOGGED});
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return ModPointedBlock.isValidPointedDripstonePlacement(level, pos, (Direction)state.getValue((Property)TIP_DIRECTION));
    }

    protected BlockState updateShape(BlockState state, Direction p_direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (p_direction != Direction.UP && p_direction != Direction.DOWN) {
            return state;
        }
        Direction direction = (Direction)state.getValue((Property)TIP_DIRECTION);
        if (direction == Direction.DOWN && level.getBlockTicks().hasScheduledTick(pos, (Object)this)) {
            return state;
        }
        if (p_direction == direction.getOpposite() && !this.canSurvive(state, (LevelReader)level, pos)) {
            if (direction == Direction.DOWN) {
                level.scheduleTick(pos, (Block)this, 2);
            } else {
                level.scheduleTick(pos, (Block)this, 1);
            }
            return state;
        }
        boolean flag = state.getValue((Property)THICKNESS) == DripstoneThickness.TIP_MERGE;
        DripstoneThickness dripstonethickness = ModPointedBlock.calculateDripstoneThickness((LevelReader)level, pos, direction, flag);
        return (BlockState)state.setValue((Property)THICKNESS, (Comparable)dripstonethickness);
    }

    protected void onProjectileHit(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        BlockPos blockpos;
        if (!level.isClientSide && projectile.mayInteract(level, blockpos = hit.getBlockPos()) && projectile.mayBreak(level) && projectile instanceof ThrownTrident && projectile.getDeltaMovement().length() > 0.6) {
            level.destroyBlock(blockpos, true);
        }
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (state.getValue((Property)TIP_DIRECTION) == Direction.UP && state.getValue((Property)THICKNESS) == DripstoneThickness.TIP) {
            entity.causeFallDamage(fallDistance + 2.0f, 2.0f, level.damageSources().stalagmite());
        } else {
            super.fallOn(level, state, pos, entity, fallDistance);
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        float f;
        if (ModPointedBlock.canDrip(state) && !((f = random.nextFloat()) > 0.12f)) {
            ModPointedBlock.getFluidAboveStalactite(level, pos, state).filter(p_221848_ -> f < 0.02f || ModPointedBlock.canFillCauldron(p_221848_.fluid)).ifPresent(p_221881_ -> ModPointedBlock.spawnDripParticle(level, pos, state, p_221881_.fluid));
        }
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (ModPointedBlock.isStalagmite(state) && !this.canSurvive(state, (LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        } else {
            ModPointedBlock.spawnFallingStalactite(state, level, pos);
        }
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        ModPointedBlock.maybeTransferFluid((BlockState)state, (ServerLevel)level, (BlockPos)pos, (float)random.nextFloat());
        if (random.nextFloat() < 0.011377778f && ModPointedBlock.isStalactiteStartPos(state, (LevelReader)level, pos)) {
            ModPointedBlock.growStalactiteOrStalagmiteIfPossible(state, level, pos, random);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction;
        BlockPos blockpos;
        Level levelaccessor = context.getLevel();
        Direction direction1 = ModPointedBlock.calculateTipDirection((LevelReader)levelaccessor, blockpos = context.getClickedPos(), direction = context.getNearestLookingVerticalDirection().getOpposite());
        if (direction1 == null) {
            return null;
        }
        boolean flag = !context.isSecondaryUseActive();
        DripstoneThickness dripstonethickness = ModPointedBlock.calculateDripstoneThickness((LevelReader)levelaccessor, blockpos, direction1, flag);
        return dripstonethickness == null ? null : (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TIP_DIRECTION, (Comparable)direction1)).setValue((Property)THICKNESS, (Comparable)dripstonethickness)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.getFluidState(blockpos).getType() == Fluids.WATER));
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.empty();
    }

    protected boolean isCollisionShapeFullBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    protected float getMaxHorizontalOffset() {
        return 0.125f;
    }

    public void onBrokenAfterFall(Level level, BlockPos pos, FallingBlockEntity fallingBlock) {
        if (!fallingBlock.isSilent()) {
            level.levelEvent(1045, pos, 0);
            ModParticleTypes.spawnParticlesToServer(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.25, (double)pos.getZ() + 0.5, 10, 0.1, 0.1, 0.1, 0.05, new ParticleOptions[]{ParticleTypes.SNOWFLAKE});
        }
    }

    public DamageSource getFallDamageSource(Entity entity) {
        return entity.damageSources().fallingStalactite(entity);
    }

    private static void spawnFallingStalactite(BlockState state, ServerLevel level, BlockPos pos) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.mutable();
        BlockState blockstate = state;
        while (ModPointedBlock.isStalactite(blockstate)) {
            FallingBlockEntity fallingblockentity = FallingBlockEntity.fall((Level)level, (BlockPos)blockpos$mutableblockpos, (BlockState)blockstate);
            if (ModPointedBlock.isTip(blockstate, true)) {
                int i = Math.max(1 + pos.getY() - blockpos$mutableblockpos.getY(), 6);
                float f = 1.0f * (float)i;
                fallingblockentity.setHurtsEntities(f, 40);
                break;
            }
            blockpos$mutableblockpos.move(Direction.DOWN);
            blockstate = level.getBlockState((BlockPos)blockpos$mutableblockpos);
        }
    }

    @VisibleForTesting
    public static void growStalactiteOrStalagmiteIfPossible(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockState blockstate2;
        BlockPos blockpos;
        BlockState blockstate1;
        BlockState blockstate = level.getBlockState(pos.above(1));
        if (ModPointedBlock.canGrow(blockstate, blockstate1 = level.getBlockState(pos.above(2))) && (blockpos = ModPointedBlock.findTip(state, (LevelAccessor)level, pos, 7, false)) != null && ModPointedBlock.canDrip(blockstate2 = level.getBlockState(blockpos)) && ModPointedBlock.canTipGrow(blockstate2, level, blockpos)) {
            if (random.nextBoolean()) {
                ModPointedBlock.grow(level, blockpos, Direction.DOWN);
            } else {
                ModPointedBlock.growStalagmiteBelow(level, blockpos);
            }
        }
    }

    private static void growStalagmiteBelow(ServerLevel level, BlockPos pos) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.mutable();
        for (int i = 0; i < 10; ++i) {
            blockpos$mutableblockpos.move(Direction.DOWN);
            BlockState blockstate = level.getBlockState((BlockPos)blockpos$mutableblockpos);
            if (!blockstate.getFluidState().isEmpty()) {
                return;
            }
            if (ModPointedBlock.isUnmergedTipWithDirection(blockstate, Direction.UP) && ModPointedBlock.canTipGrow(blockstate, level, (BlockPos)blockpos$mutableblockpos)) {
                ModPointedBlock.grow(level, (BlockPos)blockpos$mutableblockpos, Direction.UP);
                return;
            }
            if (ModPointedBlock.isValidPointedDripstonePlacement((LevelReader)level, (BlockPos)blockpos$mutableblockpos, Direction.UP) && !level.isWaterAt(blockpos$mutableblockpos.below())) {
                ModPointedBlock.grow(level, blockpos$mutableblockpos.below(), Direction.UP);
                return;
            }
            if (ModPointedBlock.canDripThrough((BlockGetter)level, (BlockPos)blockpos$mutableblockpos, blockstate)) continue;
            return;
        }
    }

    private static void grow(ServerLevel server, BlockPos pos, Direction direction) {
        BlockPos blockpos = pos.relative(direction);
        BlockState blockstate = server.getBlockState(blockpos);
        if (ModPointedBlock.isUnmergedTipWithDirection(blockstate, direction.getOpposite())) {
            ModPointedBlock.createMergedTips(blockstate, (LevelAccessor)server, blockpos);
        } else if (blockstate.isAir() || blockstate.is(Blocks.WATER)) {
            ModPointedBlock.createDripstone((LevelAccessor)server, blockpos, direction, DripstoneThickness.TIP);
        }
    }

    private static void createDripstone(LevelAccessor level, BlockPos pos, Direction direction, DripstoneThickness thickness) {
        BlockState blockstate = (BlockState)((BlockState)((BlockState)((Block)ModBlocks.ICICLE.get()).defaultBlockState().setValue((Property)TIP_DIRECTION, (Comparable)direction)).setValue((Property)THICKNESS, (Comparable)thickness)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos).getType() == Fluids.WATER));
        level.setBlock(pos, blockstate, 3);
    }

    private static void createMergedTips(BlockState state, LevelAccessor level, BlockPos pos) {
        BlockPos blockpos;
        BlockPos blockpos1;
        if (state.getValue((Property)TIP_DIRECTION) == Direction.UP) {
            blockpos1 = pos;
            blockpos = pos.above();
        } else {
            blockpos = pos;
            blockpos1 = pos.below();
        }
        ModPointedBlock.createDripstone(level, blockpos, Direction.DOWN, DripstoneThickness.TIP_MERGE);
        ModPointedBlock.createDripstone(level, blockpos1, Direction.UP, DripstoneThickness.TIP_MERGE);
    }

    private static void spawnDripParticle(Level level, BlockPos pos, BlockState state, Fluid p_fluid) {
        SimpleParticleType particleoptions;
        Vec3 vec3 = state.getOffset((BlockGetter)level, pos);
        double d1 = (double)pos.getX() + 0.5 + vec3.x;
        double d2 = (double)((float)(pos.getY() + 1) - 0.6875f) - 0.0625;
        double d3 = (double)pos.getZ() + 0.5 + vec3.z;
        Fluid fluid = ModPointedBlock.getDripFluid(level, p_fluid);
        Object object = particleoptions = fluid.getFluidType().getDripInfo() != null ? fluid.getFluidType().getDripInfo().dripParticle() : ParticleTypes.DRIPPING_DRIPSTONE_WATER;
        if (particleoptions != null) {
            level.addParticle((ParticleOptions)particleoptions, d1, d2, d3, 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    private static BlockPos findTip(BlockState state, LevelAccessor level, BlockPos pos, int maxIterations, boolean isTipMerge) {
        if (ModPointedBlock.isTip(state, isTipMerge)) {
            return pos;
        }
        Direction direction = (Direction)state.getValue((Property)TIP_DIRECTION);
        BiPredicate<BlockPos, BlockState> bipredicate = (p_202023_, p_202024_) -> p_202024_.is(ModBlocks.ICICLE) && p_202024_.getValue((Property)TIP_DIRECTION) == direction;
        return ModPointedBlock.findBlockVertical(level, pos, direction.getAxisDirection(), bipredicate, p_154168_ -> ModPointedBlock.isTip(p_154168_, isTipMerge), maxIterations).orElse(null);
    }

    @Nullable
    private static Direction calculateTipDirection(LevelReader level, BlockPos pos, Direction dir) {
        Direction direction;
        if (ModPointedBlock.isValidPointedDripstonePlacement(level, pos, dir)) {
            direction = dir;
        } else {
            if (!ModPointedBlock.isValidPointedDripstonePlacement(level, pos, dir.getOpposite())) {
                return null;
            }
            direction = dir.getOpposite();
        }
        return direction;
    }

    private static DripstoneThickness calculateDripstoneThickness(LevelReader level, BlockPos pos, Direction dir, boolean isTipMerge) {
        Direction direction = dir.getOpposite();
        BlockState blockstate = level.getBlockState(pos.relative(dir));
        if (ModPointedBlock.isPointedDripstoneWithDirection(blockstate, direction)) {
            return !isTipMerge && blockstate.getValue((Property)THICKNESS) != DripstoneThickness.TIP_MERGE ? DripstoneThickness.TIP : DripstoneThickness.TIP_MERGE;
        }
        if (!ModPointedBlock.isPointedDripstoneWithDirection(blockstate, dir)) {
            return DripstoneThickness.TIP;
        }
        DripstoneThickness dripstonethickness = (DripstoneThickness)blockstate.getValue((Property)THICKNESS);
        if (dripstonethickness != DripstoneThickness.TIP && dripstonethickness != DripstoneThickness.TIP_MERGE) {
            BlockState blockstate1 = level.getBlockState(pos.relative(direction));
            return !ModPointedBlock.isPointedDripstoneWithDirection(blockstate1, dir) ? DripstoneThickness.BASE : DripstoneThickness.MIDDLE;
        }
        return DripstoneThickness.FRUSTUM;
    }

    public static boolean canDrip(BlockState state) {
        return ModPointedBlock.isStalactite(state) && state.getValue((Property)THICKNESS) == DripstoneThickness.TIP && (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    private static boolean canTipGrow(BlockState state, ServerLevel level, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)TIP_DIRECTION);
        BlockPos blockpos = pos.relative(direction);
        BlockState blockstate = level.getBlockState(blockpos);
        if (!blockstate.getFluidState().isEmpty()) {
            return false;
        }
        return blockstate.isAir() ? true : ModPointedBlock.isUnmergedTipWithDirection(blockstate, direction.getOpposite());
    }

    private static Optional<BlockPos> findRootBlock(Level level, BlockPos pos, BlockState state, int maxIterations) {
        Direction direction = (Direction)state.getValue((Property)TIP_DIRECTION);
        BiPredicate<BlockPos, BlockState> bipredicate = (p_202015_, p_202016_) -> p_202016_.is(ModBlocks.ICICLE) && p_202016_.getValue((Property)TIP_DIRECTION) == direction;
        return ModPointedBlock.findBlockVertical((LevelAccessor)level, pos, direction.getOpposite().getAxisDirection(), bipredicate, p_154245_ -> !p_154245_.is(ModBlocks.ICICLE), maxIterations);
    }

    private static boolean isValidPointedDripstonePlacement(LevelReader level, BlockPos pos, Direction dir) {
        BlockPos blockpos = pos.relative(dir.getOpposite());
        BlockState blockstate = level.getBlockState(blockpos);
        return blockstate.isFaceSturdy((BlockGetter)level, blockpos, dir) || ModPointedBlock.isPointedDripstoneWithDirection(blockstate, dir);
    }

    private static boolean isTip(BlockState state, boolean isTipMerge) {
        if (!state.is(ModBlocks.ICICLE)) {
            return false;
        }
        DripstoneThickness dripstonethickness = (DripstoneThickness)state.getValue((Property)THICKNESS);
        return dripstonethickness == DripstoneThickness.TIP || isTipMerge && dripstonethickness == DripstoneThickness.TIP_MERGE;
    }

    private static boolean isUnmergedTipWithDirection(BlockState state, Direction dir) {
        return ModPointedBlock.isTip(state, false) && state.getValue((Property)TIP_DIRECTION) == dir;
    }

    private static boolean isStalactite(BlockState state) {
        return ModPointedBlock.isPointedDripstoneWithDirection(state, Direction.DOWN);
    }

    private static boolean isStalagmite(BlockState state) {
        return ModPointedBlock.isPointedDripstoneWithDirection(state, Direction.UP);
    }

    private static boolean isStalactiteStartPos(BlockState state, LevelReader level, BlockPos pos) {
        return ModPointedBlock.isStalactite(state) && !level.getBlockState(pos.above()).is(ModBlocks.ICICLE);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    private static boolean isPointedDripstoneWithDirection(BlockState state, Direction dir) {
        return state.is(ModBlocks.ICICLE) && state.getValue((Property)TIP_DIRECTION) == dir;
    }

    private static Optional<FluidInfo> getFluidAboveStalactite(Level level, BlockPos pos, BlockState state) {
        return !ModPointedBlock.isStalactite(state) ? Optional.empty() : ModPointedBlock.findRootBlock(level, pos, state, 11).map(p_221876_ -> {
            BlockPos blockpos = p_221876_.above();
            BlockState blockstate = level.getBlockState(blockpos);
            Object fluid = blockstate.is(Blocks.MUD) && !level.dimensionType().ultraWarm() ? Fluids.WATER : level.getFluidState(blockpos).getType();
            return new FluidInfo(blockpos, (Fluid)fluid, blockstate);
        });
    }

    private static boolean canFillCauldron(Fluid fluid) {
        return fluid.getFluidType().getDripInfo() != null;
    }

    private static boolean canGrow(BlockState dripstoneState, BlockState state) {
        return dripstoneState.is(ModBlocks.ICICLE) && state.is(Blocks.WATER) && state.getFluidState().isSource();
    }

    private static Fluid getDripFluid(Level level, Fluid fluid) {
        if (fluid.isSame(Fluids.EMPTY)) {
            return level.dimensionType().ultraWarm() ? Fluids.LAVA : Fluids.WATER;
        }
        return fluid;
    }

    private static Optional<BlockPos> findBlockVertical(LevelAccessor level, BlockPos pos, Direction.AxisDirection axis, BiPredicate<BlockPos, BlockState> positionalStatePredicate, Predicate<BlockState> statePredicate, int maxIterations) {
        Direction direction = Direction.get((Direction.AxisDirection)axis, (Direction.Axis)Direction.Axis.Y);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.mutable();
        for (int i = 1; i < maxIterations; ++i) {
            blockpos$mutableblockpos.move(direction);
            BlockState blockstate = level.getBlockState((BlockPos)blockpos$mutableblockpos);
            if (statePredicate.test(blockstate)) {
                return Optional.of(blockpos$mutableblockpos.immutable());
            }
            if (!level.isOutsideBuildHeight(blockpos$mutableblockpos.getY()) && positionalStatePredicate.test((BlockPos)blockpos$mutableblockpos, blockstate)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static boolean canDripThrough(BlockGetter level, BlockPos pos, BlockState state) {
        if (state.isAir()) {
            return true;
        }
        if (state.isSolidRender(level, pos)) {
            return false;
        }
        if (!state.getFluidState().isEmpty()) {
            return false;
        }
        VoxelShape voxelshape = state.getCollisionShape(level, pos);
        return !Shapes.joinIsNotEmpty((VoxelShape)REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK, (VoxelShape)voxelshape, (BooleanOp)BooleanOp.AND);
    }

    record FluidInfo(BlockPos pos, Fluid fluid, BlockState sourceState) {
    }
}

