/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.block.custom.boulder.entity;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.luckystudio.spelunkers_charm.block.custom.boulder.BoulderBlock;
import net.luckystudio.spelunkers_charm.block.custom.boulder.BoulderType;
import net.luckystudio.spelunkers_charm.block.custom.boulder.HangingType;
import net.luckystudio.spelunkers_charm.init.ModEntityType;
import net.luckystudio.spelunkers_charm.init.ModParticleTypes;
import net.luckystudio.spelunkers_charm.init.ModSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Boulder
extends VehicleEntity {
    private static final EntityDataAccessor<Integer> BOULDER_TYPE = SynchedEntityData.defineId(Boulder.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int onGroundTicks = 0;

    public Boulder(EntityType<Boulder> boulderEntityType, Level level) {
        super(boulderEntityType, level);
    }

    public Boulder(Level level, BlockPos pos) {
        super(ModEntityType.BOULDER.get(), level);
        this.setPos((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5);
        this.xo = (double)pos.getX() + 0.5;
        this.yo = pos.getY();
        this.zo = (double)pos.getZ() + 0.5;
        this.setOnGround(false);
    }

    protected Item getDropItem() {
        return Items.STONE;
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BOULDER_TYPE, (Object)BoulderType.STONE.ordinal());
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains("boulderType", 8)) {
            this.setBoulderType(BoulderType.byName(compound.getString("boulderType")));
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("boulderType", ((Integer)this.entityData.get(BOULDER_TYPE)).intValue());
    }

    public BoulderType getBoulderType() {
        return BoulderType.byId((Integer)this.entityData.get(BOULDER_TYPE));
    }

    public void setBoulderType(BoulderType direction) {
        this.entityData.set(BOULDER_TYPE, (Object)direction.ordinal());
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public void tick() {
        super.tick();
        this.applyGravity();
        this.move(MoverType.SELF, this.getDeltaMovement());
        double snappedX = (double)Mth.floor((double)this.getX()) + 0.5;
        double snappedZ = (double)Mth.floor((double)this.getZ()) + 0.5;
        this.setPos(snappedX, this.getY(), snappedZ);
        if (this.onGround() && this.getDeltaMovement().y == 0.0) {
            ++this.onGroundTicks;
        }
        if (this.onGroundTicks >= 5) {
            this.placeBoulder();
        }
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource source) {
        float particleSpread = Mth.clamp((float)(fallDistance * 0.1f / 2.0f), (float)0.1f, (float)5.0f);
        ModParticleTypes.spawnSquareBorderParticles(this.level(), (ParticleOptions)ParticleTypes.DUST_PLUME, this.blockPosition(), this.getBbWidth() / 2.0f, (int)(20.0f * this.getBbWidth()), particleSpread);
        this.playSound(ModSoundEvents.BOULDER_LAND.get(), 1.0f, 1.0f);
        AtomicBoolean foundBlock = new AtomicBoolean(false);
        if (!this.level().isClientSide) {
            BlockPos center = this.blockPosition();
            Vec3 firstPos = new Vec3((double)(center.getX() - 2), (double)center.getY(), (double)(center.getZ() - 2));
            Vec3 secondPos = new Vec3((double)(center.getX() + 3), (double)(center.getY() + 1), (double)(center.getZ() + 3));
            AABB damageArea = new AABB(firstPos, secondPos);
            List entities = this.level().getEntitiesOfClass(Entity.class, damageArea, livingEntity -> livingEntity != this);
            for (Entity entity : entities) {
                entity.hurt(this.damageSources().source(DamageTypes.FALLING_BLOCK), fallDistance * 1.5f);
            }
            for (int dx = -2; dx <= 2; ++dx) {
                for (int dz = -2; dz <= 2; ++dz) {
                    BlockPos target = center.below().offset(dx, 0, dz);
                    BlockState state = this.level().getBlockState(target);
                    float hardness = state.getDestroySpeed((BlockGetter)this.level(), target);
                    if (hardness >= 0.0f && hardness <= fallDistance / 2.0f) {
                        this.level().destroyBlock(target, true);
                        continue;
                    }
                    if (dx < -1 || dx > 1 || dz < -1 || dz > 1) continue;
                    foundBlock.set(true);
                }
            }
            if (foundBlock.get()) {
                this.placeBoulder();
            }
        }
        return super.causeFallDamage(fallDistance, multiplier, source);
    }

    private void placeBoulder() {
        BoulderBlock.placeBoulder(this.level(), this.blockPosition(), this.getBoulderType(), HangingType.NONE);
        this.discard();
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (!this.level().isClientSide) {
            player.startRiding((Entity)this);
        }
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
    }

    protected double getDefaultGravity() {
        return 0.08;
    }

    public boolean isPickable() {
        return true;
    }

    public boolean canBeHitByProjectile() {
        return true;
    }

    protected boolean canRide(Entity vehicle) {
        return true;
    }
}

