/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.block.custom.web_vein;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.luckystudio.spelunkers_charm.block.custom.web_vein.WebVeinBehavior;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.SculkSpreader;
import net.minecraft.world.level.block.SculkVeinBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;

public class WebSpreader {
    public static final int MAX_GROWTH_RATE_RADIUS = 24;
    public static final int MAX_CHARGE = 1000;
    public static final float MAX_DECAY_FACTOR = 0.5f;
    private static final int MAX_CURSORS = 32;
    public static final int SHRIEKER_PLACEMENT_RATE = 11;
    final boolean isWorldGeneration;
    private final TagKey<Block> replaceableBlocks;
    private final int growthSpawnCost;
    private final int noGrowthRadius;
    private final int chargeDecayRate;
    private final int additionalDecayRate;
    private List<ChargeCursor> cursors = new ArrayList<ChargeCursor>();
    private static final Logger LOGGER = LogUtils.getLogger();

    public WebSpreader(boolean isWorldGeneration, TagKey<Block> replaceableBlocks, int growthSpawnCoat, int noGrowthRadius, int chargeDecayRate, int additionalDecayRate) {
        this.isWorldGeneration = isWorldGeneration;
        this.replaceableBlocks = replaceableBlocks;
        this.growthSpawnCost = growthSpawnCoat;
        this.noGrowthRadius = noGrowthRadius;
        this.chargeDecayRate = chargeDecayRate;
        this.additionalDecayRate = additionalDecayRate;
    }

    public static SculkSpreader createLevelSpreader() {
        return new SculkSpreader(false, BlockTags.SCULK_REPLACEABLE, 10, 4, 10, 5);
    }

    public static WebSpreader createWorldGenSpreader() {
        return new WebSpreader(true, (TagKey<Block>)BlockTags.SCULK_REPLACEABLE_WORLD_GEN, 50, 1, 5, 10);
    }

    public TagKey<Block> replaceableBlocks() {
        return this.replaceableBlocks;
    }

    public int growthSpawnCost() {
        return this.growthSpawnCost;
    }

    public int noGrowthRadius() {
        return this.noGrowthRadius;
    }

    public int chargeDecayRate() {
        return this.chargeDecayRate;
    }

    public int additionalDecayRate() {
        return this.additionalDecayRate;
    }

    public boolean isWorldGeneration() {
        return this.isWorldGeneration;
    }

    @VisibleForTesting
    public List<ChargeCursor> getCursors() {
        return this.cursors;
    }

    public void clear() {
        this.cursors.clear();
    }

    public void load(CompoundTag tag) {
        if (tag.contains("cursors", 9)) {
            this.cursors.clear();
            List list = ChargeCursor.CODEC.listOf().parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)tag.getList("cursors", 10))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseGet(ArrayList::new);
            int i = Math.min(list.size(), 32);
            for (int j = 0; j < i; ++j) {
                this.addCursor((ChargeCursor)list.get(j));
            }
        }
    }

    public void save(CompoundTag tag) {
        ChargeCursor.CODEC.listOf().encodeStart((DynamicOps)NbtOps.INSTANCE, this.cursors).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_222273_ -> tag.put("cursors", p_222273_));
    }

    public void addCursors(BlockPos pos, int charge) {
        while (charge > 0) {
            int i = Math.min(charge, 1000);
            this.addCursor(new ChargeCursor(pos, i));
            charge -= i;
        }
    }

    private void addCursor(ChargeCursor cursor) {
        if (this.cursors.size() < 32) {
            this.cursors.add(cursor);
        }
    }

    public void updateCursors(LevelAccessor level, BlockPos pos, RandomSource random, boolean shouldConvertBlocks) {
        if (!this.cursors.isEmpty()) {
            ArrayList<ChargeCursor> list = new ArrayList<ChargeCursor>();
            HashMap<BlockPos, ChargeCursor> map = new HashMap<BlockPos, ChargeCursor>();
            Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
            for (ChargeCursor sculkspreader$chargecursor : this.cursors) {
                sculkspreader$chargecursor.update(level, pos, random, this, shouldConvertBlocks);
                if (sculkspreader$chargecursor.charge <= 0) {
                    level.levelEvent(3006, sculkspreader$chargecursor.getPos(), 0);
                    continue;
                }
                BlockPos blockpos = sculkspreader$chargecursor.getPos();
                object2intmap.computeInt((Object)blockpos, (p_222264_, p_222265_) -> (p_222265_ == null ? 0 : p_222265_) + sculkspreader$chargecursor.charge);
                ChargeCursor sculkspreader$chargecursor1 = (ChargeCursor)map.get(blockpos);
                if (sculkspreader$chargecursor1 == null) {
                    map.put(blockpos, sculkspreader$chargecursor);
                    list.add(sculkspreader$chargecursor);
                    continue;
                }
                if (!this.isWorldGeneration() && sculkspreader$chargecursor.charge + sculkspreader$chargecursor1.charge <= 1000) {
                    sculkspreader$chargecursor1.mergeWith(sculkspreader$chargecursor);
                    continue;
                }
                list.add(sculkspreader$chargecursor);
                if (sculkspreader$chargecursor.charge >= sculkspreader$chargecursor1.charge) continue;
                map.put(blockpos, sculkspreader$chargecursor);
            }
            for (Object2IntMap.Entry entry : object2intmap.object2IntEntrySet()) {
                Set<Direction> collection;
                BlockPos blockpos1 = (BlockPos)entry.getKey();
                int k = entry.getIntValue();
                ChargeCursor sculkspreader$chargecursor2 = (ChargeCursor)map.get(blockpos1);
                Set<Direction> set = collection = sculkspreader$chargecursor2 == null ? null : sculkspreader$chargecursor2.getFacingData();
                if (k <= 0 || collection == null) continue;
                int i = (int)(Math.log1p(k) / (double)2.3f) + 1;
                int j = (i << 6) + MultifaceBlock.pack(collection);
                level.levelEvent(3006, blockpos1, j);
            }
            this.cursors = list;
        }
    }

    public static class ChargeCursor {
        private static final ObjectArrayList<Vec3i> NON_CORNER_NEIGHBOURS = (ObjectArrayList)Util.make((Object)new ObjectArrayList(18), p_222338_ -> BlockPos.betweenClosedStream((BlockPos)new BlockPos(-1, -1, -1), (BlockPos)new BlockPos(1, 1, 1)).filter(p_222336_ -> (p_222336_.getX() == 0 || p_222336_.getY() == 0 || p_222336_.getZ() == 0) && !p_222336_.equals((Object)BlockPos.ZERO)).map(BlockPos::immutable).forEach(arg_0 -> ((ObjectArrayList)p_222338_).add(arg_0)));
        public static final int MAX_CURSOR_DECAY_DELAY = 1;
        private BlockPos pos;
        int charge;
        private int updateDelay;
        private int decayDelay;
        @Nullable
        private Set<Direction> facings;
        private static final Codec<Set<Direction>> DIRECTION_SET = Direction.CODEC.listOf().xmap(p_222340_ -> Sets.newEnumSet((Iterable)p_222340_, Direction.class), Lists::newArrayList);
        public static final Codec<ChargeCursor> CODEC = RecordCodecBuilder.create(p_222330_ -> p_222330_.group((App)BlockPos.CODEC.fieldOf("pos").forGetter(ChargeCursor::getPos), (App)Codec.intRange((int)0, (int)1000).fieldOf("charge").orElse((Object)0).forGetter(ChargeCursor::getCharge), (App)Codec.intRange((int)0, (int)1).fieldOf("decay_delay").orElse((Object)1).forGetter(ChargeCursor::getDecayDelay), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("update_delay").orElse((Object)0).forGetter(p_222346_ -> p_222346_.updateDelay), (App)DIRECTION_SET.lenientOptionalFieldOf("facings").forGetter(p_222343_ -> Optional.ofNullable(p_222343_.getFacingData()))).apply((Applicative)p_222330_, ChargeCursor::new));

        private ChargeCursor(BlockPos pos, int charge, int decayDelay, int updateDelay, Optional<Set<Direction>> facings) {
            this.pos = pos;
            this.charge = charge;
            this.decayDelay = decayDelay;
            this.updateDelay = updateDelay;
            this.facings = facings.orElse(null);
        }

        public ChargeCursor(BlockPos pos, int charge) {
            this(pos, charge, 1, 0, Optional.empty());
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public int getCharge() {
            return this.charge;
        }

        public int getDecayDelay() {
            return this.decayDelay;
        }

        @Nullable
        public Set<Direction> getFacingData() {
            return this.facings;
        }

        private boolean shouldUpdate(LevelAccessor level, BlockPos pos, boolean isWorldGeneration) {
            boolean bl;
            if (this.charge <= 0) {
                return false;
            }
            if (isWorldGeneration) {
                return true;
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                bl = serverlevel.shouldTickBlocksAt(pos);
            } else {
                bl = false;
            }
            return bl;
        }

        public void update(LevelAccessor level, BlockPos pos, RandomSource random, WebSpreader spreader, boolean shouldConvertBlocks) {
            if (this.shouldUpdate(level, pos, spreader.isWorldGeneration)) {
                if (this.updateDelay > 0) {
                    --this.updateDelay;
                } else {
                    BlockState blockstate = level.getBlockState(this.pos);
                    WebVeinBehavior sculkbehaviour = ChargeCursor.getBlockBehaviour(blockstate);
                    if (shouldConvertBlocks && sculkbehaviour.attemptSpreadVein(level, this.pos, blockstate, this.facings, spreader.isWorldGeneration())) {
                        if (sculkbehaviour.canChangeBlockStateOnSpread()) {
                            blockstate = level.getBlockState(this.pos);
                            sculkbehaviour = ChargeCursor.getBlockBehaviour(blockstate);
                        }
                        level.playSound(null, this.pos, SoundEvents.SCULK_BLOCK_SPREAD, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    this.charge = sculkbehaviour.attemptUseCharge(this, level, pos, random, spreader, shouldConvertBlocks);
                    if (this.charge <= 0) {
                        sculkbehaviour.onDischarged(level, blockstate, this.pos, random);
                    } else {
                        BlockPos blockpos = ChargeCursor.getValidMovementPos(level, this.pos, random);
                        if (blockpos != null) {
                            sculkbehaviour.onDischarged(level, blockstate, this.pos, random);
                            this.pos = blockpos.immutable();
                            if (spreader.isWorldGeneration() && !this.pos.closerThan(new Vec3i(pos.getX(), this.pos.getY(), pos.getZ()), 15.0)) {
                                this.charge = 0;
                                return;
                            }
                            blockstate = level.getBlockState(blockpos);
                        }
                        if (blockstate.getBlock() instanceof WebVeinBehavior) {
                            this.facings = MultifaceBlock.availableFaces((BlockState)blockstate);
                        }
                        this.decayDelay = sculkbehaviour.updateDecayDelay(this.decayDelay);
                        this.updateDelay = sculkbehaviour.getSculkSpreadDelay();
                    }
                }
            }
        }

        void mergeWith(ChargeCursor cursor) {
            this.charge += cursor.charge;
            cursor.charge = 0;
            this.updateDelay = Math.min(this.updateDelay, cursor.updateDelay);
        }

        private static WebVeinBehavior getBlockBehaviour(BlockState state) {
            WebVeinBehavior sculkbehaviour;
            Block block = state.getBlock();
            return block instanceof WebVeinBehavior ? (sculkbehaviour = (WebVeinBehavior)block) : WebVeinBehavior.DEFAULT;
        }

        private static List<Vec3i> getRandomizedNonCornerNeighbourOffsets(RandomSource random) {
            return Util.shuffledCopy(NON_CORNER_NEIGHBOURS, (RandomSource)random);
        }

        @Nullable
        private static BlockPos getValidMovementPos(LevelAccessor level, BlockPos pos, RandomSource random) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.mutable();
            BlockPos.MutableBlockPos blockpos$mutableblockpos1 = pos.mutable();
            for (Vec3i vec3i : ChargeCursor.getRandomizedNonCornerNeighbourOffsets(random)) {
                blockpos$mutableblockpos1.setWithOffset((Vec3i)pos, vec3i);
                BlockState blockstate = level.getBlockState((BlockPos)blockpos$mutableblockpos1);
                if (!(blockstate.getBlock() instanceof WebVeinBehavior) || !ChargeCursor.isMovementUnobstructed(level, pos, (BlockPos)blockpos$mutableblockpos1)) continue;
                blockpos$mutableblockpos.set((Vec3i)blockpos$mutableblockpos1);
                if (!SculkVeinBlock.hasSubstrateAccess((LevelAccessor)level, (BlockState)blockstate, (BlockPos)blockpos$mutableblockpos1)) continue;
                break;
            }
            return blockpos$mutableblockpos.equals((Object)pos) ? null : blockpos$mutableblockpos;
        }

        private static boolean isMovementUnobstructed(LevelAccessor level, BlockPos fromPos, BlockPos toPos) {
            if (fromPos.distManhattan((Vec3i)toPos) == 1) {
                return true;
            }
            BlockPos blockpos = toPos.subtract((Vec3i)fromPos);
            Direction direction = Direction.fromAxisAndDirection((Direction.Axis)Direction.Axis.X, (Direction.AxisDirection)(blockpos.getX() < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE));
            Direction direction1 = Direction.fromAxisAndDirection((Direction.Axis)Direction.Axis.Y, (Direction.AxisDirection)(blockpos.getY() < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE));
            Direction direction2 = Direction.fromAxisAndDirection((Direction.Axis)Direction.Axis.Z, (Direction.AxisDirection)(blockpos.getZ() < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE));
            if (blockpos.getX() == 0) {
                return ChargeCursor.isUnobstructed(level, fromPos, direction1) || ChargeCursor.isUnobstructed(level, fromPos, direction2);
            }
            return blockpos.getY() == 0 ? ChargeCursor.isUnobstructed(level, fromPos, direction) || ChargeCursor.isUnobstructed(level, fromPos, direction2) : ChargeCursor.isUnobstructed(level, fromPos, direction) || ChargeCursor.isUnobstructed(level, fromPos, direction1);
        }

        private static boolean isUnobstructed(LevelAccessor level, BlockPos pos, Direction direction) {
            BlockPos blockpos = pos.relative(direction);
            return !level.getBlockState(blockpos).isFaceSturdy((BlockGetter)level, blockpos, direction.getOpposite());
        }
    }
}

