/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.block.custom.web_vein;

import com.mojang.serialization.MapCodec;
import net.luckystudio.spelunkers_charm.block.custom.web_vein.WebSpreader;
import net.luckystudio.spelunkers_charm.block.custom.web_vein.WebVeinBehavior;
import net.luckystudio.spelunkers_charm.init.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WebVeinBlock
extends MultifaceBlock
implements WebVeinBehavior {
    private static final VoxelShape UP_AABB = Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final MapCodec<WebVeinBlock> CODEC = WebVeinBlock.simpleCodec(WebVeinBlock::new);
    private final MultifaceSpreader veinSpreader = new MultifaceSpreader((MultifaceSpreader.SpreadConfig)new VeinSpreaderConfig(this, MultifaceSpreader.DEFAULT_SPREAD_ORDER));
    private final MultifaceSpreader sameSpaceSpreader = new MultifaceSpreader((MultifaceSpreader.SpreadConfig)new VeinSpreaderConfig(this, MultifaceSpreader.SpreadType.SAME_POSITION));

    public WebVeinBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState(this.defaultBlockState());
    }

    protected MapCodec<WebVeinBlock> codec() {
        return CODEC;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return UP_AABB;
    }

    public MultifaceSpreader getSpreader() {
        return this.veinSpreader;
    }

    public MultifaceSpreader getSameSpaceSpreader() {
        return this.sameSpaceSpreader;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return super.canSurvive(state, level, pos);
    }

    protected boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return !useContext.getItemInHand().is(this.asItem()) || super.canBeReplaced(state, useContext);
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        double d0 = Math.abs(entity.getDeltaMovement().y);
        if (d0 < 0.1 && !entity.isSteppingCarefully()) {
            double d1 = 0.4 + d0 * 0.2;
            entity.setDeltaMovement(entity.getDeltaMovement().multiply(d1, 1.0, d1));
        }
        super.stepOn(level, pos, state, entity);
    }

    @Override
    public int attemptUseCharge(WebSpreader.ChargeCursor cursor, LevelAccessor level, BlockPos pos, RandomSource random, WebSpreader spreader, boolean shouldConvertBlocks) {
        if (shouldConvertBlocks && this.attemptPlaceWeb(spreader, level, cursor.getPos(), random)) {
            return cursor.getCharge() - 1;
        }
        return random.nextInt(spreader.chargeDecayRate()) == 0 ? Mth.floor((float)((float)cursor.getCharge() * 0.5f)) : cursor.getCharge();
    }

    private boolean attemptPlaceWeb(WebSpreader spreader, LevelAccessor level, BlockPos pos, RandomSource random) {
        BlockState blockstate = level.getBlockState(pos);
        TagKey<Block> tagkey = spreader.replaceableBlocks();
        for (Direction direction : Direction.allShuffled((RandomSource)random)) {
            BlockPos blockpos;
            BlockState blockstate1;
            if (!WebVeinBlock.hasFace((BlockState)blockstate, (Direction)direction) || !(blockstate1 = level.getBlockState(blockpos = pos.relative(direction))).is(tagkey)) continue;
            BlockState blockstate2 = ((Block)ModBlocks.PACKED_WEB.get()).defaultBlockState();
            level.setBlock(blockpos, blockstate2, 3);
            Block.pushEntitiesUp((BlockState)blockstate1, (BlockState)blockstate2, (LevelAccessor)level, (BlockPos)blockpos);
            level.playSound(null, blockpos, SoundEvents.SCULK_BLOCK_SPREAD, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.veinSpreader.spreadAll(blockstate2, level, blockpos, spreader.isWorldGeneration());
            Direction direction1 = direction.getOpposite();
            for (Direction direction2 : DIRECTIONS) {
                BlockPos blockpos1;
                BlockState blockstate3;
                if (direction2 == direction1 || !(blockstate3 = level.getBlockState(blockpos1 = blockpos.relative(direction2))).is((Block)this)) continue;
                this.onDischarged(level, blockstate3, blockpos1, random);
            }
            return true;
        }
        return false;
    }

    class VeinSpreaderConfig
    extends MultifaceSpreader.DefaultSpreaderConfig {
        private final MultifaceSpreader.SpreadType[] spreadTypes;

        public VeinSpreaderConfig(WebVeinBlock this$0, MultifaceSpreader.SpreadType ... spreadTypes) {
            super((MultifaceBlock)this$0);
            this.spreadTypes = spreadTypes;
        }

        public boolean stateCanBeReplaced(BlockGetter level, BlockPos pos, BlockPos spreadPos, Direction direction, BlockState state) {
            BlockState blockstate = level.getBlockState(spreadPos.relative(direction));
            if (!(blockstate.is(ModBlocks.PACKED_WEB) || blockstate.is(ModBlocks.SPIDER_EGG) || blockstate.is(Blocks.MOVING_PISTON))) {
                BlockPos blockpos;
                if (pos.distManhattan((Vec3i)spreadPos) == 2 && level.getBlockState(blockpos = pos.relative(direction.getOpposite())).isFaceSturdy(level, blockpos, direction)) {
                    return false;
                }
                FluidState fluidstate = state.getFluidState();
                if (!fluidstate.isEmpty() && !fluidstate.is((Fluid)Fluids.WATER)) {
                    return false;
                }
                return state.is(BlockTags.FIRE) ? false : state.canBeReplaced() || super.stateCanBeReplaced(level, pos, spreadPos, direction, state);
            }
            return false;
        }

        public MultifaceSpreader.SpreadType[] getSpreadTypes() {
            return this.spreadTypes;
        }

        public boolean isOtherBlockValidAsSource(BlockState otherBlock) {
            return !otherBlock.is(ModBlocks.WEB_VEIN);
        }
    }
}

