/*
 * Decompiled with CFR 0.152.
 */
package net.luckystudio.spelunkers_charm.datagen;

import java.util.List;
import java.util.Set;
import net.luckystudio.spelunkers_charm.block.util.ModBlockStateProperties;
import net.luckystudio.spelunkers_charm.init.ModBlocks;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.jetbrains.annotations.NotNull;

public class ModBlockLootTableProvider
extends BlockLootSubProvider {
    protected ModBlockLootTableProvider(HolderLookup.Provider registries) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), registries);
    }

    protected void generate() {
        this.add((Block)ModBlocks.DUNESTONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)ModBlocks.COBBLED_DUNESTONE));
        this.dropSelf((Block)ModBlocks.DUNESTONE_STAIRS.get());
        this.dropSelf((Block)ModBlocks.DUNESTONE_SLAB.get());
        this.dropSelf((Block)ModBlocks.DUNESTONE_WALL.get());
        this.dropSelf((Block)ModBlocks.DUNESTONE_BRICKS.get());
        this.dropSelf((Block)ModBlocks.DUNESTONE_BRICK_STAIRS.get());
        this.dropSelf((Block)ModBlocks.DUNESTONE_BRICK_SLAB.get());
        this.dropSelf((Block)ModBlocks.DUNESTONE_BRICK_WALL.get());
        this.dropSelf((Block)ModBlocks.CHISELED_DUNESTONE_BRICKS.get());
        this.dropSelf((Block)ModBlocks.COBBLED_DUNESTONE.get());
        this.dropSelf((Block)ModBlocks.COBBLED_DUNESTONE_STAIRS.get());
        this.dropSelf((Block)ModBlocks.COBBLED_DUNESTONE_SLAB.get());
        this.dropSelf((Block)ModBlocks.COBBLED_DUNESTONE_WALL.get());
        this.add((Block)ModBlocks.PERMAFROST.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)ModBlocks.COBBLED_PERMAFROST));
        this.dropSelf((Block)ModBlocks.PERMAFROST_STAIRS.get());
        this.dropSelf((Block)ModBlocks.PERMAFROST_SLAB.get());
        this.dropSelf((Block)ModBlocks.PERMAFROST_WALL.get());
        this.dropSelf((Block)ModBlocks.PERMAFROST_BRICKS.get());
        this.dropSelf((Block)ModBlocks.PERMAFROST_BRICK_STAIRS.get());
        this.dropSelf((Block)ModBlocks.PERMAFROST_BRICK_SLAB.get());
        this.dropSelf((Block)ModBlocks.PERMAFROST_BRICK_WALL.get());
        this.dropSelf((Block)ModBlocks.CHISELED_PERMAFROST_BRICKS.get());
        this.dropSelf((Block)ModBlocks.COBBLED_PERMAFROST.get());
        this.dropSelf((Block)ModBlocks.COBBLED_PERMAFROST_STAIRS.get());
        this.dropSelf((Block)ModBlocks.COBBLED_PERMAFROST_SLAB.get());
        this.dropSelf((Block)ModBlocks.COBBLED_PERMAFROST_WALL.get());
        this.add((Block)ModBlocks.WILDSTONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)ModBlocks.COBBLED_WILDSTONE));
        this.dropSelf((Block)ModBlocks.WILDSTONE_STAIRS.get());
        this.dropSelf((Block)ModBlocks.WILDSTONE_SLAB.get());
        this.dropSelf((Block)ModBlocks.WILDSTONE_WALL.get());
        this.dropSelf((Block)ModBlocks.WILDSTONE_BRICKS.get());
        this.dropSelf((Block)ModBlocks.WILDSTONE_BRICK_STAIRS.get());
        this.dropSelf((Block)ModBlocks.WILDSTONE_BRICK_SLAB.get());
        this.dropSelf((Block)ModBlocks.WILDSTONE_BRICK_WALL.get());
        this.dropSelf((Block)ModBlocks.CHISELED_WILDSTONE_BRICKS.get());
        this.dropSelf((Block)ModBlocks.COBBLED_WILDSTONE.get());
        this.dropSelf((Block)ModBlocks.COBBLED_WILDSTONE_STAIRS.get());
        this.dropSelf((Block)ModBlocks.COBBLED_WILDSTONE_SLAB.get());
        this.dropSelf((Block)ModBlocks.COBBLED_WILDSTONE_WALL.get());
        this.dropSelf((Block)ModBlocks.AMETHYST_BRICKS.get());
        this.dropSelf((Block)ModBlocks.AMETHYST_BRICK_STAIRS.get());
        this.dropSelf((Block)ModBlocks.AMETHYST_BRICK_SLAB.get());
        this.dropSelf((Block)ModBlocks.AMETHYST_BRICK_WALL.get());
        this.dropSelf((Block)ModBlocks.CHISELED_AMETHYST_BLOCK.get());
        this.add((Block)ModBlocks.SILT.get(), this.createSiltDrops((Block)ModBlocks.SILT.get()));
        this.dropSelf((Block)ModBlocks.ICICLE.get());
        this.add((Block)ModBlocks.DUNESTONE_COAL_ORE.get(), this.createOreDrop((Block)ModBlocks.PERMAFROST_COAL_ORE.get(), Items.COAL));
        this.add((Block)ModBlocks.DUNESTONE_IRON_ORE.get(), this.createOreDrop((Block)ModBlocks.PERMAFROST_IRON_ORE.get(), Items.RAW_IRON));
        this.add((Block)ModBlocks.DUNESTONE_COPPER_ORE.get(), this.createCopperOreDrops((Block)ModBlocks.PERMAFROST_COPPER_ORE.get()));
        this.add((Block)ModBlocks.DUNESTONE_GOLD_ORE.get(), this.createOreDrop((Block)ModBlocks.PERMAFROST_GOLD_ORE.get(), Items.RAW_GOLD));
        this.add((Block)ModBlocks.DUNESTONE_REDSTONE_ORE.get(), this.createRedstoneOreDrops((Block)ModBlocks.PERMAFROST_REDSTONE_ORE.get()));
        this.add((Block)ModBlocks.DUNESTONE_EMERALD_ORE.get(), this.createOreDrop((Block)ModBlocks.PERMAFROST_EMERALD_ORE.get(), Items.EMERALD));
        this.add((Block)ModBlocks.DUNESTONE_LAPIS_ORE.get(), this.createLapisOreDrops((Block)ModBlocks.PERMAFROST_LAPIS_ORE.get()));
        this.add((Block)ModBlocks.DUNESTONE_DIAMOND_ORE.get(), this.createOreDrop((Block)ModBlocks.PERMAFROST_DIAMOND_ORE.get(), Items.DIAMOND));
        this.add((Block)ModBlocks.PERMAFROST_COAL_ORE.get(), this.createOreDrop((Block)ModBlocks.PERMAFROST_COAL_ORE.get(), Items.COAL));
        this.add((Block)ModBlocks.PERMAFROST_IRON_ORE.get(), this.createOreDrop((Block)ModBlocks.PERMAFROST_IRON_ORE.get(), Items.RAW_IRON));
        this.add((Block)ModBlocks.PERMAFROST_COPPER_ORE.get(), this.createCopperOreDrops((Block)ModBlocks.PERMAFROST_COPPER_ORE.get()));
        this.add((Block)ModBlocks.PERMAFROST_GOLD_ORE.get(), this.createOreDrop((Block)ModBlocks.PERMAFROST_GOLD_ORE.get(), Items.RAW_GOLD));
        this.add((Block)ModBlocks.PERMAFROST_REDSTONE_ORE.get(), this.createRedstoneOreDrops((Block)ModBlocks.PERMAFROST_REDSTONE_ORE.get()));
        this.add((Block)ModBlocks.PERMAFROST_EMERALD_ORE.get(), this.createOreDrop((Block)ModBlocks.PERMAFROST_EMERALD_ORE.get(), Items.EMERALD));
        this.add((Block)ModBlocks.PERMAFROST_LAPIS_ORE.get(), this.createLapisOreDrops((Block)ModBlocks.PERMAFROST_LAPIS_ORE.get()));
        this.add((Block)ModBlocks.PERMAFROST_DIAMOND_ORE.get(), this.createOreDrop((Block)ModBlocks.PERMAFROST_DIAMOND_ORE.get(), Items.DIAMOND));
        this.add((Block)ModBlocks.WILDSTONE_COAL_ORE.get(), this.createOreDrop((Block)ModBlocks.WILDSTONE_COAL_ORE.get(), Items.COAL));
        this.add((Block)ModBlocks.WILDSTONE_IRON_ORE.get(), this.createOreDrop((Block)ModBlocks.WILDSTONE_IRON_ORE.get(), Items.RAW_IRON));
        this.add((Block)ModBlocks.WILDSTONE_COPPER_ORE.get(), this.createCopperOreDrops((Block)ModBlocks.WILDSTONE_COPPER_ORE.get()));
        this.add((Block)ModBlocks.WILDSTONE_GOLD_ORE.get(), this.createOreDrop((Block)ModBlocks.WILDSTONE_GOLD_ORE.get(), Items.RAW_GOLD));
        this.add((Block)ModBlocks.WILDSTONE_REDSTONE_ORE.get(), this.createRedstoneOreDrops((Block)ModBlocks.WILDSTONE_REDSTONE_ORE.get()));
        this.add((Block)ModBlocks.WILDSTONE_EMERALD_ORE.get(), this.createOreDrop((Block)ModBlocks.WILDSTONE_EMERALD_ORE.get(), Items.EMERALD));
        this.add((Block)ModBlocks.WILDSTONE_LAPIS_ORE.get(), this.createLapisOreDrops((Block)ModBlocks.WILDSTONE_LAPIS_ORE.get()));
        this.add((Block)ModBlocks.WILDSTONE_DIAMOND_ORE.get(), this.createOreDrop((Block)ModBlocks.WILDSTONE_DIAMOND_ORE.get(), Items.DIAMOND));
        this.add((Block)ModBlocks.BOULDER.get(), this.createOreDrop(Blocks.STONE, Items.COBBLESTONE));
        this.add((Block)ModBlocks.IRON_BOULDER.get(), this.createBoulderDrops(Blocks.RAW_IRON_BLOCK, (ItemLike)Items.RAW_IRON));
        this.add((Block)ModBlocks.COPPER_BOULDER.get(), this.createBoulderDrops(Blocks.RAW_COPPER_BLOCK, (ItemLike)Items.RAW_COPPER));
        this.add((Block)ModBlocks.GOLD_BOULDER.get(), this.createBoulderDrops(Blocks.RAW_GOLD_BLOCK, (ItemLike)Items.RAW_GOLD));
        this.add((Block)ModBlocks.LUSH_BOULDER.get(), this.createOreDrop(Blocks.STONE, Items.COBBLESTONE));
        this.add((Block)ModBlocks.LUSH_IRON_BOULDER.get(), this.createBoulderDrops(Blocks.RAW_IRON_BLOCK, (ItemLike)Items.RAW_IRON));
        this.add((Block)ModBlocks.LUSH_COPPER_BOULDER.get(), this.createBoulderDrops(Blocks.RAW_COPPER_BLOCK, (ItemLike)Items.RAW_COPPER));
        this.add((Block)ModBlocks.LUSH_GOLD_BOULDER.get(), this.createBoulderDrops(Blocks.RAW_GOLD_BLOCK, (ItemLike)Items.RAW_GOLD));
        this.add((Block)ModBlocks.CAVE_MUSHROOM_BLOCK.get(), this.createMushroomBlockDrop((Block)ModBlocks.CAVE_MUSHROOM_BLOCK.get(), (ItemLike)ModBlocks.CAVE_MUSHROOM));
        this.dropSelf((Block)ModBlocks.CAVE_MUSHROOM.get());
        this.dropOther((Block)ModBlocks.CLAY_PILE.get(), (ItemLike)Items.CLAY_BALL);
        this.rockDrops((Block)ModBlocks.ROCK.get());
        this.rockDrops((Block)ModBlocks.ICE_BALL.get());
        this.rockDrops((Block)ModBlocks.DEEPSLATE_ROCK.get());
        this.rockDrops((Block)ModBlocks.DRIPSTONE_ROCK.get());
        this.rockDrops((Block)ModBlocks.BASALT_ROCK.get());
        this.add((Block)ModBlocks.PACKED_WEB.get(), this.createOreDrop((Block)ModBlocks.PACKED_WEB.get(), Items.STRING));
        this.add((Block)ModBlocks.WEB_VEIN.get(), this.createOreDrop((Block)ModBlocks.WEB_VEIN.get(), Items.STRING));
        this.add((Block)ModBlocks.HANGING_WEB.get(), this.createOreDrop((Block)ModBlocks.HANGING_WEB.get(), Items.STRING));
        this.dropWhenSilkTouch((Block)ModBlocks.SPIDER_EGG.get());
        this.add((Block)ModBlocks.DEEPSLATE_GEYSER.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.COBBLED_DEEPSLATE));
        this.add((Block)ModBlocks.BASALT_GEYSER.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.BASALT));
        this.dropSelf((Block)ModBlocks.BLASTER.get());
        this.dropSelf((Block)ModBlocks.WOODEN_LIFT_TRACK.get());
        this.dropSelf((Block)ModBlocks.POWERED_LIFT_TRACK.get());
    }

    protected LootTable.Builder createBoulderDrops(Block block, ItemLike drop) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchDispatchTable(block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)drop).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)5.0f, (float)8.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE)))));
    }

    private LootTable.Builder createSiltDrops(Block block) {
        HolderLookup.RegistryLookup enchantments = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        LootPool.Builder noSilkTouchPool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.doesNotHaveSilkTouch()).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)block).when(LootItemRandomChanceCondition.randomChance((float)0.85f)))).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.FLINT).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)5.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)enchantments.getOrThrow(Enchantments.FORTUNE))).when(LootItemRandomChanceCondition.randomChance((float)0.15f)))).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.BONE).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)5.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)enchantments.getOrThrow(Enchantments.FORTUNE))).when(LootItemRandomChanceCondition.randomChance((float)0.15f)))).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.IRON_NUGGET).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)5.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)enchantments.getOrThrow(Enchantments.FORTUNE))).when(LootItemRandomChanceCondition.randomChance((float)0.1f)))).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.GOLD_NUGGET).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)5.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)enchantments.getOrThrow(Enchantments.FORTUNE))).when(LootItemRandomChanceCondition.randomChance((float)0.05f))));
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.hasSilkTouch()).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block))).withPool(noSilkTouchPool);
    }

    private void rockDrops(Block block) {
        if (block == ModBlocks.CLAY_PILE.get()) {
            this.add(block, this.createRockDrops(block, (ItemLike)Items.CLAY_BALL));
        } else {
            this.add(block, this.createRockDrops(block, (ItemLike)block));
        }
    }

    private LootTable.Builder createRockDrops(Block block, ItemLike drop) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay(drop, LootItem.lootTableItem((ItemLike)block).apply(List.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)), amount -> SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)amount.intValue())).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)ModBlockStateProperties.ROCKS, amount.intValue())))))));
    }

    @NotNull
    protected Iterable<Block> getKnownBlocks() {
        return ModBlocks.BLOCKS.getEntries().stream().map(Holder::value)::iterator;
    }
}

